/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQProperties;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.normalization.DistinctNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.impl.InjectiveBindingLiftState;
import it.unibz.inf.ontop.utils.VariableGenerator;

@Singleton
public class DistinctNormalizerImpl
implements DistinctNormalizer {
    private static final int MAX_ITERATIONS = 10000;
    private final IntermediateQueryFactory iqFactory;
    private final CoreSingletons coreSingletons;

    @Inject
    private DistinctNormalizerImpl(IntermediateQueryFactory iqFactory, CoreSingletons coreSingletons) {
        this.iqFactory = iqFactory;
        this.coreSingletons = coreSingletons;
    }

    @Override
    public IQTree normalizeForOptimization(DistinctNode distinctNode, IQTree child, VariableGenerator variableGenerator, IQProperties currentIQProperties) {
        IQTree normalizedChild = child.normalizeForOptimization(variableGenerator);
        return this.liftBinding(distinctNode, normalizedChild, variableGenerator, currentIQProperties);
    }

    private IQTree liftBinding(DistinctNode distinctNode, IQTree newChild, VariableGenerator variableGenerator, IQProperties currentIQProperties) {
        QueryNode newChildRoot = newChild.getRootNode();
        if (newChildRoot instanceof ConstructionNode) {
            return this.liftBindingConstructionChild((ConstructionNode)newChildRoot, currentIQProperties, (UnaryIQTree)newChild, variableGenerator);
        }
        if (newChildRoot instanceof EmptyNode) {
            return newChild;
        }
        return this.createDistinctTree(distinctNode, newChild, currentIQProperties.declareNormalizedForOptimization());
    }

    private IQTree createDistinctTree(DistinctNode distinctNode, IQTree child, IQProperties iqProperties) {
        return child.isDistinct() ? child : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)distinctNode, child, iqProperties);
    }

    private IQTree liftBindingConstructionChild(ConstructionNode constructionNode, IQProperties currentIQProperties, UnaryIQTree child, VariableGenerator variableGenerator) {
        InjectiveBindingLiftState state = new InjectiveBindingLiftState(constructionNode, child.getChild(), variableGenerator, this.coreSingletons);
        for (int i = 0; i < 10000; ++i) {
            InjectiveBindingLiftState newState = state.liftBindings();
            if (newState.equals(state)) {
                return this.createNormalizedTree(newState, currentIQProperties, variableGenerator);
            }
            state = newState;
        }
        throw new MinorOntopInternalBugException("DistinctNormalizerImpl.liftBindingConstructionChild() did not converge after 10000");
    }

    public IQTree createNormalizedTree(InjectiveBindingLiftState state, IQProperties currentIQProperties, VariableGenerator variableGenerator) {
        IntermediateQueryFactory iqFactory = this.coreSingletons.getIQFactory();
        IQTree grandChildTree = state.getGrandChildTree();
        IQTree newGrandChildTree = grandChildTree.getRootNode() instanceof DistinctNode ? ((UnaryIQTree)grandChildTree).getChild() : grandChildTree;
        IQProperties childProperties = newGrandChildTree == grandChildTree ? iqFactory.createIQProperties().declareNormalizedForOptimization() : iqFactory.createIQProperties();
        IQTree newChildTree = state.getChildConstructionNode().map(c -> iqFactory.createUnaryIQTree((UnaryOperatorNode)c, newGrandChildTree, childProperties)).map(t -> t.normalizeForOptimization(variableGenerator)).orElse(newGrandChildTree);
        IQTree distinctTree = this.createDistinctTree(iqFactory.createDistinctNode(), newChildTree, currentIQProperties.declareNormalizedForOptimization());
        return state.getAncestors().reverse().stream().reduce(distinctTree, (t, a) -> iqFactory.createUnaryIQTree((UnaryOperatorNode)a, (IQTree)t), (t1, t2) -> {
            throw new MinorOntopInternalBugException("No merge was expected");
        }).normalizeForOptimization(variableGenerator);
    }
}

