/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.UnsatisfiableConditionException;
import it.unibz.inf.ontop.iq.node.normalization.ConditionSimplifier;
import it.unibz.inf.ontop.iq.node.normalization.impl.ExpressionAndSubstitutionImpl;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBStrictEqFunctionSymbol;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.ImmutableSubstitutionTools;
import it.unibz.inf.ontop.substitution.impl.ImmutableUnificationTools;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

@Singleton
public class ConditionSimplifierImpl
implements ConditionSimplifier {
    private final SubstitutionFactory substitutionFactory;
    private final TermFactory termFactory;
    private final ImmutableUnificationTools unificationTools;
    private final ImmutableSubstitutionTools substitutionTools;

    @Inject
    private ConditionSimplifierImpl(SubstitutionFactory substitutionFactory, TermFactory termFactory, ImmutableUnificationTools unificationTools, ImmutableSubstitutionTools substitutionTools) {
        this.substitutionFactory = substitutionFactory;
        this.termFactory = termFactory;
        this.unificationTools = unificationTools;
        this.substitutionTools = substitutionTools;
    }

    @Override
    public ConditionSimplifier.ExpressionAndSubstitution simplifyCondition(ImmutableExpression expression, VariableNullability variableNullability) throws UnsatisfiableConditionException {
        return this.simplifyCondition(Optional.of(expression), (ImmutableSet<Variable>)ImmutableSet.of(), variableNullability);
    }

    @Override
    public ConditionSimplifier.ExpressionAndSubstitution simplifyCondition(Optional<ImmutableExpression> nonOptimizedExpression, ImmutableSet<Variable> nonLiftableVariables, VariableNullability variableNullability) throws UnsatisfiableConditionException {
        Optional<ImmutableExpression.Evaluation> optionalEvaluationResults = nonOptimizedExpression.map(expression -> expression.evaluate2VL(variableNullability));
        if (optionalEvaluationResults.isPresent()) {
            ImmutableExpression.Evaluation results = optionalEvaluationResults.get();
            if (results.isEffectiveFalse()) {
                throw new UnsatisfiableConditionException();
            }
            Optional<ImmutableExpression> optionalExpression = results.getExpression();
            if (optionalExpression.isPresent()) {
                return this.convertIntoExpressionAndSubstitution(optionalExpression.get(), nonLiftableVariables);
            }
            return new ExpressionAndSubstitutionImpl(Optional.empty(), this.substitutionFactory.getSubstitution());
        }
        return new ExpressionAndSubstitutionImpl(Optional.empty(), this.substitutionFactory.getSubstitution());
    }

    private ConditionSimplifier.ExpressionAndSubstitution convertIntoExpressionAndSubstitution(ImmutableExpression expression, ImmutableSet<Variable> nonLiftableVariables) throws UnsatisfiableConditionException {
        ImmutableSet expressions = (ImmutableSet)expression.flattenAND().collect(ImmutableCollectors.toSet());
        ImmutableSet functionFreeEqualities = (ImmutableSet)expressions.stream().filter(e -> e.getFunctionSymbol() instanceof DBStrictEqFunctionSymbol).filter(e -> {
            ImmutableList<? extends ImmutableTerm> arguments = e.getTerms();
            return arguments.stream().allMatch(t -> t instanceof NonFunctionalTerm);
        }).collect(ImmutableCollectors.toSet());
        ImmutableSubstitution<NonFunctionalTerm> normalizedUnifier = this.unify(functionFreeEqualities.stream().map(ImmutableFunctionalTerm::getTerms).map(args -> Maps.immutableEntry((Object)((NonFunctionalTerm)args.get(0)), (Object)((NonFunctionalTerm)args.get(1)))), nonLiftableVariables);
        Optional<ImmutableExpression> newExpression = this.termFactory.getConjunction(Stream.concat(expressions.stream().filter(e -> !functionFreeEqualities.contains(e)).map(normalizedUnifier::applyToBooleanExpression), normalizedUnifier.getImmutableMap().entrySet().stream().filter(e -> nonLiftableVariables.contains(e.getKey())).map(e -> this.termFactory.getStrictEquality((ImmutableTerm)e.getKey(), (ImmutableTerm)e.getValue(), new ImmutableTerm[0]))));
        ImmutableSubstitution<NonFunctionalTerm> ascendingSubstitution = this.substitutionFactory.getSubstitution(normalizedUnifier.getImmutableMap().entrySet().stream().filter(e -> !nonLiftableVariables.contains(e.getKey())).collect(ImmutableCollectors.toMap()));
        return new ExpressionAndSubstitutionImpl(newExpression, ascendingSubstitution);
    }

    private ImmutableSubstitution<NonFunctionalTerm> unify(Stream<Map.Entry<NonFunctionalTerm, NonFunctionalTerm>> equalityStream, ImmutableSet<Variable> nonLiftableVariables) throws UnsatisfiableConditionException {
        ImmutableList equalities = (ImmutableList)equalityStream.collect(ImmutableCollectors.toList());
        ImmutableList args1 = (ImmutableList)equalities.stream().map(Map.Entry::getKey).collect(ImmutableCollectors.toList());
        ImmutableList args2 = (ImmutableList)equalities.stream().map(Map.Entry::getValue).collect(ImmutableCollectors.toList());
        return this.unificationTools.computeMGU(args1, args2).map(u -> this.substitutionTools.prioritizeRenaming(u, nonLiftableVariables)).orElseThrow(UnsatisfiableConditionException::new);
    }

    @Override
    public Optional<ImmutableExpression> computeDownConstraint(Optional<ImmutableExpression> optionalConstraint, ConditionSimplifier.ExpressionAndSubstitution conditionSimplificationResults, VariableNullability childVariableNullability) throws UnsatisfiableConditionException {
        if (optionalConstraint.isPresent()) {
            ImmutableExpression substitutedConstraint = conditionSimplificationResults.getSubstitution().applyToBooleanExpression(optionalConstraint.get());
            ImmutableExpression combinedExpression = conditionSimplificationResults.getOptionalExpression().flatMap(e -> this.termFactory.getConjunction(Stream.concat(e.flattenAND(), substitutedConstraint.flattenAND()))).orElse(substitutedConstraint);
            ImmutableExpression.Evaluation evaluationResults = combinedExpression.evaluate2VL(childVariableNullability);
            if (evaluationResults.isEffectiveFalse()) {
                throw new UnsatisfiableConditionException();
            }
            return evaluationResults.getExpression();
        }
        return conditionSimplificationResults.getOptionalExpression();
    }
}

