/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.evaluator.TermNullabilityEvaluator;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQProperties;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.ConstructionNodeTools;
import it.unibz.inf.ontop.iq.node.impl.JoinLikeNodeImpl;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterVariableNullabilityTools;
import it.unibz.inf.ontop.iq.node.impl.UnsatisfiableConditionException;
import it.unibz.inf.ontop.iq.node.normalization.ConditionSimplifier;
import it.unibz.inf.ontop.iq.node.normalization.InnerJoinNormalizer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.ImmutableSubstitutionTools;
import it.unibz.inf.ontop.substitution.impl.ImmutableUnificationTools;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class InnerJoinNodeImpl
extends JoinLikeNodeImpl
implements InnerJoinNode {
    private static final String JOIN_NODE_STR = "JOIN";
    private final ConstructionNodeTools constructionNodeTools;
    private final JoinOrFilterVariableNullabilityTools variableNullabilityTools;
    private final ConditionSimplifier conditionSimplifier;
    private final InnerJoinNormalizer normalizer;

    @AssistedInject
    protected InnerJoinNodeImpl(@Assisted Optional<ImmutableExpression> optionalFilterCondition, TermNullabilityEvaluator nullabilityEvaluator, TermFactory termFactory, TypeFactory typeFactory, IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, ConstructionNodeTools constructionNodeTools, ImmutableUnificationTools unificationTools, ImmutableSubstitutionTools substitutionTools, JoinOrFilterVariableNullabilityTools variableNullabilityTools, ConditionSimplifier conditionSimplifier, InnerJoinNormalizer normalizer) {
        super(optionalFilterCondition, nullabilityEvaluator, termFactory, iqFactory, typeFactory, substitutionFactory, unificationTools, substitutionTools);
        this.constructionNodeTools = constructionNodeTools;
        this.variableNullabilityTools = variableNullabilityTools;
        this.conditionSimplifier = conditionSimplifier;
        this.normalizer = normalizer;
    }

    @AssistedInject
    private InnerJoinNodeImpl(@Assisted ImmutableExpression joiningCondition, TermNullabilityEvaluator nullabilityEvaluator, TermFactory termFactory, TypeFactory typeFactory, IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, ConstructionNodeTools constructionNodeTools, ImmutableUnificationTools unificationTools, ImmutableSubstitutionTools substitutionTools, JoinOrFilterVariableNullabilityTools variableNullabilityTools, ConditionSimplifier conditionSimplifier, InnerJoinNormalizer normalizer) {
        super(Optional.of(joiningCondition), nullabilityEvaluator, termFactory, iqFactory, typeFactory, substitutionFactory, unificationTools, substitutionTools);
        this.constructionNodeTools = constructionNodeTools;
        this.variableNullabilityTools = variableNullabilityTools;
        this.conditionSimplifier = conditionSimplifier;
        this.normalizer = normalizer;
    }

    @AssistedInject
    private InnerJoinNodeImpl(TermNullabilityEvaluator nullabilityEvaluator, TermFactory termFactory, TypeFactory typeFactory, IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, ConstructionNodeTools constructionNodeTools, ImmutableUnificationTools unificationTools, ImmutableSubstitutionTools substitutionTools, JoinOrFilterVariableNullabilityTools variableNullabilityTools, ConditionSimplifier conditionSimplifier, InnerJoinNormalizer normalizer) {
        super(Optional.empty(), nullabilityEvaluator, termFactory, iqFactory, typeFactory, substitutionFactory, unificationTools, substitutionTools);
        this.constructionNodeTools = constructionNodeTools;
        this.variableNullabilityTools = variableNullabilityTools;
        this.conditionSimplifier = conditionSimplifier;
        this.normalizer = normalizer;
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public InnerJoinNode clone() {
        return this.iqFactory.createInnerJoinNode(this.getOptionalFilterCondition());
    }

    @Override
    public InnerJoinNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public ImmutableSet<ImmutableSubstitution<NonVariableTerm>> getPossibleVariableDefinitions(ImmutableList<IQTree> children) {
        return children.stream().map(IQTree::getPossibleVariableDefinitions).filter(s -> !s.isEmpty()).reduce(ImmutableSet.of(), this::combineVarDefs);
    }

    private ImmutableSet<ImmutableSubstitution<NonVariableTerm>> combineVarDefs(ImmutableSet<ImmutableSubstitution<NonVariableTerm>> s1, ImmutableSet<ImmutableSubstitution<NonVariableTerm>> s2) {
        return s1.isEmpty() ? s2 : (ImmutableSet)s1.stream().flatMap(d1 -> s2.stream().map(d2 -> d2.composeWith2(d1))).collect(ImmutableCollectors.toSet());
    }

    @Override
    public InnerJoinNode changeOptionalFilterCondition(Optional<ImmutableExpression> newOptionalFilterCondition) {
        return this.iqFactory.createInnerJoinNode(newOptionalFilterCondition);
    }

    @Override
    public boolean isVariableNullable(IntermediateQuery query, Variable variable) {
        if (this.isFilteringNullValue(variable)) {
            return false;
        }
        boolean alsoProjectedByAnotherChild = false;
        for (QueryNode child : query.getChildren(this)) {
            if (!query.getVariables(child).contains((Object)variable)) continue;
            if (alsoProjectedByAnotherChild) {
                return false;
            }
            if (child.isVariableNullable(query, variable)) {
                alsoProjectedByAnotherChild = true;
                continue;
            }
            return false;
        }
        if (!alsoProjectedByAnotherChild) {
            throw new IllegalArgumentException("The variable " + variable + " is not projected by " + this);
        }
        return true;
    }

    @Override
    public boolean isSyntacticallyEquivalentTo(QueryNode node) {
        return node instanceof InnerJoinNode && this.getOptionalFilterCondition().equals(((InnerJoinNode)node).getOptionalFilterCondition());
    }

    @Override
    public boolean isEquivalentTo(QueryNode queryNode) {
        return queryNode instanceof InnerJoinNode && this.getOptionalFilterCondition().equals(((InnerJoinNode)queryNode).getOptionalFilterCondition());
    }

    public String toString() {
        return JOIN_NODE_STR + this.getOptionalFilterString();
    }

    @Override
    public IQTree normalizeForOptimization(ImmutableList<IQTree> children, VariableGenerator variableGenerator, IQProperties currentIQProperties) {
        return this.normalizer.normalizeForOptimization(this, children, variableGenerator, currentIQProperties);
    }

    @Override
    public IQTree applyDescendingSubstitution(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint, ImmutableList<IQTree> children) {
        Optional<ImmutableExpression> unoptimizedExpression = this.getOptionalFilterCondition().map(descendingSubstitution::applyToBooleanExpression);
        VariableNullability dummyVariableNullability = this.variableNullabilityTools.getDummyVariableNullability(this.constructionNodeTools.computeNewProjectedVariables(descendingSubstitution, this.getProjectedVariables(children)));
        try {
            ConditionSimplifier.ExpressionAndSubstitution expressionAndSubstitution = this.conditionSimplifier.simplifyCondition(unoptimizedExpression, (ImmutableSet<Variable>)ImmutableSet.of(), dummyVariableNullability);
            Optional<ImmutableExpression> downConstraint = this.conditionSimplifier.computeDownConstraint(constraint, expressionAndSubstitution, dummyVariableNullability);
            ImmutableSubstitution<NonFunctionalTerm> downSubstitution = descendingSubstitution.composeWith2(expressionAndSubstitution.getSubstitution());
            ImmutableList newChildren = (ImmutableList)children.stream().map(c -> c.applyDescendingSubstitution(downSubstitution, downConstraint)).collect(ImmutableCollectors.toList());
            NaryIQTree joinTree = this.iqFactory.createNaryIQTree(this.iqFactory.createInnerJoinNode(expressionAndSubstitution.getOptionalExpression()), (ImmutableList<IQTree>)newChildren);
            return expressionAndSubstitution.getSubstitution().isEmpty() ? joinTree : this.iqFactory.createUnaryIQTree(this.iqFactory.createConstructionNode(this.constructionNodeTools.computeNewProjectedVariables(descendingSubstitution, this.getProjectedVariables(children)), expressionAndSubstitution.getSubstitution()), joinTree);
        }
        catch (UnsatisfiableConditionException e) {
            return this.iqFactory.createEmptyNode(this.computeNewlyProjectedVariables(descendingSubstitution, children));
        }
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, ImmutableList<IQTree> children) {
        InnerJoinNode newJoinNode = this.getOptionalFilterCondition().map(descendingSubstitution::applyToBooleanExpression).map(this.iqFactory::createInnerJoinNode).orElseGet(this.iqFactory::createInnerJoinNode);
        ImmutableList newChildren = (ImmutableList)children.stream().map(c -> c.applyDescendingSubstitutionWithoutOptimizing(descendingSubstitution)).collect(ImmutableCollectors.toList());
        return this.iqFactory.createNaryIQTree(newJoinNode, (ImmutableList<IQTree>)newChildren);
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveVar2VarSubstitution renamingSubstitution, ImmutableList<IQTree> children, IQTreeCache treeCache) {
        ImmutableList newChildren = (ImmutableList)children.stream().map(c -> c.applyFreshRenaming(renamingSubstitution)).collect(ImmutableCollectors.toList());
        Optional<ImmutableExpression> newCondition = this.getOptionalFilterCondition().map(renamingSubstitution::applyToBooleanExpression);
        InnerJoinNodeImpl newJoinNode = newCondition.equals(this.getOptionalFilterCondition()) ? this : this.iqFactory.createInnerJoinNode(newCondition);
        IQTreeCache newTreeCache = treeCache.applyFreshRenaming(renamingSubstitution);
        return this.iqFactory.createNaryIQTree((NaryOperatorNode)newJoinNode, (ImmutableList<IQTree>)newChildren, newTreeCache);
    }

    private ImmutableSet<Variable> getProjectedVariables(ImmutableList<IQTree> children) {
        return (ImmutableSet)children.stream().flatMap(c -> c.getVariables().stream()).collect(ImmutableCollectors.toSet());
    }

    @Override
    public VariableNullability getVariableNullability(ImmutableList<IQTree> children) {
        return this.variableNullabilityTools.getVariableNullability(children, this.getOptionalFilterCondition());
    }

    @Override
    public boolean isConstructed(Variable variable, ImmutableList<IQTree> children) {
        return children.stream().anyMatch(c -> c.isConstructed(variable));
    }

    @Override
    public boolean isDistinct(ImmutableList<IQTree> children) {
        return children.stream().allMatch(IQTree::isDistinct);
    }

    @Override
    public IQTree liftIncompatibleDefinitions(Variable variable, ImmutableList<IQTree> children, VariableGenerator variableGenerator) {
        return IntStream.range(0, children.size()).boxed().map(i -> Maps.immutableEntry((Object)i, (Object)children.get(i.intValue()))).filter(e -> ((IQTree)e.getValue()).isConstructed(variable)).map(e -> Maps.immutableEntry(e.getKey(), (Object)((IQTree)e.getValue()).liftIncompatibleDefinitions(variable, variableGenerator))).filter(e -> {
            QueryNode newRootNode = ((IQTree)e.getValue()).getRootNode();
            return newRootNode instanceof UnionNode && ((UnionNode)newRootNode).hasAChildWithLiftableDefinition(variable, ((IQTree)e.getValue()).getChildren());
        }).findFirst().map(e -> this.liftUnionChild((Integer)e.getKey(), (NaryIQTree)e.getValue(), children, variableGenerator)).orElseGet(() -> this.iqFactory.createNaryIQTree(this, children));
    }

    @Override
    public IQTree propagateDownConstraint(ImmutableExpression constraint, ImmutableList<IQTree> children) {
        return this.propagateDownCondition(Optional.of(constraint), children);
    }

    @Override
    public IQTree acceptTransformer(IQTree tree, IQTreeVisitingTransformer transformer, ImmutableList<IQTree> children) {
        return transformer.transformInnerJoin(tree, this, children);
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor, ImmutableList<IQTree> children) {
        return visitor.visitInnerJoin(this, children);
    }

    @Override
    public void validateNode(ImmutableList<IQTree> children) throws InvalidIntermediateQueryException {
        if (children.size() < 2) {
            throw new InvalidIntermediateQueryException("JOIN node " + this + " does not have at least 2 children.\n" + children);
        }
        this.getOptionalFilterCondition().ifPresent(e -> this.checkExpression((ImmutableExpression)e, children));
        this.checkNonProjectedVariables(children);
    }

    @Override
    public IQTree removeDistincts(ImmutableList<IQTree> children, IQProperties properties) {
        ImmutableList newChildren = (ImmutableList)children.stream().map(IQTree::removeDistincts).collect(ImmutableCollectors.toList());
        IQProperties newProperties = newChildren.equals(children) ? properties.declareDistinctRemovalWithoutEffect() : properties.declareDistinctRemovalWithEffect();
        return this.iqFactory.createNaryIQTree((NaryOperatorNode)this, children, newProperties);
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints(ImmutableList<IQTree> children) {
        ImmutableSet childrenSet = ImmutableSet.copyOf(children);
        ImmutableMap<IQTree, ImmutableSet> constraintMap = childrenSet.stream().collect(ImmutableCollectors.toMap(c -> c, IQTree::inferUniqueConstraints));
        if (constraintMap.values().stream().anyMatch(AbstractCollection::isEmpty)) {
            return ImmutableSet.of();
        }
        ImmutableMultimap directDependencyMap = IntStream.range(0, children.size() - 1).boxed().flatMap(i -> IntStream.range(i + 1, children.size()).boxed().flatMap(j -> this.extractFunctionalDependencies((IQTree)children.get(i.intValue()), (IQTree)children.get(j.intValue()), (ImmutableMap<IQTree, ImmutableSet<ImmutableSet<Variable>>>)constraintMap))).collect(ImmutableCollectors.toMultimap());
        Multimap<IQTree, IQTree> saturatedDependencyMap = this.saturateDependencies(directDependencyMap);
        return (ImmutableSet)saturatedDependencyMap.asMap().entrySet().stream().filter(e -> ((Collection)e.getValue()).containsAll((Collection<?>)Sets.difference((Set)childrenSet, (Set)ImmutableSet.of(e.getKey())).immutableCopy())).map(Map.Entry::getKey).flatMap(child -> ((ImmutableSet)constraintMap.get(child)).stream()).collect(ImmutableCollectors.toSet());
    }

    private Stream<Map.Entry<IQTree, IQTree>> extractFunctionalDependencies(IQTree t1, IQTree t2, ImmutableMap<IQTree, ImmutableSet<ImmutableSet<Variable>>> constraintMap) {
        ImmutableSet commonVariables = Sets.intersection(t1.getVariables(), t2.getVariables()).immutableCopy();
        if (commonVariables.isEmpty()) {
            return Stream.empty();
        }
        return Stream.of(Optional.of(Maps.immutableEntry((Object)t1, (Object)t2)).filter(e -> ((ImmutableSet)constraintMap.get(e.getValue())).stream().anyMatch(arg_0 -> commonVariables.containsAll(arg_0))), Optional.of(Maps.immutableEntry((Object)t2, (Object)t1)).filter(e -> ((ImmutableSet)constraintMap.get(e.getValue())).stream().anyMatch(arg_0 -> commonVariables.containsAll(arg_0)))).filter(Optional::isPresent).map(Optional::get);
    }

    private Multimap<IQTree, IQTree> saturateDependencies(ImmutableMultimap<IQTree, IQTree> directDependencyMap) {
        HashMultimap mutableMultimap = HashMultimap.create(directDependencyMap);
        boolean hasConverged = false;
        while (!hasConverged) {
            hasConverged = true;
            for (IQTree determinant : directDependencyMap.keys()) {
                ImmutableSet dependents = ImmutableSet.copyOf((Collection)mutableMultimap.get((Object)determinant));
                for (IQTree dependent : dependents) {
                    if (!mutableMultimap.putAll((Object)determinant, (Iterable)mutableMultimap.get((Object)dependent))) continue;
                    hasConverged = false;
                }
            }
        }
        return mutableMultimap;
    }

    private IQTree propagateDownCondition(Optional<ImmutableExpression> initialConstraint, ImmutableList<IQTree> children) {
        VariableNullability childrenVariableNullability = this.variableNullabilityTools.getChildrenVariableNullability(children);
        try {
            ConditionSimplifier.ExpressionAndSubstitution conditionSimplificationResults = this.conditionSimplifier.simplifyCondition(this.getOptionalFilterCondition(), (ImmutableSet<Variable>)ImmutableSet.of(), childrenVariableNullability);
            VariableNullability dummyVariableNullability = this.variableNullabilityTools.getDummyVariableNullability(this.getProjectedVariables(children));
            Optional<ImmutableExpression> downConstraint = this.conditionSimplifier.computeDownConstraint(initialConstraint, conditionSimplificationResults, dummyVariableNullability);
            ImmutableList newChildren = Optional.of(conditionSimplificationResults.getSubstitution()).filter(s -> !s.isEmpty()).map(s -> (ImmutableList)children.stream().map(child -> child.applyDescendingSubstitution((ImmutableSubstitution<? extends VariableOrGroundTerm>)s, downConstraint)).collect(ImmutableCollectors.toList())).orElseGet(() -> downConstraint.map(s -> (ImmutableList)children.stream().map(child -> child.propagateDownConstraint((ImmutableExpression)s)).collect(ImmutableCollectors.toList())).orElse(children));
            InnerJoinNodeImpl newJoin = conditionSimplificationResults.getOptionalExpression().equals(this.getOptionalFilterCondition()) ? this : conditionSimplificationResults.getOptionalExpression().map(this.iqFactory::createInnerJoinNode).orElseGet(this.iqFactory::createInnerJoinNode);
            NaryIQTree joinTree = this.iqFactory.createNaryIQTree(newJoin, (ImmutableList<IQTree>)newChildren);
            return Optional.of(conditionSimplificationResults.getSubstitution()).filter(s -> !s.isEmpty()).map(s -> this.iqFactory.createConstructionNode((ImmutableSet<Variable>)((ImmutableSet)children.stream().flatMap(c -> c.getVariables().stream()).collect(ImmutableCollectors.toSet())), (ImmutableSubstitution<ImmutableTerm>)s)).map(c -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)c, joinTree)).orElse(joinTree);
        }
        catch (UnsatisfiableConditionException e) {
            return this.iqFactory.createEmptyNode(this.getProjectedVariables(children));
        }
    }

    private IQTree liftUnionChild(int childIndex, NaryIQTree newUnionChild, ImmutableList<IQTree> initialChildren, VariableGenerator variableGenerator) {
        UnionNode newUnionNode = this.iqFactory.createUnionNode((ImmutableSet<Variable>)((ImmutableSet)initialChildren.stream().flatMap(c -> c.getVariables().stream()).collect(ImmutableCollectors.toSet())));
        return this.iqFactory.createNaryIQTree(newUnionNode, (ImmutableList<IQTree>)((ImmutableList)newUnionChild.getChildren().stream().map(unionGrandChild -> this.createJoinSubtree(childIndex, (IQTree)unionGrandChild, initialChildren)).collect(ImmutableCollectors.toList()))).normalizeForOptimization(variableGenerator);
    }

    private IQTree createJoinSubtree(int childIndex, IQTree unionGrandChild, ImmutableList<IQTree> initialChildren) {
        return this.iqFactory.createNaryIQTree(this, (ImmutableList<IQTree>)((ImmutableList)IntStream.range(0, initialChildren.size()).boxed().map(i -> i == childIndex ? unionGrandChild : (IQTree)initialChildren.get(i.intValue())).collect(ImmutableCollectors.toList())));
    }

    private ImmutableSet<Variable> computeNewlyProjectedVariables(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, ImmutableList<IQTree> children) {
        ImmutableSet<Variable> formerProjectedVariables = this.getProjectedVariables(children);
        return this.constructionNodeTools.computeNewProjectedVariables(descendingSubstitution, formerProjectedVariables);
    }
}

