/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.DataNodeImpl;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;

public class ExtensionalDataNodeImpl
extends DataNodeImpl<RelationPredicate>
implements ExtensionalDataNode {
    private static final String EXTENSIONAL_NODE_STR = "EXTENSIONAL";
    @Nullable
    private VariableNullability variableNullability;
    @Nullable
    private ImmutableSet<ImmutableSet<Variable>> uniqueConstraints;
    private final CoreUtilsFactory coreUtilsFactory;

    @AssistedInject
    private ExtensionalDataNodeImpl(@Assisted DataAtom<RelationPredicate> atom, IQTreeTools iqTreeTools, IntermediateQueryFactory iqFactory, CoreUtilsFactory coreUtilsFactory) {
        super(atom, iqTreeTools, iqFactory);
        this.coreUtilsFactory = coreUtilsFactory;
    }

    @AssistedInject
    private ExtensionalDataNodeImpl(@Assisted DataAtom<RelationPredicate> atom, @Assisted VariableNullability variableNullability, IQTreeTools iqTreeTools, IntermediateQueryFactory iqFactory, CoreUtilsFactory coreUtilsFactory) {
        super(atom, iqTreeTools, iqFactory);
        this.coreUtilsFactory = coreUtilsFactory;
        this.variableNullability = variableNullability;
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ExtensionalDataNode clone() {
        return this.iqFactory.createExtensionalDataNode(this.getProjectionAtom());
    }

    @Override
    public ExtensionalDataNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public ExtensionalDataNode newAtom(DataAtom<RelationPredicate> newAtom) {
        return this.iqFactory.createExtensionalDataNode(newAtom);
    }

    @Override
    public boolean isVariableNullable(IntermediateQuery query, Variable variable) {
        if (!this.getVariables().contains((Object)variable)) {
            throw new IllegalArgumentException("The variable " + variable + " is not projected by " + this);
        }
        DataAtom atom = this.getProjectionAtom();
        RelationDefinition relation = ((RelationPredicate)atom.getPredicate()).getRelationDefinition();
        ImmutableList<VariableOrGroundTerm> arguments = atom.getArguments();
        return IntStream.range(1, arguments.size() + 1).filter(i -> ((VariableOrGroundTerm)arguments.get(i - 1)).equals(variable)).mapToObj(relation::getAttribute).allMatch(Attribute::canNull);
    }

    @Override
    public IQTree acceptTransformer(IQTreeVisitingTransformer transformer) {
        return transformer.transformExtensionalData(this);
    }

    @Override
    public boolean isDistinct() {
        return !((RelationPredicate)this.getProjectionAtom().getPredicate()).getRelationDefinition().getUniqueConstraints().isEmpty();
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor) {
        return visitor.visitExtensionalData(this);
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveVar2VarSubstitution freshRenamingSubstitution) {
        DataAtom newDataAtom = freshRenamingSubstitution.applyToDataAtom(this.getProjectionAtom());
        return this.variableNullability == null ? this.newAtom(newDataAtom) : this.iqFactory.createExtensionalDataNode(newDataAtom, this.variableNullability.applyFreshRenaming(freshRenamingSubstitution));
    }

    @Override
    public VariableNullability getVariableNullability() {
        if (this.variableNullability == null) {
            DataAtom atom = this.getProjectionAtom();
            RelationDefinition relation = ((RelationPredicate)atom.getPredicate()).getRelationDefinition();
            ImmutableList<VariableOrGroundTerm> arguments = atom.getArguments();
            ImmutableMultiset argMultiset = ImmutableMultiset.copyOf(arguments);
            ImmutableSet nullableGroups = (ImmutableSet)IntStream.range(0, arguments.size()).filter(i -> arguments.get(i) instanceof Variable).filter(i -> relation.getAttribute(i + 1).canNull()).mapToObj(arg_0 -> arguments.get(arg_0)).map(a -> (Variable)a).filter(a -> argMultiset.count(a) < 2).map(ImmutableSet::of).collect(ImmutableCollectors.toSet());
            this.variableNullability = this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)nullableGroups, this.getVariables());
        }
        return this.variableNullability;
    }

    @Override
    public void validate() throws InvalidIntermediateQueryException {
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints() {
        if (this.uniqueConstraints == null) {
            ImmutableList<VariableOrGroundTerm> arguments = this.getProjectionAtom().getArguments();
            this.uniqueConstraints = (ImmutableSet)((RelationPredicate)this.getProjectionAtom().getPredicate()).getRelationDefinition().getUniqueConstraints().stream().map(uc -> (ImmutableSet)uc.getAttributes().stream().map(a -> (VariableOrGroundTerm)arguments.get(a.getIndex() - 1)).filter(t -> t instanceof Variable).map(v -> (Variable)v).collect(ImmutableCollectors.toSet())).collect(ImmutableCollectors.toSet());
        }
        return this.uniqueConstraints;
    }

    @Override
    public boolean isSyntacticallyEquivalentTo(QueryNode node) {
        return node instanceof ExtensionalDataNode && ((ExtensionalDataNode)node).getProjectionAtom().equals(this.getProjectionAtom());
    }

    @Override
    public boolean isEquivalentTo(QueryNode queryNode) {
        return queryNode instanceof ExtensionalDataNode && this.getProjectionAtom().equals(((ExtensionalDataNode)queryNode).getProjectionAtom());
    }

    public String toString() {
        return "EXTENSIONAL " + this.getProjectionAtom();
    }
}

