/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.impl.tree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.IllegalTreeException;
import it.unibz.inf.ontop.iq.exception.IllegalTreeUpdateException;
import it.unibz.inf.ontop.iq.impl.QueryTreeComponent;
import it.unibz.inf.ontop.iq.impl.tree.QueryTree;
import it.unibz.inf.ontop.iq.node.BinaryOrderedOperatorNode;
import it.unibz.inf.ontop.iq.node.ExplicitVariableProjectionNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.tools.VariableCollector;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class DefaultQueryTreeComponent
implements QueryTreeComponent {
    private final QueryTree tree;
    private final VariableGenerator variableGenerator;

    protected DefaultQueryTreeComponent(QueryTree tree, CoreUtilsFactory coreUtilsFactory) {
        this(tree, coreUtilsFactory.createVariableGenerator((Collection<Variable>)VariableCollector.collectVariables(tree.getNodesInTopDownOrder())));
    }

    private DefaultQueryTreeComponent(QueryTree tree, VariableGenerator variableGenerator) {
        this.tree = tree;
        this.variableGenerator = variableGenerator;
    }

    @Override
    public ImmutableList<QueryNode> getChildren(QueryNode node) {
        return this.tree.getChildren(node);
    }

    @Override
    public Stream<QueryNode> getChildrenStream(QueryNode node) {
        return this.tree.getChildrenStream(node);
    }

    @Override
    public QueryNode getRootNode() {
        return this.tree.getRootNode();
    }

    @Override
    public ImmutableList<QueryNode> getNodesInBottomUpOrder() {
        return this.tree.getNodesInBottomUpOrder();
    }

    @Override
    public ImmutableList<QueryNode> getNodesInTopDownOrder() throws IllegalTreeException {
        return this.tree.getNodesInTopDownOrder();
    }

    @Override
    public ImmutableSet<TrueNode> getTrueNodes() {
        return this.tree.getTrueNodes();
    }

    @Override
    public ImmutableSet<IntensionalDataNode> getIntensionalNodes() {
        return this.tree.getIntensionalNodes();
    }

    @Override
    public boolean contains(QueryNode node) {
        return this.tree.contains(node);
    }

    @Override
    public void replaceNode(QueryNode previousNode, QueryNode replacingNode) {
        this.collectPossiblyNewVariables(replacingNode);
        this.tree.replaceNode(previousNode, replacingNode);
    }

    @Override
    public void replaceSubTree(QueryNode subTreeRootNode, QueryNode replacingNode) {
        this.getChildren(subTreeRootNode).stream().forEach(this::removeSubTree);
        this.replaceNode(subTreeRootNode, replacingNode);
    }

    @Override
    public void addSubTree(IntermediateQuery subQuery, QueryNode subQueryTopNode, QueryNode localTopNode) throws IllegalTreeUpdateException {
        LinkedList<QueryNode> localParents = new LinkedList<QueryNode>();
        localParents.add(localTopNode);
        HashMap<QueryNode, QueryNode> localToExternalNodeMap = new HashMap<QueryNode, QueryNode>();
        localToExternalNodeMap.put(localTopNode, subQueryTopNode);
        while (!localParents.isEmpty()) {
            QueryNode localParent = (QueryNode)localParents.poll();
            QueryNode externalParent = (QueryNode)localToExternalNodeMap.get(localParent);
            for (QueryNode externalChild : subQuery.getChildren(externalParent)) {
                QueryNode localChild = externalChild.clone();
                localToExternalNodeMap.put(localChild, externalChild);
                localParents.add(localChild);
                this.addChild(localParent, localChild, subQuery.getOptionalPosition(externalParent, externalChild), false);
            }
        }
    }

    @Override
    public void removeSubTree(QueryNode subTreeRoot) {
        this.tree.removeSubTree(subTreeRoot);
    }

    @Override
    public ImmutableList<QueryNode> getSubTreeNodesInTopDownOrder(QueryNode currentNode) {
        return this.tree.getSubTreeNodesInTopDownOrder(currentNode);
    }

    @Override
    public Optional<BinaryOrderedOperatorNode.ArgumentPosition> getOptionalPosition(QueryNode parentNode, QueryNode childNode) {
        return this.tree.getOptionalPosition(parentNode, childNode);
    }

    @Override
    public ImmutableList<QueryNode> getAncestors(QueryNode descendantNode) throws IllegalTreeException {
        ImmutableList.Builder ancestorBuilder = ImmutableList.builder();
        Optional<QueryNode> optionalAncestor = this.getParent(descendantNode);
        while (optionalAncestor.isPresent()) {
            QueryNode ancestor = optionalAncestor.get();
            ancestorBuilder.add((Object)ancestor);
            optionalAncestor = this.getParent(ancestor);
        }
        return ancestorBuilder.build();
    }

    @Override
    public Optional<QueryNode> getParent(QueryNode node) throws IllegalTreeException {
        return this.tree.getParent(node);
    }

    @Override
    public QueryNode removeOrReplaceNodeByUniqueChild(QueryNode node) throws IllegalTreeUpdateException {
        return this.tree.removeOrReplaceNodeByUniqueChild(node);
    }

    @Override
    public void replaceNodesByOneNode(ImmutableList<QueryNode> queryNodes, QueryNode replacingNode, QueryNode parentNode, Optional<BinaryOrderedOperatorNode.ArgumentPosition> optionalPosition) throws IllegalTreeUpdateException {
        this.collectPossiblyNewVariables(replacingNode);
        this.tree.replaceNodesByOneNode(queryNodes, replacingNode, parentNode, optionalPosition);
    }

    @Override
    public void addChild(QueryNode parentNode, QueryNode childNode, Optional<BinaryOrderedOperatorNode.ArgumentPosition> optionalPosition, boolean canReplace) throws IllegalTreeUpdateException {
        this.collectPossiblyNewVariables(childNode);
        this.tree.addChild(parentNode, childNode, optionalPosition, true, canReplace);
    }

    @Override
    public Optional<QueryNode> nextSibling(QueryNode node) throws IllegalTreeException {
        Optional<QueryNode> optionalParent = this.tree.getParent(node);
        if (optionalParent.isPresent()) {
            ImmutableList<QueryNode> siblings = this.tree.getChildren(optionalParent.get());
            int index = siblings.indexOf((Object)node);
            if (index == -1) {
                throw new IllegalTreeException("The node " + node + " does not appear as a child of its parent");
            }
            if (index < siblings.size() - 1) {
                return Optional.of(siblings.get(index + 1));
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<QueryNode> getFirstChild(QueryNode node) {
        ImmutableList<QueryNode> children = this.tree.getChildren(node);
        switch (children.size()) {
            case 0: {
                return Optional.empty();
            }
        }
        return Optional.of(children.get(0));
    }

    @Override
    public void insertParent(QueryNode childNode, QueryNode newParentNode) throws IllegalTreeUpdateException {
        this.insertParent(childNode, newParentNode, Optional.empty());
    }

    @Override
    public void insertParent(QueryNode childNode, QueryNode newParentNode, Optional<BinaryOrderedOperatorNode.ArgumentPosition> optionalPosition) throws IllegalTreeUpdateException {
        this.collectPossiblyNewVariables(newParentNode);
        this.tree.insertParent(childNode, newParentNode, optionalPosition);
    }

    @Override
    public void transferChild(QueryNode childNode, QueryNode formerParentNode, QueryNode newParentNode, Optional<BinaryOrderedOperatorNode.ArgumentPosition> optionalPosition) throws IllegalTreeUpdateException {
        this.tree.transferChild(childNode, formerParentNode, newParentNode, optionalPosition);
    }

    @Override
    public Variable generateNewVariable() {
        return this.variableGenerator.generateNewVariable();
    }

    @Override
    public Variable generateNewVariable(Variable formerVariable) {
        return this.variableGenerator.generateNewVariableFromVar(formerVariable);
    }

    @Override
    public ImmutableSet<Variable> getKnownVariables() {
        return this.variableGenerator.getKnownVariables();
    }

    @Override
    public QueryNode replaceNodeByChild(QueryNode parentNode, Optional<BinaryOrderedOperatorNode.ArgumentPosition> optionalReplacingChildPosition) {
        return this.tree.replaceNodeByChild(parentNode, optionalReplacingChildPosition);
    }

    @Override
    public QueryTreeComponent createSnapshot() {
        return new DefaultQueryTreeComponent(this.tree.createSnapshot(), this.variableGenerator.createSnapshot());
    }

    @Override
    public ImmutableSet<Variable> getVariables(QueryNode node) {
        if (node instanceof ExplicitVariableProjectionNode) {
            return ((ExplicitVariableProjectionNode)node).getVariables();
        }
        return (ImmutableSet)this.getProjectedVariableStream(node).collect(ImmutableCollectors.toSet());
    }

    @Override
    public UUID getVersionNumber() {
        return this.tree.getVersionNumber();
    }

    @Override
    public QueryNode replaceSubTreeByIQ(QueryNode subTreeRoot, IQTree replacingSubTree) {
        QueryNode iqRoot = replacingSubTree.getRootNode();
        QueryNode newSubTreeRoot = this.contains(iqRoot) ? iqRoot.clone() : iqRoot;
        this.replaceSubTree(subTreeRoot, newSubTreeRoot);
        this.insertIQChildren(newSubTreeRoot, replacingSubTree.getChildren());
        return newSubTreeRoot;
    }

    private void insertIQChildren(QueryNode parentNode, ImmutableList<IQTree> childrenTrees) {
        ImmutableList newChildren = (ImmutableList)childrenTrees.stream().map(IQTree::getRootNode).map(n -> this.contains((QueryNode)n) ? n.clone() : n).collect(ImmutableCollectors.toList());
        if (parentNode instanceof BinaryOrderedOperatorNode) {
            this.addChild(parentNode, (QueryNode)newChildren.get(0), Optional.of(BinaryOrderedOperatorNode.ArgumentPosition.LEFT), false);
            this.addChild(parentNode, (QueryNode)newChildren.get(1), Optional.of(BinaryOrderedOperatorNode.ArgumentPosition.RIGHT), false);
        } else {
            newChildren.forEach(c -> this.addChild(parentNode, (QueryNode)c, Optional.empty(), false));
        }
        IntStream.range(0, childrenTrees.size()).forEach(i -> this.insertIQChildren((QueryNode)newChildren.get(i), ((IQTree)childrenTrees.get(i)).getChildren()));
    }

    private Stream<Variable> getProjectedVariableStream(QueryNode node) {
        if (node instanceof ExplicitVariableProjectionNode) {
            return ((ExplicitVariableProjectionNode)node).getVariables().stream();
        }
        return this.getChildrenStream(node).flatMap(this::getProjectedVariableStream);
    }

    private void collectPossiblyNewVariables(QueryNode newNode) {
        this.variableGenerator.registerAdditionalVariables((Collection<Variable>)newNode.getLocalVariables());
    }
}

