/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.stream.Collectors;

public class QueryNodeRenamer
implements HomogeneousQueryNodeTransformer {
    private final IntermediateQueryFactory iqFactory;
    private final InjectiveVar2VarSubstitution renamingSubstitution;
    private final AtomFactory atomFactory;

    public QueryNodeRenamer(IntermediateQueryFactory iqFactory, InjectiveVar2VarSubstitution renamingSubstitution, AtomFactory atomFactory) {
        this.iqFactory = iqFactory;
        this.renamingSubstitution = renamingSubstitution;
        this.atomFactory = atomFactory;
    }

    @Override
    public FilterNode transform(FilterNode filterNode) {
        return this.iqFactory.createFilterNode(this.renameBooleanExpression(filterNode.getFilterCondition()));
    }

    @Override
    public ExtensionalDataNode transform(ExtensionalDataNode extensionalDataNode) {
        return this.iqFactory.createExtensionalDataNode(this.renameDataAtom(extensionalDataNode.getProjectionAtom()));
    }

    @Override
    public LeftJoinNode transform(LeftJoinNode leftJoinNode) {
        return this.iqFactory.createLeftJoinNode(this.renameOptionalBooleanExpression(leftJoinNode.getOptionalFilterCondition()));
    }

    @Override
    public UnionNode transform(UnionNode unionNode) {
        return this.iqFactory.createUnionNode(this.renameProjectedVars(unionNode.getVariables()));
    }

    @Override
    public IntensionalDataNode transform(IntensionalDataNode intensionalDataNode) {
        return this.iqFactory.createIntensionalDataNode(this.renameDataAtom(intensionalDataNode.getProjectionAtom()));
    }

    @Override
    public InnerJoinNode transform(InnerJoinNode innerJoinNode) {
        return this.iqFactory.createInnerJoinNode(this.renameOptionalBooleanExpression(innerJoinNode.getOptionalFilterCondition()));
    }

    @Override
    public ConstructionNode transform(ConstructionNode constructionNode) {
        return this.iqFactory.createConstructionNode(this.renameProjectedVars(constructionNode.getVariables()), this.renameSubstitution(constructionNode.getSubstitution()));
    }

    @Override
    public AggregationNode transform(AggregationNode aggregationNode) throws QueryNodeTransformationException, QueryNodeTransformationException {
        return this.iqFactory.createAggregationNode(this.renameProjectedVars(aggregationNode.getGroupingVariables()), this.renameSubstitution(aggregationNode.getSubstitution()));
    }

    private ImmutableSet<Variable> renameProjectedVars(ImmutableSet<Variable> projectedVariables) {
        return projectedVariables.stream().map(this.renamingSubstitution::applyToVariable).collect(Collectors.collectingAndThen(Collectors.toSet(), ImmutableSet::copyOf));
    }

    @Override
    public EmptyNode transform(EmptyNode emptyNode) {
        return emptyNode.clone();
    }

    @Override
    public TrueNode transform(TrueNode trueNode) {
        return trueNode.clone();
    }

    @Override
    public DistinctNode transform(DistinctNode distinctNode) {
        return this.iqFactory.createDistinctNode();
    }

    @Override
    public SliceNode transform(SliceNode sliceNode) {
        return sliceNode.clone();
    }

    @Override
    public OrderByNode transform(OrderByNode orderByNode) {
        ImmutableList newComparators = (ImmutableList)orderByNode.getComparators().stream().map(c -> this.iqFactory.createOrderComparator(this.renamingSubstitution.applyToNonGroundTerm(c.getTerm()), c.isAscending())).collect(ImmutableCollectors.toList());
        return this.iqFactory.createOrderByNode((ImmutableList<OrderByNode.OrderComparator>)newComparators);
    }

    private ImmutableExpression renameBooleanExpression(ImmutableExpression booleanExpression) {
        return this.renamingSubstitution.applyToBooleanExpression(booleanExpression);
    }

    private DataAtom renameDataAtom(DataAtom<? extends AtomPredicate> atom) {
        ImmutableList.Builder argListBuilder = ImmutableList.builder();
        for (VariableOrGroundTerm term : atom.getArguments()) {
            argListBuilder.add((Object)this.renamingSubstitution.applyToTerm(term));
        }
        return this.atomFactory.getDataAtom(atom.getPredicate(), (ImmutableList<? extends VariableOrGroundTerm>)argListBuilder.build());
    }

    private Optional<ImmutableExpression> renameOptionalBooleanExpression(Optional<ImmutableExpression> optionalExpression) {
        if (!optionalExpression.isPresent()) {
            return Optional.empty();
        }
        ImmutableExpression expression = optionalExpression.get();
        return Optional.of(this.renameBooleanExpression(expression));
    }

    private <T extends ImmutableTerm> ImmutableSubstitution<T> renameSubstitution(ImmutableSubstitution<T> substitution) {
        return this.renamingSubstitution.applyRenaming(substitution);
    }
}

