/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.IntermediateQueryBuilder;
import it.unibz.inf.ontop.iq.exception.EmptyQueryException;
import it.unibz.inf.ontop.iq.exception.IllegalTreeException;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.InvalidQueryOptimizationProposalException;
import it.unibz.inf.ontop.iq.executor.ProposalExecutor;
import it.unibz.inf.ontop.iq.impl.BasicQueryTreePrinter;
import it.unibz.inf.ontop.iq.impl.IntermediateQueryPrinter;
import it.unibz.inf.ontop.iq.impl.QueryTreeComponent;
import it.unibz.inf.ontop.iq.node.BinaryOrderedOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExplicitVariableProjectionNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.proposal.ProposalResults;
import it.unibz.inf.ontop.iq.proposal.QueryOptimizationProposal;
import it.unibz.inf.ontop.iq.tools.ExecutorRegistry;
import it.unibz.inf.ontop.iq.validation.IntermediateQueryValidator;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;

public class IntermediateQueryImpl
implements IntermediateQuery {
    private static final IntermediateQueryPrinter PRINTER = new BasicQueryTreePrinter();
    private final QueryTreeComponent treeComponent;
    private final DistinctVariableOnlyDataAtom projectionAtom;
    private final ExecutorRegistry executorRegistry;
    private final IntermediateQueryValidator validator;
    private final OntopModelSettings settings;
    private final IntermediateQueryFactory iqFactory;

    public IntermediateQueryImpl(DistinctVariableOnlyDataAtom projectionAtom, QueryTreeComponent treeComponent, ExecutorRegistry executorRegistry, IntermediateQueryValidator validator, OntopModelSettings settings, IntermediateQueryFactory iqFactory) {
        this.projectionAtom = projectionAtom;
        this.treeComponent = treeComponent;
        this.executorRegistry = executorRegistry;
        this.validator = validator;
        this.settings = settings;
        this.iqFactory = iqFactory;
        if (settings.isTestModeEnabled()) {
            this.validate();
        }
    }

    @Override
    public DistinctVariableOnlyDataAtom getProjectionAtom() {
        return this.projectionAtom;
    }

    @Override
    public ImmutableSet<Variable> getKnownVariables() {
        return this.treeComponent.getKnownVariables();
    }

    @Override
    public IntermediateQuery createSnapshot() {
        return new IntermediateQueryImpl(this.projectionAtom, this.treeComponent.createSnapshot(), this.executorRegistry, this.validator, this.settings, this.iqFactory);
    }

    @Override
    public Stream<QueryNode> getOtherChildrenStream(QueryNode parent, QueryNode childToOmit) {
        return this.treeComponent.getChildrenStream(parent).filter(c -> c != childToOmit);
    }

    @Override
    public boolean hasAncestor(QueryNode descendantNode, QueryNode ancestorNode) {
        return this.getAncestors(descendantNode).contains((Object)ancestorNode);
    }

    @Override
    public ImmutableSet<Variable> getVariables(QueryNode subTreeRootNode) {
        return this.treeComponent.getVariables(subTreeRootNode);
    }

    @Override
    public UUID getVersionNumber() {
        return this.treeComponent.getVersionNumber();
    }

    @Override
    public IntermediateQueryBuilder newBuilder() {
        return this.iqFactory.createIQBuilder(this.executorRegistry);
    }

    @Override
    public QueryNode getRootNode() throws InconsistentIntermediateQueryException {
        try {
            return this.treeComponent.getRootNode();
        }
        catch (IllegalTreeException e) {
            throw new InconsistentIntermediateQueryException(e.getMessage());
        }
    }

    @Override
    public ImmutableList<QueryNode> getNodesInBottomUpOrder() throws InconsistentIntermediateQueryException {
        try {
            return this.treeComponent.getNodesInBottomUpOrder();
        }
        catch (IllegalTreeException e) {
            throw new InconsistentIntermediateQueryException(e.getMessage());
        }
    }

    @Override
    public ImmutableList<QueryNode> getNodesInTopDownOrder() {
        try {
            return this.treeComponent.getNodesInTopDownOrder();
        }
        catch (IllegalTreeException e) {
            throw new InconsistentIntermediateQueryException(e.getMessage());
        }
    }

    @Override
    public ImmutableList<QueryNode> getChildren(QueryNode node) {
        return this.treeComponent.getChildren(node);
    }

    @Override
    public Stream<QueryNode> getChildrenStream(QueryNode node) {
        return this.treeComponent.getChildrenStream(node);
    }

    @Override
    public Optional<QueryNode> getChild(QueryNode currentNode, BinaryOrderedOperatorNode.ArgumentPosition position) {
        return this.getChildren(currentNode).stream().filter(c -> this.getOptionalPosition(currentNode, (QueryNode)c).filter(position::equals).isPresent()).findFirst();
    }

    @Override
    public ImmutableList<QueryNode> getSubTreeNodesInTopDownOrder(QueryNode currentNode) {
        return this.treeComponent.getSubTreeNodesInTopDownOrder(currentNode);
    }

    @Override
    public Stream<IntensionalDataNode> getIntensionalNodes() {
        return this.treeComponent.getIntensionalNodes().stream();
    }

    @Override
    public Stream<TrueNode> getTrueNodes() {
        return this.treeComponent.getTrueNodes().stream();
    }

    @Override
    public boolean contains(QueryNode node) {
        return this.treeComponent.contains(node);
    }

    @Override
    public <R extends ProposalResults, P extends QueryOptimizationProposal<R>> R applyProposal(P proposal, boolean disableValidationTests) throws InvalidQueryOptimizationProposalException, EmptyQueryException {
        if (!disableValidationTests && this.settings.isTestModeEnabled()) {
            this.validate();
        }
        ProposalExecutor executor = this.executorRegistry.getExecutor(proposal);
        Object results = executor.apply(proposal, this, this.treeComponent);
        if (!disableValidationTests && this.settings.isTestModeEnabled()) {
            this.validate();
        }
        return results;
    }

    @Override
    public <R extends ProposalResults, P extends QueryOptimizationProposal<R>> R applyProposal(P propagationProposal) throws InvalidQueryOptimizationProposalException, EmptyQueryException {
        return this.applyProposal(propagationProposal, false);
    }

    @Override
    public Optional<BinaryOrderedOperatorNode.ArgumentPosition> getOptionalPosition(QueryNode parentNode, QueryNode childNode) {
        return this.treeComponent.getOptionalPosition(parentNode, childNode);
    }

    @Override
    public Optional<BinaryOrderedOperatorNode.ArgumentPosition> getOptionalPosition(QueryNode child) {
        Optional<QueryNode> optionalParent = this.getParent(child);
        if (optionalParent.isPresent()) {
            return this.getOptionalPosition(optionalParent.get(), child);
        }
        return Optional.empty();
    }

    @Override
    public ImmutableList<QueryNode> getAncestors(QueryNode descendantNode) {
        try {
            return this.treeComponent.getAncestors(descendantNode);
        }
        catch (IllegalTreeException e) {
            throw new InconsistentIntermediateQueryException(e.getMessage());
        }
    }

    @Override
    public Optional<QueryNode> getParent(QueryNode node) {
        try {
            return this.treeComponent.getParent(node);
        }
        catch (IllegalTreeException e) {
            throw new InconsistentIntermediateQueryException(e.getMessage());
        }
    }

    @Override
    public Optional<QueryNode> getNextSibling(QueryNode node) {
        try {
            return this.treeComponent.nextSibling(node);
        }
        catch (IllegalTreeException e) {
            throw new InconsistentIntermediateQueryException(e.getMessage());
        }
    }

    @Override
    public Optional<QueryNode> getFirstChild(QueryNode node) {
        return this.treeComponent.getFirstChild(node);
    }

    @Override
    public ConstructionNode getClosestConstructionNode(QueryNode node) {
        if (node instanceof ConstructionNode) {
            return (ConstructionNode)node;
        }
        for (QueryNode ancestor : this.getAncestors(node)) {
            if (!(ancestor instanceof ConstructionNode)) continue;
            return (ConstructionNode)ancestor;
        }
        throw new InconsistentIntermediateQueryException("The node " + node + " has no ancestor that is a ConstructionNode");
    }

    @Override
    public Variable generateNewVariable() {
        return this.treeComponent.generateNewVariable();
    }

    @Override
    public Variable generateNewVariable(Variable formerVariable) {
        return this.treeComponent.generateNewVariable(formerVariable);
    }

    public IntermediateQuery clone() {
        return this.createSnapshot();
    }

    public String toString() {
        return PRINTER.stringify(this);
    }

    @Override
    public ExecutorRegistry getExecutorRegistry() {
        return this.executorRegistry;
    }

    @Override
    public IntermediateQueryFactory getFactory() {
        return this.iqFactory;
    }

    @Override
    public ImmutableSet<Variable> getVariablesRequiredByAncestors(QueryNode queryNode) {
        ImmutableSet.Builder requiredVariableBuilder = ImmutableSet.builder();
        Optional<QueryNode> optionalAncestor = this.getParent(queryNode);
        while (optionalAncestor.isPresent()) {
            QueryNode ancestor = optionalAncestor.get();
            ancestor.getRequiredVariables(this).forEach(arg_0 -> ((ImmutableSet.Builder)requiredVariableBuilder).add(arg_0));
            if (ancestor instanceof ExplicitVariableProjectionNode) break;
            optionalAncestor = this.getParent(ancestor);
        }
        ImmutableSet requiredVariables = requiredVariableBuilder.build();
        return (ImmutableSet)this.getVariables(queryNode).stream().filter(arg_0 -> ((ImmutableSet)requiredVariables).contains(arg_0)).collect(ImmutableCollectors.toSet());
    }

    @Override
    public IntermediateQuery getSubquery(QueryNode subQueryRoot, DistinctVariableOnlyDataAtom projectionAtom) {
        IntermediateQueryBuilder builder = this.iqFactory.createIQBuilder(this.executorRegistry);
        builder.init(projectionAtom, subQueryRoot);
        builder.appendSubtree(subQueryRoot, this);
        return builder.build();
    }

    private void validate() throws InvalidIntermediateQueryException {
        this.validator.validate(this);
    }

    public static class InconsistentIntermediateQueryException
    extends RuntimeException {
        public InconsistentIntermediateQueryException(String message) {
            super(message);
        }
    }
}

