/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;

public interface IQTree {
    public QueryNode getRootNode();

    public ImmutableList<IQTree> getChildren();

    public ImmutableSet<Variable> getVariables();

    public IQTree acceptTransformer(IQTreeVisitingTransformer var1);

    public <T> T acceptVisitor(IQVisitor<T> var1);

    public IQTree normalizeForOptimization(VariableGenerator var1);

    public IQTree liftIncompatibleDefinitions(Variable var1, VariableGenerator var2);

    default public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    public IQTree applyDescendingSubstitution(ImmutableSubstitution<? extends VariableOrGroundTerm> var1, Optional<ImmutableExpression> var2);

    public IQTree applyFreshRenaming(InjectiveVar2VarSubstitution var1);

    public IQTree applyDescendingSubstitutionWithoutOptimizing(ImmutableSubstitution<? extends VariableOrGroundTerm> var1);

    public ImmutableSet<Variable> getKnownVariables();

    public boolean isConstructed(Variable var1);

    public boolean isDistinct();

    public boolean isDeclaredAsEmpty();

    public VariableNullability getVariableNullability();

    public boolean isEquivalentTo(IQTree var1);

    public IQTree propagateDownConstraint(ImmutableExpression var1);

    public IQTree removeDistincts();

    public void validate() throws InvalidIntermediateQueryException;

    public IQTree replaceSubTree(IQTree var1, IQTree var2);

    public ImmutableSet<ImmutableSubstitution<NonVariableTerm>> getPossibleVariableDefinitions();

    public ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints();
}

