/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import it.unibz.inf.ontop.exception.InvalidOntopConfigurationException;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntopModelSettingsImpl
implements OntopModelSettings {
    private static final String DEFAULT_PROPERTIES_FILE = "default.properties";
    private static final Logger LOG = LoggerFactory.getLogger(OntopModelSettings.class);
    private final Properties properties = OntopModelSettingsImpl.loadDefaultPropertiesFromFile(OntopModelSettings.class, "default.properties");
    private final OntopModelSettings.CardinalityPreservationMode cardinalityMode;
    private final boolean testMode;

    protected OntopModelSettingsImpl(Properties userProperties) {
        this.properties.putAll((Map<?, ?>)userProperties);
        this.cardinalityMode = OntopModelSettingsImpl.extractCardinalityMode(this.properties);
        this.testMode = OntopModelSettingsImpl.extractBoolean(this.properties, "ontop.testMode");
    }

    private static OntopModelSettings.CardinalityPreservationMode extractCardinalityMode(Properties properties) throws InvalidOntopConfigurationException {
        Object cardinalityModeObject = Optional.ofNullable(properties.get("ontop.cardinalityMode")).orElseThrow(() -> new InvalidOntopConfigurationException("ontop.cardinalityMode key is missing"));
        if (cardinalityModeObject instanceof String) {
            try {
                return OntopModelSettings.CardinalityPreservationMode.valueOf((String)cardinalityModeObject);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        } else if (cardinalityModeObject instanceof OntopModelSettings.CardinalityPreservationMode) {
            return (OntopModelSettings.CardinalityPreservationMode)((Object)cardinalityModeObject);
        }
        throw new InvalidOntopConfigurationException("Invalid value for ontop.cardinalityMode: is " + cardinalityModeObject);
    }

    private static boolean extractBoolean(Properties properties, String key) {
        Object value = Optional.ofNullable(properties.get(key)).orElseThrow(() -> new InvalidOntopConfigurationException(key + " key is missing"));
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        throw new InvalidOntopConfigurationException("Invalid value for " + key + ": is " + value);
    }

    protected static Properties loadDefaultPropertiesFromFile(Class localClass, String fileName) {
        Properties properties = new Properties();
        InputStream in = localClass.getResourceAsStream(fileName);
        if (in == null) {
            throw new RuntimeException("Configuration " + fileName + " not found.");
        }
        try {
            properties.load(in);
        }
        catch (IOException e1) {
            LOG.error("Error reading default OBDA properties.");
            LOG.debug(e1.getMessage(), (Throwable)e1);
            throw new RuntimeException("Impossible to extract configuration from " + fileName);
        }
        return properties;
    }

    public Object get(Object key) {
        return this.properties.get(key);
    }

    @Override
    public OntopModelSettings.CardinalityPreservationMode getCardinalityPreservationMode() {
        return this.cardinalityMode;
    }

    @Override
    public boolean isTestModeEnabled() {
        return this.testMode;
    }

    Optional<Boolean> getBoolean(String key) {
        Object value = this.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Boolean) {
            return Optional.of((Boolean)value);
        }
        if (value instanceof String) {
            return Optional.of(Boolean.parseBoolean((String)value));
        }
        throw new InvalidOntopConfigurationException("A boolean was expected: " + value);
    }

    boolean getRequiredBoolean(String key) {
        return this.getBoolean(key).orElseThrow(() -> new InvalidOntopConfigurationException(key + " is required but missing (must have a default value)"));
    }

    Optional<Integer> getInteger(String key) {
        String value = (String)this.get(key);
        return Optional.ofNullable(value == null ? null : Integer.valueOf(Integer.parseInt(value)));
    }

    Optional<Long> getLong(String key) {
        String value = (String)this.get(key);
        return Optional.ofNullable(value == null ? null : Long.valueOf(Long.parseLong(value)));
    }

    int getRequiredInteger(String key) {
        return this.getInteger(key).orElseThrow(() -> new InvalidOntopConfigurationException(key + " is required but missing (must have a default value)"));
    }

    long getRequiredLong(String key) {
        return this.getLong(key).orElseThrow(() -> new InvalidOntopConfigurationException(key + " is required but missing (must have a default value)"));
    }

    @Override
    public Optional<String> getProperty(String key) {
        return Optional.ofNullable((String)this.get(key));
    }

    String getRequiredProperty(String key) {
        return this.getProperty(key).orElseThrow(() -> new InvalidOntopConfigurationException(key + " is required but missing (must have a default value)"));
    }

    @Override
    public boolean contains(Object key) {
        return this.properties.containsKey(key);
    }

    protected Properties copyProperties() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.properties);
        return p;
    }
}

