/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import java.util.HashSet;
import java.util.Set;

public class FunctionalDependencyImpl
implements FunctionalDependency {
    private final ImmutableSet<Attribute> determinants;
    private final ImmutableSet<Attribute> dependents;

    private FunctionalDependencyImpl(ImmutableSet<Attribute> determinants, ImmutableSet<Attribute> dependents) {
        this.determinants = determinants;
        this.dependents = dependents;
    }

    @Override
    public ImmutableSet<Attribute> getDeterminants() {
        return this.determinants;
    }

    @Override
    public ImmutableSet<Attribute> getDependents() {
        return this.dependents;
    }

    public static class BuilderImpl
    implements FunctionalDependency.Builder {
        private final Set<Attribute> determinants = new HashSet<Attribute>();
        private final Set<Attribute> dependents = new HashSet<Attribute>();

        @Override
        public FunctionalDependency.Builder addDeterminant(Attribute determinant) {
            this.determinants.add(determinant);
            return this;
        }

        @Override
        public FunctionalDependency.Builder addDependent(Attribute dependent) {
            this.dependents.add(dependent);
            return this;
        }

        @Override
        public FunctionalDependency build() {
            return new FunctionalDependencyImpl(ImmutableSet.copyOf(this.determinants), ImmutableSet.copyOf(this.dependents));
        }
    }
}

