/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.ArrayList;

public class UniqueConstraint
implements FunctionalDependency {
    private final String name;
    private final ImmutableList<Attribute> attributes;
    private final boolean isPK;

    public static UniqueConstraint primaryKeyOf(Attribute att) {
        Builder builder = new Builder((DatabaseRelationDefinition)att.getRelation());
        return builder.add(att).build("PK_" + att.getRelation().getID().getTableName(), true);
    }

    public static UniqueConstraint primaryKeyOf(Attribute att, Attribute att2) {
        Builder builder = new Builder((DatabaseRelationDefinition)att.getRelation());
        return builder.add(att).add(att2).build("PK_" + att.getRelation().getID().getTableName(), true);
    }

    public static Builder builder(DatabaseRelationDefinition relation) {
        return new Builder(relation);
    }

    private UniqueConstraint(String name, boolean isPK, ImmutableList<Attribute> attributes) {
        this.name = name;
        this.isPK = isPK;
        this.attributes = attributes;
    }

    public String getName() {
        return this.name;
    }

    public DatabaseRelationDefinition getRelation() {
        return (DatabaseRelationDefinition)((Attribute)this.attributes.get(0)).getRelation();
    }

    public boolean isPrimaryKey() {
        return this.isPK;
    }

    public ImmutableList<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public ImmutableSet<Attribute> getDeterminants() {
        return ImmutableSet.copyOf(this.attributes);
    }

    @Override
    public ImmutableSet<Attribute> getDependents() {
        return (ImmutableSet)this.getRelation().getAttributes().stream().filter(a -> !this.attributes.contains(a)).collect(ImmutableCollectors.toSet());
    }

    public String toString() {
        ArrayList<String> columns = new ArrayList<String>(this.attributes.size());
        for (Attribute c : this.attributes) {
            columns.add(c.getID().toString());
        }
        StringBuilder bf = new StringBuilder();
        bf.append("ALTER TABLE ").append(((Attribute)this.attributes.get(0)).getRelation().getID()).append(" ADD CONSTRAINT ").append(this.name).append(this.isPK ? " PRIMARY KEY " : " UNIQUE ").append("(");
        Joiner.on((String)", ").appendTo(bf, columns);
        bf.append(")");
        return bf.toString();
    }

    public static final class Builder {
        private final ImmutableList.Builder<Attribute> builder = new ImmutableList.Builder();
        private final DatabaseRelationDefinition relation;

        public Builder(DatabaseRelationDefinition relation) {
            this.relation = relation;
        }

        public Builder add(Attribute attribute) {
            if (this.relation != attribute.getRelation()) {
                throw new IllegalArgumentException("Unique Key requires the same table in all attributes: " + this.relation + " " + attribute);
            }
            this.builder.add((Object)attribute);
            return this;
        }

        public UniqueConstraint build(String name, boolean isPK) {
            ImmutableList attributes = this.builder.build();
            if (attributes.isEmpty()) {
                return null;
            }
            return new UniqueConstraint(name, isPK, this.builder.build());
        }
    }
}

