/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.atom.impl.AtomPredicateImpl;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;

public class RelationPredicateImpl
extends AtomPredicateImpl
implements RelationPredicate {
    private final RelationDefinition relation;

    protected RelationPredicateImpl(RelationDefinition relation) {
        super(RelationPredicateImpl.extractPredicateName(relation), RelationPredicateImpl.extractBaseTypes(relation));
        this.relation = relation;
    }

    private static String extractPredicateName(RelationDefinition r) {
        RelationID id = r.getID();
        String name = id.getSchemaName();
        name = name == null ? id.getTableName() : name + "." + id.getTableName();
        return name;
    }

    private static ImmutableList<TermType> extractBaseTypes(RelationDefinition relation) {
        return (ImmutableList)relation.getAttributes().stream().map(Attribute::getBaseTypeForValidation).collect(ImmutableCollectors.toList());
    }

    @Override
    public RelationDefinition getRelationDefinition() {
        return this.relation;
    }
}

