/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema;

import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;

public class RelationID {
    private final QuotedID schema;
    private final QuotedID table;

    protected RelationID(QuotedID schema, QuotedID table) {
        this.schema = schema;
        this.table = table;
    }

    public static RelationID createRelationIdFromDatabaseRecord(QuotedIDFactory idfac, String schema, String table) {
        return new RelationID(QuotedID.createIdFromDatabaseRecord(idfac, schema), QuotedID.createIdFromDatabaseRecord(idfac, table));
    }

    public RelationID getSchemalessID() {
        return new RelationID(QuotedID.EMPTY_ID, this.table);
    }

    public boolean hasSchema() {
        return this.schema.getName() != null;
    }

    public String getSchemaSQLRendering() {
        return this.schema.getSQLRendering();
    }

    public String getTableNameSQLRendering() {
        return this.table.getSQLRendering();
    }

    public String getSchemaName() {
        return this.schema.getName();
    }

    public String getTableName() {
        return this.table.getName();
    }

    public String getSQLRendering() {
        String s = this.schema.getSQLRendering();
        if (s == null) {
            return this.table.getSQLRendering();
        }
        return s + "." + this.table.getSQLRendering();
    }

    public String toString() {
        return this.getSQLRendering();
    }

    public int hashCode() {
        return this.table.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RelationID) {
            RelationID other = (RelationID)obj;
            return this.schema.equals(other.schema) && this.table.equals(other.table);
        }
        return false;
    }
}

