/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema;

import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;

public class QuotedIDFactoryLowerCase
implements QuotedIDFactory {
    private final String quotationString;

    QuotedIDFactoryLowerCase(String quotationString) {
        this.quotationString = quotationString;
    }

    @Override
    public QuotedID createAttributeID(String s) {
        return this.createFromString(s);
    }

    @Override
    public RelationID createRelationID(String schema, String table) {
        return new RelationID(this.createFromString(schema), this.createFromString(table));
    }

    public QuotedID createFromString(String s) {
        if (s == null) {
            return new QuotedID(s, "");
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return new QuotedID(s.substring(1, s.length() - 1), this.quotationString);
        }
        if (s.startsWith("`") && s.endsWith("`")) {
            return new QuotedID(s.substring(1, s.length() - 1), this.quotationString);
        }
        if (s.startsWith("[") && s.endsWith("]")) {
            return new QuotedID(s.substring(1, s.length() - 1), this.quotationString);
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return new QuotedID(s.substring(1, s.length() - 1), this.quotationString);
        }
        return new QuotedID(s.toLowerCase(), "");
    }

    @Override
    public String getIDQuotationString() {
        return this.quotationString;
    }
}

