/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema;

import it.unibz.inf.ontop.dbschema.QuotedIDFactory;

public class QuotedID {
    private final String id;
    private final String quoteString;
    private final boolean caseSensitive;
    private final int hashCode;
    public static final String NO_QUOTATION = "";
    public static final QuotedID EMPTY_ID = new QuotedID(null, "");

    protected QuotedID(String id, String quoteString) {
        this(id, quoteString, true);
    }

    protected QuotedID(String id, String quoteString, boolean caseSensitive) {
        this.id = id;
        this.quoteString = quoteString;
        this.caseSensitive = caseSensitive;
        this.hashCode = id != null ? id.toLowerCase().hashCode() : 0;
    }

    public static QuotedID createIdFromDatabaseRecord(QuotedIDFactory idfac, String s) {
        return new QuotedID(s, idfac.getIDQuotationString());
    }

    public String getName() {
        return this.id;
    }

    public String getSQLRendering() {
        if (this.id == null) {
            return null;
        }
        return this.quoteString + this.id + this.quoteString;
    }

    public String toString() {
        return this.getSQLRendering();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QuotedID) {
            QuotedID other = (QuotedID)obj;
            if (this.id == other.id) {
                return true;
            }
            if (this.id != null && other.id != null) {
                if (this.id.equals(other.id)) {
                    return true;
                }
                if (!this.caseSensitive || !other.caseSensitive) {
                    return this.id.toLowerCase().equals(other.id.toLowerCase());
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

