/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import java.util.ArrayList;

public class ForeignKeyConstraint {
    private final String name;
    private final ImmutableList<Component> components;
    private final DatabaseRelationDefinition relation;
    private final DatabaseRelationDefinition referencedRelation;

    public static Builder builder(DatabaseRelationDefinition relation, DatabaseRelationDefinition referencedRelation) {
        return new Builder(relation, referencedRelation);
    }

    public static ForeignKeyConstraint of(String name, Attribute attribute, Attribute reference) {
        return new Builder((DatabaseRelationDefinition)attribute.getRelation(), (DatabaseRelationDefinition)reference.getRelation()).add(attribute, reference).build(name);
    }

    private ForeignKeyConstraint(String name, ImmutableList<Component> components) {
        this.name = name;
        this.components = components;
        this.relation = (DatabaseRelationDefinition)((Component)components.get(0)).getAttribute().getRelation();
        this.referencedRelation = (DatabaseRelationDefinition)((Component)components.get(0)).getReference().getRelation();
    }

    public String getName() {
        return this.name;
    }

    public ImmutableList<Component> getComponents() {
        return this.components;
    }

    public DatabaseRelationDefinition getReferencedRelation() {
        return this.referencedRelation;
    }

    public DatabaseRelationDefinition getRelation() {
        return this.relation;
    }

    public String toString() {
        ArrayList<String> columns = new ArrayList<String>(this.components.size());
        ArrayList<String> refColumns = new ArrayList<String>(this.components.size());
        for (Component c : this.components) {
            columns.add(c.getAttribute().getID().toString());
            refColumns.add(c.getReference().getID().toString());
        }
        StringBuilder bf = new StringBuilder();
        bf.append("ALTER TABLE ").append(this.relation.getID().getSQLRendering()).append(" ADD CONSTRAINT ").append(this.name).append(" FOREIGN KEY (");
        Joiner.on((String)", ").appendTo(bf, columns);
        bf.append(") REFERENCES ").append(this.referencedRelation.getID().getSQLRendering()).append(" (");
        Joiner.on((String)", ").appendTo(bf, refColumns);
        bf.append(")");
        return bf.toString();
    }

    public static final class Builder {
        private final ImmutableList.Builder<Component> builder = new ImmutableList.Builder();
        private final DatabaseRelationDefinition relation;
        private final DatabaseRelationDefinition referencedRelation;

        public Builder(DatabaseRelationDefinition relation, DatabaseRelationDefinition referencedRelation) {
            this.relation = relation;
            this.referencedRelation = referencedRelation;
        }

        public Builder add(Attribute attribute, Attribute referencedAttribute) {
            if (attribute == null) {
                throw new IllegalArgumentException("Missing Foreign Key column for table " + this.relation.getID() + " referring to primary key " + attribute + "  in table " + this.referencedRelation.getID());
            }
            if (referencedAttribute == null) {
                throw new IllegalArgumentException("Missing Primary Key column for table " + this.referencedRelation.getID() + " referring to foreign key " + attribute + " in table " + this.relation.getID());
            }
            if (this.relation != attribute.getRelation()) {
                throw new IllegalArgumentException("Foreign Key requires the same table in all attributes: " + this.relation + " -> " + this.referencedRelation + " (attribute " + attribute.getRelation().getID() + "." + attribute + ")");
            }
            if (this.referencedRelation != referencedAttribute.getRelation()) {
                throw new IllegalArgumentException("Foreign Key requires the same table in all referenced attributes: " + this.relation + " -> " + this.referencedRelation + " (attribute " + referencedAttribute.getRelation().getID() + "." + referencedAttribute + ")");
            }
            this.builder.add((Object)new Component(attribute, referencedAttribute));
            return this;
        }

        public ForeignKeyConstraint build(String name) {
            ImmutableList components = this.builder.build();
            if (components.isEmpty()) {
                return null;
            }
            return new ForeignKeyConstraint(name, components);
        }
    }

    public static final class Component {
        private final Attribute attribute;
        private final Attribute reference;

        private Component(Attribute attribute, Attribute reference) {
            this.attribute = attribute;
            this.reference = reference;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public Attribute getReference() {
            return this.reference;
        }
    }
}

