/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.model.type.DBTermType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DatabaseRelationDefinition
extends RelationDefinition {
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private final Map<QuotedID, Attribute> attributeMap = new HashMap<QuotedID, Attribute>();
    private final List<UniqueConstraint> ucs = new LinkedList<UniqueConstraint>();
    private final List<ForeignKeyConstraint> fks = new LinkedList<ForeignKeyConstraint>();
    private final List<FunctionalDependency> otherFunctionalDependencies = new ArrayList<FunctionalDependency>();
    private UniqueConstraint pk;

    protected DatabaseRelationDefinition(RelationID name) {
        super(name);
    }

    public Attribute addAttribute(QuotedID id, String typeName, DBTermType termType, boolean canNull) {
        Attribute att = new Attribute((RelationDefinition)this, new QualifiedAttributeID(this.getID(), id), this.attributes.size() + 1, typeName, termType, canNull);
        Attribute prev = this.attributeMap.put(id, att);
        if (prev != null) {
            throw new IllegalArgumentException("Duplicate attribute names");
        }
        this.attributes.add(att);
        return att;
    }

    public Attribute getAttribute(QuotedID attributeId) {
        return this.attributeMap.get(attributeId);
    }

    @Override
    public Attribute getAttribute(int index) {
        Attribute attribute = this.attributes.get(index - 1);
        return attribute;
    }

    @Override
    public List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public void addUniqueConstraint(UniqueConstraint uc) {
        if (uc.isPrimaryKey()) {
            if (this.pk != null) {
                throw new IllegalArgumentException("Duplicate PK " + this.pk + " " + uc);
            }
            this.pk = uc;
        } else if (this.pk != null && uc.getAttributes().equals(this.pk.getAttributes())) {
            return;
        }
        this.ucs.add(uc);
    }

    @Override
    public ImmutableList<UniqueConstraint> getUniqueConstraints() {
        return ImmutableList.copyOf(this.ucs);
    }

    public void addFunctionalDependency(FunctionalDependency constraint) {
        if (constraint instanceof UniqueConstraint) {
            this.addUniqueConstraint((UniqueConstraint)constraint);
        } else {
            this.otherFunctionalDependencies.add(constraint);
        }
    }

    @Override
    public ImmutableList<FunctionalDependency> getOtherFunctionalDependencies() {
        return ImmutableList.copyOf(this.otherFunctionalDependencies);
    }

    @Override
    public UniqueConstraint getPrimaryKey() {
        return this.pk;
    }

    public void addForeignKeyConstraint(ForeignKeyConstraint fk) {
        this.fks.add(fk);
    }

    @Override
    public ImmutableList<ForeignKeyConstraint> getForeignKeys() {
        return ImmutableList.copyOf(this.fks);
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        bf.append("CREATE TABLE ").append(this.getID()).append(" (\n   ");
        Joiner.on((String)",\n   ").appendTo(bf, this.attributes);
        bf.append("\n)");
        return bf.toString();
    }
}

