/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.DBMetadata;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.dbschema.impl.BasicDBParametersImpl;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicDBMetadata
implements DBMetadata {
    private final Map<RelationID, DatabaseRelationDefinition> tables;
    protected final Map<RelationID, RelationDefinition> relations;
    private final List<DatabaseRelationDefinition> listOfTables;
    private final String driverName;
    private final String driverVersion;
    private final String databaseProductName;
    private final String databaseVersion;
    private final QuotedIDFactory idfac;
    private final DBParameters dbParameters;
    private boolean isStillMutable;
    @Nullable
    private ImmutableMultimap<RelationPredicate, ImmutableList<Integer>> uniqueConstraints;
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicDBMetadata.class);

    protected BasicDBMetadata(String driverName, String driverVersion, String databaseProductName, String databaseVersion, QuotedIDFactory idfac) {
        this(driverName, driverVersion, databaseProductName, databaseVersion, new HashMap<RelationID, DatabaseRelationDefinition>(), new HashMap<RelationID, RelationDefinition>(), new LinkedList<DatabaseRelationDefinition>(), idfac);
    }

    protected BasicDBMetadata(String driverName, String driverVersion, String databaseProductName, String databaseVersion, Map<RelationID, DatabaseRelationDefinition> tables, Map<RelationID, RelationDefinition> relations, List<DatabaseRelationDefinition> listOfTables, QuotedIDFactory idfac) {
        this.driverName = driverName;
        this.driverVersion = driverVersion;
        this.databaseProductName = databaseProductName;
        this.databaseVersion = databaseVersion;
        this.idfac = idfac;
        this.tables = tables;
        this.relations = relations;
        this.listOfTables = listOfTables;
        this.isStillMutable = true;
        this.uniqueConstraints = null;
        this.dbParameters = new BasicDBParametersImpl(idfac);
    }

    public DatabaseRelationDefinition createDatabaseRelation(RelationID id) {
        if (!this.isStillMutable) {
            throw new IllegalStateException("Too late, cannot create a DB relation");
        }
        DatabaseRelationDefinition table = new DatabaseRelationDefinition(id);
        this.add(table, this.tables);
        this.add(table, this.relations);
        this.listOfTables.add(table);
        return table;
    }

    protected <T extends RelationDefinition> void add(T td, Map<RelationID, T> schema) {
        if (!this.isStillMutable) {
            throw new IllegalStateException("Too late, cannot add a schema");
        }
        schema.put(td.getID(), td);
        if (td.getID().hasSchema()) {
            RelationID noSchemaID = td.getID().getSchemalessID();
            if (!schema.containsKey(noSchemaID)) {
                schema.put(noSchemaID, td);
            } else {
                LOGGER.warn("DUPLICATE TABLE NAMES, USE QUALIFIED NAMES:\n" + td + "\nAND\n" + schema.get(noSchemaID));
            }
        }
    }

    @Override
    public DatabaseRelationDefinition getDatabaseRelation(RelationID id) {
        DatabaseRelationDefinition def = this.tables.get(id);
        if (def == null && id.hasSchema()) {
            def = this.tables.get(id.getSchemalessID());
        }
        return def;
    }

    @Override
    public RelationDefinition getRelation(RelationID name) {
        RelationDefinition def = this.relations.get(name);
        if (def == null && name.hasSchema()) {
            def = this.relations.get(name.getSchemalessID());
        }
        return def;
    }

    @Override
    public Collection<DatabaseRelationDefinition> getDatabaseRelations() {
        return Collections.unmodifiableCollection(this.listOfTables);
    }

    @Override
    public void freeze() {
        this.isStillMutable = false;
    }

    @Override
    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public String getDriverVersion() {
        return this.driverVersion;
    }

    @Override
    public String printKeys() {
        StringBuilder builder = new StringBuilder();
        Collection<DatabaseRelationDefinition> table_list = this.getDatabaseRelations();
        builder.append("\n====== Unique constraints ==========\n");
        for (DatabaseRelationDefinition dd : table_list) {
            builder.append(dd + ";\n");
            for (UniqueConstraint uc : dd.getUniqueConstraints()) {
                builder.append(uc + ";\n");
            }
            builder.append("\n");
        }
        builder.append("====== Foreign key constraints ==========\n");
        for (DatabaseRelationDefinition dd : table_list) {
            for (ForeignKeyConstraint fk : dd.getForeignKeys()) {
                builder.append(fk + ";\n");
            }
        }
        return builder.toString();
    }

    @Override
    public ImmutableMultimap<RelationPredicate, ImmutableList<Integer>> getUniqueConstraints() {
        if (this.uniqueConstraints == null) {
            ImmutableMultimap<RelationPredicate, ImmutableList<Integer>> constraints = this.extractUniqueConstraints();
            if (!this.isStillMutable) {
                this.uniqueConstraints = constraints;
            }
            return constraints;
        }
        return this.uniqueConstraints;
    }

    private ImmutableMultimap<RelationPredicate, ImmutableList<Integer>> extractUniqueConstraints() {
        return this.getDatabaseRelations().stream().flatMap(this::extractUniqueConstraintsFromRelation).collect(ImmutableCollectors.toMultimap());
    }

    private Stream<Map.Entry<RelationPredicate, ImmutableList<Integer>>> extractUniqueConstraintsFromRelation(DatabaseRelationDefinition relation) {
        return relation.getUniqueConstraints().stream().map(uc -> (ImmutableList)uc.getAttributes().stream().map(Attribute::getIndex).collect(ImmutableCollectors.toList())).map(positions -> new AbstractMap.SimpleEntry<RelationPredicate, ImmutableList>(relation.getAtomPredicate(), (ImmutableList)positions));
    }

    @Override
    public String getDbmsProductName() {
        return this.databaseProductName;
    }

    public String getDbmsVersion() {
        return this.databaseVersion;
    }

    @Override
    public QuotedIDFactory getQuotedIDFactory() {
        return this.idfac;
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        for (RelationID key : this.relations.keySet()) {
            bf.append(key);
            bf.append("=");
            bf.append(this.relations.get(key).toString());
            bf.append("\n");
        }
        return bf.toString();
    }

    protected Map<RelationID, DatabaseRelationDefinition> getTables() {
        return this.tables;
    }

    @Deprecated
    public BasicDBMetadata clone() {
        return new BasicDBMetadata(this.driverName, this.driverVersion, this.databaseProductName, this.databaseVersion, new HashMap<RelationID, DatabaseRelationDefinition>(this.tables), new HashMap<RelationID, RelationDefinition>(this.relations), new LinkedList<DatabaseRelationDefinition>(this.listOfTables), this.idfac);
    }

    protected boolean isStillMutable() {
        return this.isStillMutable;
    }

    @Override
    public ImmutableMap<RelationID, DatabaseRelationDefinition> copyTables() {
        return ImmutableMap.copyOf(this.tables);
    }

    @Override
    public ImmutableMap<RelationID, RelationDefinition> copyRelations() {
        return ImmutableMap.copyOf(this.relations);
    }

    @Override
    public DBParameters getDBParameters() {
        return this.dbParameters;
    }
}

