/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema;

import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Attribute {
    private final RelationDefinition table;
    private final QualifiedAttributeID id;
    private final int index;
    @Nullable
    private final DBTermType termType;
    private final String typeName;
    private final boolean canNull;
    @Nullable
    private final DBTermType abstractDBType;

    Attribute(RelationDefinition relation, QualifiedAttributeID id, int index, String typeName, @Nonnull DBTermType termType, boolean canNull) {
        this.table = relation;
        this.index = index;
        this.typeName = typeName;
        this.id = id;
        this.termType = termType;
        this.canNull = canNull;
        this.abstractDBType = null;
    }

    Attribute(RelationDefinition relation, QualifiedAttributeID id, int index, String typeName, boolean canNull, DBTypeFactory dbTypeFactory) {
        this.table = relation;
        this.index = index;
        this.typeName = typeName;
        this.id = id;
        this.termType = null;
        this.canNull = canNull;
        this.abstractDBType = dbTypeFactory.getAbstractRootDBType();
    }

    public QuotedID getID() {
        return this.id.getAttribute();
    }

    public QualifiedAttributeID getQualifiedID() {
        return this.id;
    }

    public RelationDefinition getRelation() {
        return this.table;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean canNull() {
        return this.canNull;
    }

    public String getSQLTypeName() {
        return this.typeName;
    }

    public String toString() {
        return this.id.getAttribute() + " " + this.typeName + (!this.canNull ? " NOT NULL" : "");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Attribute) {
            Attribute other = (Attribute)obj;
            return this.id.equals(other.id) && this.table == other.table;
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public Optional<DBTermType> getTermType() {
        return Optional.ofNullable(this.termType);
    }

    public DBTermType getBaseTypeForValidation() {
        return this.getTermType().orElse(this.abstractDBType);
    }
}

