/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.datalog.impl;

import it.unibz.inf.ontop.datalog.EventGeneratingList;
import it.unibz.inf.ontop.datalog.ListListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventGeneratingLinkedList<E>
extends LinkedList<E>
implements EventGeneratingList<E> {
    private static final long serialVersionUID = 893780365770320662L;
    private final LinkedList<ListListener> listeners = new LinkedList();
    private static Logger log = LoggerFactory.getLogger(EventGeneratingLinkedList.class);

    public EventGeneratingLinkedList() {
    }

    public EventGeneratingLinkedList(Collection<E> c) {
        this.addAll(c);
    }

    public EventGeneratingLinkedList(E[] c) {
        Collections.addAll(this, c);
    }

    @Override
    public void addListener(ListListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ListListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public E set(int index, E element) {
        E oldobject = super.set(index, element);
        this.riseListChanged();
        return oldobject;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        this.riseListChanged();
    }

    @Override
    public void clear() {
        super.clear();
        this.riseListChanged();
    }

    @Override
    public boolean add(E o) {
        boolean r = super.add(o);
        this.riseListChanged();
        return r;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean r = super.addAll(c);
        this.riseListChanged();
        return r;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean r = super.addAll(index, c);
        this.riseListChanged();
        return r;
    }

    @Override
    public boolean remove(Object o) {
        boolean r = super.remove(o);
        this.riseListChanged();
        return r;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean r = super.removeAll(c);
        this.riseListChanged();
        return r;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean r = super.retainAll(c);
        this.riseListChanged();
        return r;
    }

    private void riseListChanged() {
        for (ListListener listener : this.listeners) {
            try {
                listener.listChanged();
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
    }
}

