/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.constraints;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.constraints.ImmutableHomomorphism;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

public class LinearInclusionDependencies<P extends AtomPredicate> {
    protected final AtomFactory atomFactory;
    protected final ImmutableList<LinearInclusionDependency<P>> dependencies;
    private final VariableGenerator variableGenerator;

    protected LinearInclusionDependencies(CoreUtilsFactory coreUtilsFactory, AtomFactory atomFactory, ImmutableList<LinearInclusionDependency<P>> dependencies) {
        this.atomFactory = atomFactory;
        this.dependencies = dependencies;
        this.variableGenerator = coreUtilsFactory.createVariableGenerator((Collection<Variable>)ImmutableSet.of());
    }

    public static <P extends AtomPredicate> Builder<P> builder(CoreUtilsFactory coreUtilsFactory, AtomFactory atomFactory) {
        return new Builder(coreUtilsFactory, atomFactory);
    }

    public ImmutableSet<DataAtom<P>> chaseAtom(DataAtom<P> atom) {
        this.registerVariables(atom);
        return (ImmutableSet)Stream.concat(Stream.of(atom), this.dependencies.stream().map(id -> this.chase((LinearInclusionDependency<P>)id, atom)).filter(Optional::isPresent).map(Optional::get)).collect(ImmutableCollectors.toSet());
    }

    public ImmutableSet<DataAtom<P>> chaseAllAtoms(ImmutableCollection<DataAtom<P>> atoms) {
        this.registerVariables(atoms);
        return (ImmutableSet)Stream.concat(atoms.stream(), atoms.stream().flatMap(a -> this.dependencies.stream().map(id -> this.chase((LinearInclusionDependency<P>)id, (DataAtom<P>)a)).filter(Optional::isPresent).map(Optional::get))).collect(ImmutableCollectors.toSet());
    }

    private Optional<DataAtom<P>> chase(LinearInclusionDependency<P> id, DataAtom<P> atom) {
        if (!id.getBody().getPredicate().equals(atom.getPredicate())) {
            return Optional.empty();
        }
        ImmutableHomomorphism.Builder builder = ImmutableHomomorphism.builder();
        if (!builder.extend(id.getBody().getArguments(), atom.getArguments()).isValid()) {
            return Optional.empty();
        }
        ImmutableHomomorphism h = this.extendWithLabelledNulls(id, builder.build());
        ImmutableList newArguments = (ImmutableList)id.getHead().getArguments().stream().map(h::apply).collect(ImmutableCollectors.toList());
        return Optional.of(this.atomFactory.getDataAtom(id.getHead().getPredicate(), (ImmutableList<? extends VariableOrGroundTerm>)newArguments));
    }

    protected void registerVariables(DataAtom<P> atom) {
        this.variableGenerator.registerAdditionalVariables((Collection<Variable>)atom.getVariables());
    }

    protected void registerVariables(ImmutableCollection<DataAtom<P>> atoms) {
        atoms.stream().forEach(this::registerVariables);
    }

    protected ImmutableHomomorphism extendWithLabelledNulls(LinearInclusionDependency<P> id, ImmutableHomomorphism h) {
        ImmutableHomomorphism.Builder builder = ImmutableHomomorphism.builder(h);
        ImmutableSet<Variable> bodyVariables = id.getBody().getVariables();
        id.getHead().getVariables().stream().filter(v -> !bodyVariables.contains(v)).forEach(v -> builder.extend((ImmutableTerm)v, this.variableGenerator.generateNewVariableFromVar((Variable)v)));
        return builder.build();
    }

    public String toString() {
        return this.dependencies.toString();
    }

    public static class Builder<P extends AtomPredicate> {
        protected final ImmutableList.Builder<LinearInclusionDependency<P>> builder = ImmutableList.builder();
        protected final CoreUtilsFactory coreUtilsFactory;
        protected final AtomFactory atomFactory;

        protected Builder(CoreUtilsFactory coreUtilsFactory, AtomFactory atomFactory) {
            this.coreUtilsFactory = coreUtilsFactory;
            this.atomFactory = atomFactory;
        }

        public Builder add(DataAtom<P> head, DataAtom<P> body) {
            this.builder.add(new LinearInclusionDependency(head, body));
            return this;
        }

        public LinearInclusionDependencies<P> build() {
            return new LinearInclusionDependencies(this.coreUtilsFactory, this.atomFactory, this.builder.build());
        }
    }

    public static final class LinearInclusionDependency<P extends AtomPredicate> {
        private final DataAtom<P> head;
        private final DataAtom<P> body;

        private LinearInclusionDependency(DataAtom<P> head, DataAtom<P> body) {
            this.head = head;
            this.body = body;
        }

        public DataAtom<P> getHead() {
            return this.head;
        }

        public DataAtom<P> getBody() {
            return this.body;
        }

        public String toString() {
            return this.head + " :- " + this.body;
        }
    }
}

