/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.constraints;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.HashMap;
import java.util.Map;

public class ImmutableHomomorphism {
    private final ImmutableMap<Variable, VariableOrGroundTerm> map;

    private ImmutableHomomorphism(ImmutableMap<Variable, VariableOrGroundTerm> map) {
        this.map = map;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ImmutableHomomorphism homomorphism) {
        return new Builder(homomorphism);
    }

    public VariableOrGroundTerm apply(VariableOrGroundTerm term) {
        return term instanceof Variable ? (VariableOrGroundTerm)this.map.get((Object)term) : term;
    }

    public ImmutableMap<Variable, VariableOrGroundTerm> asMap() {
        return this.map;
    }

    public ImmutableExpression applyToBooleanExpression(ImmutableExpression booleanExpression, TermFactory termFactory) {
        return (ImmutableExpression)this.applyToImmutableTerm(booleanExpression, termFactory);
    }

    private ImmutableTerm applyToImmutableTerm(ImmutableTerm term, TermFactory termFactory) {
        if (term instanceof Constant) {
            return term;
        }
        if (term instanceof Variable) {
            return (ImmutableTerm)this.map.get((Object)term);
        }
        if (term instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm functionalTerm = (ImmutableFunctionalTerm)term;
            ImmutableList terms = (ImmutableList)functionalTerm.getTerms().stream().map(t -> this.applyToImmutableTerm((ImmutableTerm)t, termFactory)).collect(ImmutableCollectors.toList());
            FunctionSymbol functionSymbol = functionalTerm.getFunctionSymbol();
            return termFactory.getImmutableFunctionalTerm(functionSymbol, (ImmutableList<? extends ImmutableTerm>)terms);
        }
        throw new IllegalArgumentException("Unexpected kind of term: " + term.getClass());
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof ImmutableHomomorphism) {
            ImmutableHomomorphism o = (ImmutableHomomorphism)other;
            return this.map.equals(o.map);
        }
        return false;
    }

    public String toString() {
        return "IH " + this.map;
    }

    public static class Builder {
        private final Map<Variable, VariableOrGroundTerm> map = new HashMap<Variable, VariableOrGroundTerm>();
        private boolean valid = true;

        public Builder() {
        }

        public Builder(ImmutableHomomorphism homomorphism) {
            this.map.putAll((Map<Variable, VariableOrGroundTerm>)homomorphism.map);
        }

        public ImmutableHomomorphism build() {
            if (!this.valid) {
                throw new IllegalArgumentException();
            }
            return new ImmutableHomomorphism(ImmutableMap.copyOf(this.map));
        }

        public Builder extend(ImmutableTerm from, ImmutableTerm to) {
            if (from instanceof Variable) {
                VariableOrGroundTerm t;
                if (to instanceof VariableOrGroundTerm && ((t = this.map.put((Variable)from, (VariableOrGroundTerm)to)) == null || t.equals(to))) {
                    return this;
                }
            } else if (from instanceof Constant) {
                if (from.equals(to)) {
                    return this;
                }
            } else {
                ImmutableFunctionalTerm fromIFT = (ImmutableFunctionalTerm)from;
                if (to instanceof ImmutableFunctionalTerm) {
                    ImmutableFunctionalTerm toIFT = (ImmutableFunctionalTerm)to;
                    if (fromIFT.getFunctionSymbol().equals(toIFT.getFunctionSymbol())) {
                        for (int i = 0; i < fromIFT.getArity(); ++i) {
                            if (this.extend(fromIFT.getTerm(i), toIFT.getTerm(i)).isValid()) continue;
                            return this;
                        }
                        return this;
                    }
                }
            }
            this.valid = false;
            return this;
        }

        public Builder extend(ImmutableList<? extends VariableOrGroundTerm> from, ImmutableList<? extends VariableOrGroundTerm> to) {
            int arity = from.size();
            if (arity == to.size()) {
                for (int i = 0; i < arity; ++i) {
                    this.extend((ImmutableTerm)from.get(i), (ImmutableTerm)to.get(i));
                    if (this.valid) continue;
                    return this;
                }
                return this;
            }
            this.valid = false;
            return this;
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

