/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.bootstrap.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.dbschema.DBMetadataProvider;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.ImmutableMetadata;
import it.unibz.inf.ontop.dbschema.MetadataProvider;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.impl.JDBCMetadataProviderFactory;
import it.unibz.inf.ontop.exception.MappingBootstrappingException;
import it.unibz.inf.ontop.exception.MappingException;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.OntopMappingSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.injection.OntopSQLCredentialSettings;
import it.unibz.inf.ontop.injection.SQLPPMappingFactory;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.BnodeStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.spec.mapping.SQLPPSourceQueryFactory;
import it.unibz.inf.ontop.spec.mapping.TargetAtomFactory;
import it.unibz.inf.ontop.spec.mapping.bootstrap.DirectMappingBootstrapper;
import it.unibz.inf.ontop.spec.mapping.bootstrap.impl.DirectMappingAxiomProducer;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.OntopNativeSQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.util.MappingOntologyUtils;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.LocalJDBCConnectionUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.RDF;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;

public class DirectMappingEngine {
    private final SQLPPSourceQueryFactory sourceQueryFactory;
    private final JDBCMetadataProviderFactory metadataProviderFactory;
    private final SpecificationFactory specificationFactory;
    private final SQLPPMappingFactory ppMappingFactory;
    private final TypeFactory typeFactory;
    private final TermFactory termFactory;
    private final RDF rdfFactory;
    private final OntopSQLCredentialSettings settings;
    private final TargetAtomFactory targetAtomFactory;
    private final DBFunctionSymbolFactory dbFunctionSymbolFactory;

    static DirectMappingBootstrapper.BootstrappingResults bootstrap(OntopMappingSQLOWLAPIConfiguration configuration, String baseIRI) throws MappingException, OWLOntologyCreationException, MappingBootstrappingException {
        DirectMappingEngine engine = (DirectMappingEngine)configuration.getInjector().getInstance(DirectMappingEngine.class);
        return engine.bootstrapMappingAndOntology(baseIRI, configuration.loadPPMapping(), configuration.loadInputOntology());
    }

    @Inject
    private DirectMappingEngine(OntopSQLCredentialSettings settings, SpecificationFactory specificationFactory, SQLPPMappingFactory ppMappingFactory, TypeFactory typeFactory, TermFactory termFactory, RDF rdfFactory, TargetAtomFactory targetAtomFactory, DBFunctionSymbolFactory dbFunctionSymbolFactory, SQLPPSourceQueryFactory sourceQueryFactory, JDBCMetadataProviderFactory metadataProviderFactory) {
        this.specificationFactory = specificationFactory;
        this.ppMappingFactory = ppMappingFactory;
        this.settings = settings;
        this.typeFactory = typeFactory;
        this.termFactory = termFactory;
        this.rdfFactory = rdfFactory;
        this.targetAtomFactory = targetAtomFactory;
        this.dbFunctionSymbolFactory = dbFunctionSymbolFactory;
        this.sourceQueryFactory = sourceQueryFactory;
        this.metadataProviderFactory = metadataProviderFactory;
    }

    private DirectMappingBootstrapper.BootstrappingResults bootstrapMappingAndOntology(String baseIRI, Optional<SQLPPMapping> inputPPMapping, Optional<OWLOntology> inputOntology) throws MappingBootstrappingException {
        try {
            final SQLPPMapping newPPMapping = this.extractPPMapping(inputPPMapping, DirectMappingEngine.fixBaseURI(baseIRI));
            final OWLOntology ontology = inputOntology.orElse(OWLManager.createOWLOntologyManager().createOntology(IRI.create((String)baseIRI)));
            MappingOntologyUtils.extractAndInsertDeclarationAxioms(ontology, (ImmutableList<? extends SQLPPTriplesMap>)newPPMapping.getTripleMaps(), this.typeFactory, true);
            return new DirectMappingBootstrapper.BootstrappingResults(){

                @Override
                public SQLPPMapping getPPMapping() {
                    return newPPMapping;
                }

                @Override
                public OWLOntology getOntology() {
                    return ontology;
                }
            };
        }
        catch (MetadataExtractionException | SQLException | OWLOntologyCreationException e) {
            throw new MappingBootstrappingException((Exception)e);
        }
    }

    private SQLPPMapping extractPPMapping(Optional<SQLPPMapping> optionalMapping, String baseIRI0) throws SQLException, MetadataExtractionException {
        SQLPPMapping mapping = optionalMapping.orElse(this.ppMappingFactory.createSQLPreProcessedMapping(ImmutableList.of(), this.specificationFactory.createPrefixManager(ImmutableMap.of())));
        try (Connection conn = LocalJDBCConnectionUtils.createConnection((OntopSQLCredentialSettings)this.settings);){
            DBMetadataProvider metadataProvider = this.metadataProviderFactory.getMetadataProvider(conn);
            ImmutableList tables = ImmutableMetadata.extractImmutableMetadata((MetadataProvider)metadataProvider).getAllRelations();
            String baseIRI = baseIRI0.isEmpty() ? mapping.getPrefixManager().getDefaultIriPrefix() : baseIRI0;
            HashMap bnodeTemplateMap = new HashMap();
            AtomicInteger currentMappingIndex = new AtomicInteger(mapping.getTripleMaps().size() + 1);
            ImmutableList mappings = (ImmutableList)Stream.concat(mapping.getTripleMaps().stream(), tables.stream().flatMap(td -> this.getMapping((NamedRelationDefinition)td, baseIRI, bnodeTemplateMap, currentMappingIndex).stream())).collect(ImmutableCollectors.toList());
            SQLPPMapping sQLPPMapping = this.ppMappingFactory.createSQLPreProcessedMapping(mappings, mapping.getPrefixManager());
            return sQLPPMapping;
        }
    }

    public static String fixBaseURI(String prefix) {
        if (prefix.endsWith("#")) {
            return prefix.replace("#", "/");
        }
        if (prefix.endsWith("/")) {
            return prefix;
        }
        return prefix + "/";
    }

    public ImmutableList<SQLPPTriplesMap> getMapping(NamedRelationDefinition table, String baseIRI, Map<NamedRelationDefinition, BnodeStringTemplateFunctionSymbol> bnodeTemplateMap, AtomicInteger mappingIndex) {
        DirectMappingAxiomProducer dmap = new DirectMappingAxiomProducer(baseIRI, this.termFactory, this.targetAtomFactory, this.rdfFactory, this.dbFunctionSymbolFactory, this.typeFactory);
        return (ImmutableList)Stream.concat(Stream.of(Maps.immutableEntry((Object)dmap.getSQL(table), dmap.getCQ(table, bnodeTemplateMap))), table.getForeignKeys().stream().map(fk -> Maps.immutableEntry((Object)dmap.getRefSQL((ForeignKeyConstraint)fk), dmap.getRefCQ((ForeignKeyConstraint)fk, bnodeTemplateMap)))).map(e -> new OntopNativeSQLPPTriplesMap("MAPPING-ID" + mappingIndex.getAndIncrement(), this.sourceQueryFactory.createSourceQuery((String)e.getKey()), (ImmutableList)e.getValue())).collect(ImmutableCollectors.toList());
    }
}

