/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.bootstrap.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.model.template.Template;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.BnodeStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.TargetAtomFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.R2RMLIRISafeEncoder;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;

public class DirectMappingAxiomProducer {
    private final String baseIRI;
    private final TermFactory termFactory;
    private final RDF rdfFactory;
    private final DBFunctionSymbolFactory dbFunctionSymbolFactory;
    private final TargetAtomFactory targetAtomFactory;
    private final TypeFactory typeFactory;

    public DirectMappingAxiomProducer(String baseIRI, TermFactory termFactory, TargetAtomFactory targetAtomFactory, RDF rdfFactory, DBFunctionSymbolFactory dbFunctionSymbolFactory, TypeFactory typeFactory) {
        this.baseIRI = Objects.requireNonNull(baseIRI, "Base IRI must not be null!");
        this.termFactory = termFactory;
        this.targetAtomFactory = targetAtomFactory;
        this.rdfFactory = rdfFactory;
        this.dbFunctionSymbolFactory = dbFunctionSymbolFactory;
        this.typeFactory = typeFactory;
    }

    public String getSQL(NamedRelationDefinition table) {
        return String.format("SELECT * FROM %s", table.getID().getSQLRendering());
    }

    public String getRefSQL(ForeignKeyConstraint fk) {
        String columns = Stream.concat(DirectMappingAxiomProducer.getIdentifyingAttributes(fk.getRelation()).stream(), DirectMappingAxiomProducer.getIdentifyingAttributes(fk.getReferencedRelation()).stream()).map(a -> DirectMappingAxiomProducer.getQualifiedColumnName(a) + " AS " + DirectMappingAxiomProducer.getColumnAlias(a)).collect(Collectors.joining(", "));
        String tables = fk.getRelation().getID().getSQLRendering() + ", " + fk.getReferencedRelation().getID().getSQLRendering();
        String conditions = fk.getComponents().stream().map(c -> DirectMappingAxiomProducer.getQualifiedColumnName(c.getAttribute()) + " = " + DirectMappingAxiomProducer.getQualifiedColumnName(c.getReferencedAttribute())).collect(Collectors.joining(" AND "));
        return String.format("SELECT %s FROM %s WHERE %s", columns, tables, conditions);
    }

    private static ImmutableList<Attribute> getIdentifyingAttributes(NamedRelationDefinition table) {
        Optional pk = table.getPrimaryKey();
        return pk.map(UniqueConstraint::getAttributes).orElse(table.getAttributes());
    }

    private static String getTableName(NamedRelationDefinition relation) {
        return ((QuotedID)relation.getID().getComponents().get(0)).getName();
    }

    private static String getColumnAlias(Attribute attr) {
        return DirectMappingAxiomProducer.getTableName((NamedRelationDefinition)attr.getRelation()) + "_" + attr.getID().getName();
    }

    private static String getQualifiedColumnName(Attribute attr) {
        return new QualifiedAttributeID(((NamedRelationDefinition)attr.getRelation()).getID(), attr.getID()).getSQLRendering();
    }

    public ImmutableList<TargetAtom> getCQ(NamedRelationDefinition table, Map<NamedRelationDefinition, BnodeStringTemplateFunctionSymbol> bnodeTemplateMap) {
        ImmutableList.Builder atoms = ImmutableList.builder();
        ImmutableTerm sub = this.generateTerm(table, "", bnodeTemplateMap);
        atoms.add((Object)this.getAtom(this.rdfFactory.createIRI(this.getTableIRIString(table)), sub));
        for (Attribute att : table.getAttributes()) {
            IRI typeIRI = att.getTermType().getNaturalRDFDatatype().map(RDFDatatype::getIRI).orElse(XSD.STRING);
            Variable objV = this.termFactory.getVariable(att.getID().getName());
            ImmutableFunctionalTerm obj = this.termFactory.getRDFLiteralFunctionalTerm((ImmutableTerm)objV, typeIRI);
            atoms.add((Object)this.getAtom(this.getLiteralPropertyIRI(att), sub, (ImmutableTerm)obj));
        }
        return atoms.build();
    }

    public ImmutableList<TargetAtom> getRefCQ(ForeignKeyConstraint fk, Map<NamedRelationDefinition, BnodeStringTemplateFunctionSymbol> bnodeTemplateMap) {
        ImmutableTerm sub = this.generateTerm(fk.getRelation(), DirectMappingAxiomProducer.getTableName(fk.getRelation()) + "_", bnodeTemplateMap);
        ImmutableTerm obj = this.generateTerm(fk.getReferencedRelation(), DirectMappingAxiomProducer.getTableName(fk.getReferencedRelation()) + "_", bnodeTemplateMap);
        TargetAtom atom = this.getAtom(this.getReferencePropertyIRI(fk), sub, obj);
        return ImmutableList.of((Object)atom);
    }

    private String getTableIRIString(NamedRelationDefinition table) {
        return this.baseIRI + R2RMLIRISafeEncoder.encode((String)DirectMappingAxiomProducer.getTableName(table));
    }

    private IRI getLiteralPropertyIRI(Attribute attr) {
        return this.rdfFactory.createIRI(this.getTableIRIString((NamedRelationDefinition)attr.getRelation()) + "#" + R2RMLIRISafeEncoder.encode((String)attr.getID().getName()));
    }

    private IRI getReferencePropertyIRI(ForeignKeyConstraint fk) {
        return this.rdfFactory.createIRI(this.getTableIRIString(fk.getRelation()) + "#ref-" + fk.getComponents().stream().map(c -> R2RMLIRISafeEncoder.encode((String)c.getAttribute().getID().getName())).collect(Collectors.joining(";")));
    }

    private ImmutableTerm generateTerm(NamedRelationDefinition td, String varNamePrefix, Map<NamedRelationDefinition, BnodeStringTemplateFunctionSymbol> bnodeTemplateMap) {
        Optional pko = td.getPrimaryKey();
        if (pko.isPresent()) {
            UniqueConstraint pk = (UniqueConstraint)pko.get();
            Template.Builder builder = Template.builder();
            builder.addSeparator(this.getTableIRIString(td) + "/" + R2RMLIRISafeEncoder.encode((String)((Attribute)pk.getAttributes().get(0)).getID().getName()) + "=");
            builder.addColumn();
            for (int i = 1; i < pk.getAttributes().size(); ++i) {
                builder.addSeparator(";" + R2RMLIRISafeEncoder.encode((String)((Attribute)pk.getAttributes().get(i)).getID().getName()) + "=");
                builder.addColumn();
            }
            ImmutableList arguments = (ImmutableList)pk.getAttributes().stream().map(a -> this.termFactory.getVariable(varNamePrefix + a.getID().getName())).collect(ImmutableCollectors.toList());
            return this.termFactory.getIRIFunctionalTerm(builder.build(), arguments);
        }
        ImmutableList vars = (ImmutableList)td.getAttributes().stream().map(a -> this.termFactory.getVariable(varNamePrefix + a.getID().getName())).collect(ImmutableCollectors.toList());
        BnodeStringTemplateFunctionSymbol functionSymbol = bnodeTemplateMap.computeIfAbsent(td, d -> this.dbFunctionSymbolFactory.getFreshBnodeStringTemplateFunctionSymbol(vars.size()));
        ImmutableFunctionalTerm lexicalTerm = this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)functionSymbol, vars);
        return this.termFactory.getRDFFunctionalTerm((ImmutableTerm)lexicalTerm, (ImmutableTerm)this.termFactory.getRDFTermTypeConstant((RDFTermType)this.typeFactory.getBlankNodeType()));
    }

    private TargetAtom getAtom(IRI iri, ImmutableTerm s, ImmutableTerm o) {
        return this.targetAtomFactory.getTripleTargetAtom(s, (ImmutableTerm)this.termFactory.getConstantIRI(iri), o);
    }

    private TargetAtom getAtom(IRI iri, ImmutableTerm s) {
        return this.targetAtomFactory.getTripleTargetAtom(s, (ImmutableTerm)this.termFactory.getConstantIRI(it.unibz.inf.ontop.model.vocabulary.RDF.TYPE), (ImmutableTerm)this.termFactory.getConstantIRI(iri));
    }
}

