/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.bootstrap.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.BnodeStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.TargetAtomFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.R2RMLIRISafeEncoder;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;

public class DirectMappingAxiomProducer {
    private final String baseIRI;
    private final TermFactory termFactory;
    private final RDF rdfFactory;
    private final DBFunctionSymbolFactory dbFunctionSymbolFactory;
    private final TargetAtomFactory targetAtomFactory;
    private final TypeFactory typeFactory;

    public DirectMappingAxiomProducer(String baseIRI, TermFactory termFactory, TargetAtomFactory targetAtomFactory, RDF rdfFactory, DBFunctionSymbolFactory dbFunctionSymbolFactory, TypeFactory typeFactory) {
        this.baseIRI = Objects.requireNonNull(baseIRI, "Base IRI must not be null!");
        this.termFactory = termFactory;
        this.targetAtomFactory = targetAtomFactory;
        this.rdfFactory = rdfFactory;
        this.dbFunctionSymbolFactory = dbFunctionSymbolFactory;
        this.typeFactory = typeFactory;
    }

    public String getSQL(DatabaseRelationDefinition table) {
        return String.format("SELECT * FROM %s", table.getID().getSQLRendering());
    }

    public String getRefSQL(ForeignKeyConstraint fk) {
        String columns = Stream.concat(DirectMappingAxiomProducer.getIdentifyingAttributes(fk.getRelation()).stream(), DirectMappingAxiomProducer.getIdentifyingAttributes(fk.getReferencedRelation()).stream()).map(a -> DirectMappingAxiomProducer.getQualifiedColumnName(a) + " AS " + DirectMappingAxiomProducer.getColumnAlias(a)).collect(Collectors.joining(", "));
        String tables = fk.getRelation().getID().getSQLRendering() + ", " + fk.getReferencedRelation().getID().getSQLRendering();
        String conditions = fk.getComponents().stream().map(c -> DirectMappingAxiomProducer.getQualifiedColumnName(c.getAttribute()) + " = " + DirectMappingAxiomProducer.getQualifiedColumnName(c.getReferencedAttribute())).collect(Collectors.joining(" AND "));
        return String.format("SELECT %s FROM %s WHERE %s", columns, tables, conditions);
    }

    private static ImmutableList<Attribute> getIdentifyingAttributes(DatabaseRelationDefinition table) {
        Optional pk = table.getPrimaryKey();
        return pk.map(UniqueConstraint::getAttributes).orElse(table.getAttributes());
    }

    private static String getColumnAlias(Attribute attr) {
        return ((DatabaseRelationDefinition)attr.getRelation()).getID().getTableID().getName() + "_" + attr.getID().getName();
    }

    private static String getQualifiedColumnName(Attribute attr) {
        return new QualifiedAttributeID(((DatabaseRelationDefinition)attr.getRelation()).getID(), attr.getID()).getSQLRendering();
    }

    public ImmutableList<TargetAtom> getCQ(DatabaseRelationDefinition table, Map<DatabaseRelationDefinition, BnodeStringTemplateFunctionSymbol> bnodeTemplateMap) {
        ImmutableList.Builder atoms = ImmutableList.builder();
        ImmutableTerm sub = this.generateTerm(table, "", bnodeTemplateMap);
        atoms.add((Object)this.getAtom(this.rdfFactory.createIRI(this.getTableIRIString(table)), sub));
        for (Attribute att : table.getAttributes()) {
            IRI typeIRI = att.getTermType().getNaturalRDFDatatype().map(RDFDatatype::getIRI).orElse(XSD.STRING);
            Variable objV = this.termFactory.getVariable(att.getID().getName());
            ImmutableFunctionalTerm obj = this.termFactory.getRDFLiteralFunctionalTerm((ImmutableTerm)objV, typeIRI);
            atoms.add((Object)this.getAtom(this.getLiteralPropertyIRI(att), sub, (ImmutableTerm)obj));
        }
        return atoms.build();
    }

    public ImmutableList<TargetAtom> getRefCQ(ForeignKeyConstraint fk, Map<DatabaseRelationDefinition, BnodeStringTemplateFunctionSymbol> bnodeTemplateMap) {
        ImmutableTerm sub = this.generateTerm(fk.getRelation(), fk.getRelation().getID().getTableID().getName() + "_", bnodeTemplateMap);
        ImmutableTerm obj = this.generateTerm(fk.getReferencedRelation(), fk.getReferencedRelation().getID().getTableID().getName() + "_", bnodeTemplateMap);
        TargetAtom atom = this.getAtom(this.getReferencePropertyIRI(fk), sub, obj);
        return ImmutableList.of((Object)atom);
    }

    private String getTableIRIString(DatabaseRelationDefinition table) {
        return this.baseIRI + R2RMLIRISafeEncoder.encode((String)table.getID().getTableID().getName());
    }

    private IRI getLiteralPropertyIRI(Attribute attr) {
        return this.rdfFactory.createIRI(this.getTableIRIString((DatabaseRelationDefinition)attr.getRelation()) + "#" + R2RMLIRISafeEncoder.encode((String)attr.getID().getName()));
    }

    private IRI getReferencePropertyIRI(ForeignKeyConstraint fk) {
        return this.rdfFactory.createIRI(this.getTableIRIString(fk.getRelation()) + "#ref-" + fk.getComponents().stream().map(c -> R2RMLIRISafeEncoder.encode((String)c.getAttribute().getID().getName())).collect(Collectors.joining(";")));
    }

    private ImmutableTerm generateTerm(DatabaseRelationDefinition td, String varNamePrefix, Map<DatabaseRelationDefinition, BnodeStringTemplateFunctionSymbol> bnodeTemplateMap) {
        Optional pko = td.getPrimaryKey();
        if (pko.isPresent()) {
            UniqueConstraint pk = (UniqueConstraint)pko.get();
            String template = this.getTableIRIString(td) + "/" + pk.getAttributes().stream().map(a -> R2RMLIRISafeEncoder.encode((String)a.getID().getName()) + "={}").collect(Collectors.joining(";"));
            ImmutableList arguments = (ImmutableList)pk.getAttributes().stream().map(a -> this.termFactory.getVariable(varNamePrefix + a.getID().getName())).collect(ImmutableCollectors.toList());
            return this.termFactory.getIRIFunctionalTerm(template, arguments);
        }
        ImmutableList vars = (ImmutableList)td.getAttributes().stream().map(a -> this.termFactory.getVariable(varNamePrefix + a.getID().getName())).collect(ImmutableCollectors.toList());
        BnodeStringTemplateFunctionSymbol functionSymbol = bnodeTemplateMap.computeIfAbsent(td, d -> this.dbFunctionSymbolFactory.getFreshBnodeStringTemplateFunctionSymbol(vars.size()));
        ImmutableFunctionalTerm lexicalTerm = this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)functionSymbol, vars);
        return this.termFactory.getRDFFunctionalTerm((ImmutableTerm)lexicalTerm, (ImmutableTerm)this.termFactory.getRDFTermTypeConstant((RDFTermType)this.typeFactory.getBlankNodeType()));
    }

    private TargetAtom getAtom(IRI iri, ImmutableTerm s, ImmutableTerm o) {
        return this.targetAtomFactory.getTripleTargetAtom(s, (ImmutableTerm)this.termFactory.getConstantIRI(iri), o);
    }

    private TargetAtom getAtom(IRI iri, ImmutableTerm s) {
        return this.targetAtomFactory.getTripleTargetAtom(s, (ImmutableTerm)this.termFactory.getConstantIRI(it.unibz.inf.ontop.model.vocabulary.RDF.TYPE), (ImmutableTerm)this.termFactory.getConstantIRI(iri));
    }
}

