/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.bootstrap.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.RDBMetadata;
import it.unibz.inf.ontop.dbschema.RDBMetadataExtractionTools;
import it.unibz.inf.ontop.exception.DuplicateMappingException;
import it.unibz.inf.ontop.exception.MappingBootstrappingException;
import it.unibz.inf.ontop.exception.MappingException;
import it.unibz.inf.ontop.injection.OntopMappingSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.injection.OntopSQLCredentialSettings;
import it.unibz.inf.ontop.injection.SQLPPMappingFactory;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.model.atom.TargetAtom;
import it.unibz.inf.ontop.model.atom.TargetAtomFactory;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.BnodeStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.spec.mapping.MappingMetadata;
import it.unibz.inf.ontop.spec.mapping.OBDASQLQuery;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.SQLMappingFactory;
import it.unibz.inf.ontop.spec.mapping.bootstrap.DirectMappingBootstrapper;
import it.unibz.inf.ontop.spec.mapping.bootstrap.impl.DirectMappingAxiomProducer;
import it.unibz.inf.ontop.spec.mapping.impl.SQLMappingFactoryImpl;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.OntopNativeSQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.util.MappingOntologyUtils;
import it.unibz.inf.ontop.utils.LocalJDBCConnectionUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.rdf.api.RDF;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class DirectMappingEngine {
    private static final SQLMappingFactory SQL_MAPPING_FACTORY = SQLMappingFactoryImpl.getInstance();
    private final SpecificationFactory specificationFactory;
    private final SQLPPMappingFactory ppMappingFactory;
    private final TypeFactory typeFactory;
    private final TermFactory termFactory;
    private final RDF rdfFactory;
    private final OntopSQLCredentialSettings settings;
    private final TargetAtomFactory targetAtomFactory;
    private final DBFunctionSymbolFactory dbFunctionSymbolFactory;
    private String baseIRI;
    private int currentMappingIndex = 1;

    static DirectMappingBootstrapper.BootstrappingResults bootstrap(OntopMappingSQLOWLAPIConfiguration configuration, String baseIRI) throws MappingException, OWLOntologyCreationException, MappingBootstrappingException {
        DirectMappingEngine engine = (DirectMappingEngine)configuration.getInjector().getInstance(DirectMappingEngine.class);
        return engine.bootstrapMappingAndOntology(baseIRI, configuration.loadPPMapping(), configuration.loadInputOntology());
    }

    @Inject
    private DirectMappingEngine(OntopSQLCredentialSettings settings, SpecificationFactory specificationFactory, SQLPPMappingFactory ppMappingFactory, TypeFactory typeFactory, TermFactory termFactory, RDF rdfFactory, TargetAtomFactory targetAtomFactory, DBFunctionSymbolFactory dbFunctionSymbolFactory) {
        this.specificationFactory = specificationFactory;
        this.ppMappingFactory = ppMappingFactory;
        this.settings = settings;
        this.typeFactory = typeFactory;
        this.termFactory = termFactory;
        this.rdfFactory = rdfFactory;
        this.targetAtomFactory = targetAtomFactory;
        this.dbFunctionSymbolFactory = dbFunctionSymbolFactory;
    }

    private DirectMappingBootstrapper.BootstrappingResults bootstrapMappingAndOntology(String baseIRI, Optional<SQLPPMapping> inputPPMapping, Optional<OWLOntology> inputOntology) throws MappingBootstrappingException {
        this.baseIRI = DirectMappingEngine.fixBaseURI(baseIRI);
        try {
            SQLPPMapping newPPMapping = this.extractPPMapping(inputPPMapping);
            OWLOntology ontology = inputOntology.isPresent() ? inputOntology.get() : OWLManager.createOWLOntologyManager().createOntology(IRI.create((String)baseIRI));
            OWLOntologyManager manager = ontology.getOWLOntologyManager();
            Set<OWLDeclarationAxiom> declarationAxioms = MappingOntologyUtils.extractDeclarationAxioms(manager, newPPMapping.getTripleMaps().stream().flatMap(ax -> ax.getTargetAtoms().stream()), this.typeFactory, true);
            manager.addAxioms(ontology, declarationAxioms);
            return new DefaultBootstrappingResults(newPPMapping, ontology);
        }
        catch (MappingException | SQLException | OWLOntologyCreationException e) {
            throw new MappingBootstrappingException((Exception)e);
        }
    }

    public static String fixBaseURI(String prefix) {
        if (prefix.endsWith("#")) {
            return prefix.replace("#", "/");
        }
        if (prefix.endsWith("/")) {
            return prefix;
        }
        return prefix + "/";
    }

    private SQLPPMapping extractPPMapping(Optional<SQLPPMapping> ppMapping) throws MappingException, SQLException {
        SQLPPMapping mapping;
        if (!ppMapping.isPresent()) {
            PrefixManager prefixManager = this.specificationFactory.createPrefixManager(ImmutableMap.of());
            MappingMetadata mappingMetadata = this.specificationFactory.createMetadata(prefixManager);
            mapping = this.ppMappingFactory.createSQLPreProcessedMapping(ImmutableList.of(), mappingMetadata);
        } else {
            mapping = ppMapping.get();
        }
        this.currentMappingIndex = mapping.getTripleMaps().size() + 1;
        return this.bootstrapMappings(mapping);
    }

    private SQLPPMapping bootstrapMappings(SQLPPMapping ppMapping) throws SQLException, DuplicateMappingException {
        if (ppMapping == null) {
            throw new IllegalArgumentException("Model should not be null");
        }
        try (Connection conn = LocalJDBCConnectionUtils.createConnection((OntopSQLCredentialSettings)this.settings);){
            RDBMetadata metadata = RDBMetadataExtractionTools.createMetadata((Connection)conn, (TypeFactory)this.typeFactory);
            RDBMetadataExtractionTools.loadMetadata((RDBMetadata)metadata, (Connection)conn, null);
            SQLPPMapping sQLPPMapping = this.bootstrapMappings(metadata, ppMapping);
            return sQLPPMapping;
        }
    }

    private SQLPPMapping bootstrapMappings(RDBMetadata metadata, SQLPPMapping ppMapping) throws DuplicateMappingException {
        if (this.baseIRI == null || this.baseIRI.isEmpty()) {
            this.baseIRI = ppMapping.getMetadata().getPrefixManager().getDefaultPrefix();
        }
        Collection tables = metadata.getDatabaseRelations();
        ArrayList<SQLPPTriplesMap> mappingAxioms = new ArrayList<SQLPPTriplesMap>();
        HashMap<DatabaseRelationDefinition, BnodeStringTemplateFunctionSymbol> bnodeTemplateMap = new HashMap<DatabaseRelationDefinition, BnodeStringTemplateFunctionSymbol>();
        for (DatabaseRelationDefinition td : tables) {
            mappingAxioms.addAll(this.getMapping(td, this.baseIRI, bnodeTemplateMap));
        }
        ArrayList<SQLPPTriplesMap> mappings = new ArrayList<SQLPPTriplesMap>();
        mappings.addAll((Collection<SQLPPTriplesMap>)ppMapping.getTripleMaps());
        mappings.addAll(mappingAxioms);
        return this.ppMappingFactory.createSQLPreProcessedMapping(ImmutableList.copyOf(mappings), ppMapping.getMetadata());
    }

    private List<SQLPPTriplesMap> getMapping(DatabaseRelationDefinition table, String baseUri, Map<DatabaseRelationDefinition, BnodeStringTemplateFunctionSymbol> bnodeTemplateMap) {
        DirectMappingAxiomProducer dmap = new DirectMappingAxiomProducer(baseUri, this.termFactory, this.targetAtomFactory, this.rdfFactory, this.dbFunctionSymbolFactory, this.typeFactory);
        ArrayList<SQLPPTriplesMap> axioms = new ArrayList<SQLPPTriplesMap>();
        axioms.add((SQLPPTriplesMap)new OntopNativeSQLPPTriplesMap("MAPPING-ID" + this.currentMappingIndex, SQL_MAPPING_FACTORY.getSQLQuery(dmap.getSQL(table)), dmap.getCQ(table, bnodeTemplateMap)));
        ++this.currentMappingIndex;
        Map<String, ImmutableList<TargetAtom>> refAxioms = dmap.getRefAxioms(table, bnodeTemplateMap);
        for (Map.Entry<String, ImmutableList<TargetAtom>> e : refAxioms.entrySet()) {
            OBDASQLQuery sqlQuery = SQL_MAPPING_FACTORY.getSQLQuery(e.getKey());
            ImmutableList<TargetAtom> targetQuery = e.getValue();
            axioms.add((SQLPPTriplesMap)new OntopNativeSQLPPTriplesMap("MAPPING-ID" + this.currentMappingIndex, sqlQuery, targetQuery));
            ++this.currentMappingIndex;
        }
        return axioms;
    }

    public static class DefaultBootstrappingResults
    implements DirectMappingBootstrapper.BootstrappingResults {
        private final SQLPPMapping ppMapping;
        private final OWLOntology ontology;

        public DefaultBootstrappingResults(SQLPPMapping ppMapping, OWLOntology ontology) {
            this.ppMapping = ppMapping;
            this.ontology = ontology;
        }

        @Override
        public SQLPPMapping getPPMapping() {
            return this.ppMapping;
        }

        @Override
        public OWLOntology getOntology() {
            return this.ontology;
        }
    }
}

