/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.bootstrap.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.model.atom.TargetAtom;
import it.unibz.inf.ontop.model.atom.TargetAtomFactory;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.BnodeStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.R2RMLIRISafeEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;

public class DirectMappingAxiomProducer {
    private final String baseIRI;
    private final TermFactory termFactory;
    private final RDF rdfFactory;
    private final DBFunctionSymbolFactory dbFunctionSymbolFactory;
    private final TargetAtomFactory targetAtomFactory;
    private final TypeFactory typeFactory;

    public DirectMappingAxiomProducer(String baseIRI, TermFactory termFactory, TargetAtomFactory targetAtomFactory, RDF rdfFactory, DBFunctionSymbolFactory dbFunctionSymbolFactory, TypeFactory typeFactory) {
        this.termFactory = termFactory;
        this.baseIRI = Objects.requireNonNull(baseIRI, "Base IRI must not be null!");
        this.targetAtomFactory = targetAtomFactory;
        this.rdfFactory = rdfFactory;
        this.dbFunctionSymbolFactory = dbFunctionSymbolFactory;
        this.typeFactory = typeFactory;
    }

    public String getSQL(DatabaseRelationDefinition table) {
        return String.format("SELECT * FROM %s", table.getID().getSQLRendering());
    }

    public Map<String, ImmutableList<TargetAtom>> getRefAxioms(DatabaseRelationDefinition table, Map<DatabaseRelationDefinition, BnodeStringTemplateFunctionSymbol> bnodeTemplateMap) {
        HashMap<String, ImmutableList<TargetAtom>> refAxioms = new HashMap<String, ImmutableList<TargetAtom>>();
        for (ForeignKeyConstraint fk : table.getForeignKeys()) {
            refAxioms.put(this.getRefSQL(fk), this.getRefCQ(fk, bnodeTemplateMap));
        }
        return refAxioms;
    }

    private String getRefSQL(ForeignKeyConstraint fk) {
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        for (Attribute attribute : DirectMappingAxiomProducer.getIdentifyingAttributes(fk.getRelation())) {
            columns.add(DirectMappingAxiomProducer.getColumnNameWithAlias(attribute));
        }
        ArrayList<String> conditions = new ArrayList<String>(fk.getComponents().size());
        for (ForeignKeyConstraint.Component comp : fk.getComponents()) {
            columns.add(DirectMappingAxiomProducer.getColumnNameWithAlias(comp.getReference()));
            conditions.add(DirectMappingAxiomProducer.getColumnName(comp.getAttribute()) + " = " + DirectMappingAxiomProducer.getColumnName(comp.getReference()));
        }
        for (Attribute attr : DirectMappingAxiomProducer.getIdentifyingAttributes(fk.getReferencedRelation())) {
            columns.add(DirectMappingAxiomProducer.getColumnNameWithAlias(attr));
        }
        String string = fk.getRelation().getID().getSQLRendering() + ", " + fk.getReferencedRelation().getID().getSQLRendering();
        return String.format("SELECT %s FROM %s WHERE %s", Joiner.on((String)", ").join(columns), string, Joiner.on((String)" AND ").join(conditions));
    }

    private static List<Attribute> getIdentifyingAttributes(DatabaseRelationDefinition table) {
        UniqueConstraint pk = table.getPrimaryKey();
        if (pk != null) {
            return pk.getAttributes();
        }
        return table.getAttributes();
    }

    private static String getColumnNameWithAlias(Attribute attr) {
        return DirectMappingAxiomProducer.getColumnName(attr) + " AS " + attr.getRelation().getID().getTableName() + "_" + attr.getID().getName();
    }

    private static String getColumnName(Attribute attr) {
        return attr.getQualifiedID().getSQLRendering();
    }

    public ImmutableList<TargetAtom> getCQ(DatabaseRelationDefinition table, Map<DatabaseRelationDefinition, BnodeStringTemplateFunctionSymbol> bnodeTemplateMap) {
        ImmutableList.Builder atoms = ImmutableList.builder();
        ImmutableTerm sub = this.generateSubject(table, false, bnodeTemplateMap);
        atoms.add((Object)this.getAtom(this.getTableIRI(table.getID()), sub));
        for (Attribute att : table.getAttributes()) {
            IRI typeIRI = att.getTermType().flatMap(DBTermType::getNaturalRDFDatatype).map(RDFDatatype::getIRI).orElse(XSD.STRING);
            Variable objV = this.termFactory.getVariable(att.getID().getName());
            ImmutableFunctionalTerm obj = this.termFactory.getRDFLiteralFunctionalTerm((ImmutableTerm)objV, typeIRI);
            atoms.add((Object)this.getAtom(this.getLiteralPropertyIRI(att), sub, (ImmutableTerm)obj));
        }
        return atoms.build();
    }

    private ImmutableList<TargetAtom> getRefCQ(ForeignKeyConstraint fk, Map<DatabaseRelationDefinition, BnodeStringTemplateFunctionSymbol> bnodeTemplateMap) {
        ImmutableTerm sub = this.generateSubject(fk.getRelation(), true, bnodeTemplateMap);
        ImmutableTerm obj = this.generateSubject(fk.getReferencedRelation(), true, bnodeTemplateMap);
        TargetAtom atom = this.getAtom(this.getReferencePropertyIRI(fk), sub, obj);
        return ImmutableList.of((Object)atom);
    }

    private IRI getTableIRI(RelationID tableId) {
        return this.rdfFactory.createIRI(this.baseIRI + R2RMLIRISafeEncoder.encode((String)tableId.getTableName()));
    }

    private IRI getLiteralPropertyIRI(Attribute attr) {
        return this.rdfFactory.createIRI(this.baseIRI + R2RMLIRISafeEncoder.encode((String)attr.getRelation().getID().getTableName()) + "#" + R2RMLIRISafeEncoder.encode((String)attr.getID().getName()));
    }

    private IRI getReferencePropertyIRI(ForeignKeyConstraint fk) {
        ArrayList<String> attributes = new ArrayList<String>(fk.getComponents().size());
        for (ForeignKeyConstraint.Component component : fk.getComponents()) {
            attributes.add(R2RMLIRISafeEncoder.encode((String)component.getAttribute().getID().getName()));
        }
        return this.rdfFactory.createIRI(this.baseIRI + R2RMLIRISafeEncoder.encode((String)fk.getRelation().getID().getTableName()) + "#ref-" + Joiner.on((String)";").join(attributes));
    }

    private ImmutableTerm generateSubject(DatabaseRelationDefinition td, boolean ref, Map<DatabaseRelationDefinition, BnodeStringTemplateFunctionSymbol> bnodeTemplateMap) {
        String varNamePrefix = ref ? td.getID().getTableName() + "_" : "";
        UniqueConstraint pk = td.getPrimaryKey();
        if (pk != null) {
            ArrayList<String> attributes = new ArrayList<String>(pk.getAttributes().size());
            for (Attribute att : pk.getAttributes()) {
                attributes.add(R2RMLIRISafeEncoder.encode((String)att.getID().getName()) + "={}");
            }
            String template = this.baseIRI + R2RMLIRISafeEncoder.encode((String)td.getID().getTableName()) + "/" + Joiner.on((String)";").join(attributes);
            ImmutableList arguments = (ImmutableList)pk.getAttributes().stream().map(a -> this.termFactory.getVariable(varNamePrefix + a.getID().getName())).collect(ImmutableCollectors.toList());
            return this.termFactory.getIRIFunctionalTerm(template, arguments);
        }
        ArrayList<Variable> vars = new ArrayList<Variable>(td.getAttributes().size());
        for (Attribute att : td.getAttributes()) {
            vars.add(this.termFactory.getVariable(varNamePrefix + att.getID().getName()));
        }
        BnodeStringTemplateFunctionSymbol functionSymbol = bnodeTemplateMap.computeIfAbsent(td, d -> this.dbFunctionSymbolFactory.getFreshBnodeStringTemplateFunctionSymbol(vars.size()));
        ImmutableFunctionalTerm lexicalTerm = this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)functionSymbol, ImmutableList.copyOf(vars));
        return this.termFactory.getRDFFunctionalTerm((ImmutableTerm)lexicalTerm, (ImmutableTerm)this.termFactory.getRDFTermTypeConstant((RDFTermType)this.typeFactory.getBlankNodeType()));
    }

    private TargetAtom getAtom(IRI iri, ImmutableTerm s, ImmutableTerm o) {
        return this.targetAtomFactory.getTripleTargetAtom(s, (ImmutableTerm)this.termFactory.getConstantIRI(iri), o);
    }

    private TargetAtom getAtom(IRI iri, ImmutableTerm s) {
        return this.targetAtomFactory.getTripleTargetAtom(s, (ImmutableTerm)this.termFactory.getConstantIRI(it.unibz.inf.ontop.model.vocabulary.RDF.TYPE), (ImmutableTerm)this.termFactory.getConstantIRI(iri));
    }
}

