/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.pp.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.RawQuotedIDFactory;
import it.unibz.inf.ontop.exception.InvalidMappingSourceQueriesException;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.pp.PPMappingAssertionProvenance;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMappingConverter;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.OntopNativeSQLPPTriplesMap;
import it.unibz.inf.ontop.spec.sqlparser.RAExpression;
import it.unibz.inf.ontop.spec.sqlparser.RAExpression2IQConverter;
import it.unibz.inf.ontop.spec.sqlparser.SQLQueryParser;
import it.unibz.inf.ontop.spec.sqlparser.exception.InvalidSelectQueryException;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.Var2VarSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLPPMappingConverterImpl
implements SQLPPMappingConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLPPMappingConverterImpl.class);
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;
    private final SQLQueryParser sqlQueryParser;
    private final RAExpression2IQConverter raExpression2IQConverter;

    @Inject
    private SQLPPMappingConverterImpl(CoreSingletons coreSingletons, SQLQueryParser sqlQueryParser, RAExpression2IQConverter raExpression2IQConverter) {
        this.iqFactory = coreSingletons.getIQFactory();
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
        this.sqlQueryParser = sqlQueryParser;
        this.raExpression2IQConverter = raExpression2IQConverter;
    }

    public ImmutableList<MappingAssertion> convert(ImmutableList<SQLPPTriplesMap> mapping, MetadataLookup metadataLookup) throws InvalidMappingSourceQueriesException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SQLPPTriplesMap assertion : mapping) {
            RAExpression re = this.getRAExpression(assertion, metadataLookup);
            IQTree tree = this.raExpression2IQConverter.convert(re);
            Function<Variable, Optional<ImmutableTerm>> lookup = SQLPPMappingConverterImpl.placeholderLookup(assertion, metadataLookup.getQuotedIDFactory(), re.getUnqualifiedAttributes());
            for (TargetAtom target : assertion.getTargetAtoms()) {
                PPMappingAssertionProvenance provenance = assertion.getMappingAssertionProvenance(target);
                builder.add((Object)this.convert(target, lookup, provenance, tree));
            }
        }
        ImmutableList result = builder.build();
        LOGGER.debug("Original mapping size: {}", (Object)result.size());
        return result;
    }

    private static <T> Function<Variable, Optional<T>> placeholderLookup(SQLPPTriplesMap mappingAssertion, QuotedIDFactory idFactory, ImmutableMap<QuotedID, T> lookup) {
        Function<Variable, Optional<T>> standard = v -> Optional.ofNullable(lookup.get((Object)idFactory.createAttributeID(v.getName())));
        if (mappingAssertion instanceof OntopNativeSQLPPTriplesMap) {
            RawQuotedIDFactory rawIdFactory = new RawQuotedIDFactory(idFactory);
            return arg_0 -> SQLPPMappingConverterImpl.lambda$placeholderLookup$1(standard, lookup, (QuotedIDFactory)rawIdFactory, arg_0);
        }
        return standard;
    }

    private MappingAssertion convert(TargetAtom target, Function<Variable, Optional<ImmutableTerm>> lookup, PPMappingAssertionProvenance provenance, IQTree tree) throws InvalidMappingSourceQueriesException {
        ImmutableMap targetPreMap = (ImmutableMap)target.getProjectionAtom().getArguments().stream().map(v -> target.getSubstitution().apply((ImmutableTerm)v)).flatMap(ImmutableTerm::getVariableStream).distinct().collect(ImmutableCollectors.toMap(Function.identity(), lookup));
        if (targetPreMap.values().stream().anyMatch(t -> !t.isPresent())) {
            throw new InvalidMappingSourceQueriesException(targetPreMap.entrySet().stream().filter(e -> !((Optional)e.getValue()).isPresent()).map(Map.Entry::getKey).map(Variable::getName).collect(Collectors.joining(", ", "The placeholder(s) ", " in the target do(es) not occur in source query of the mapping assertion\n[" + provenance.getProvenanceInfo() + "]")));
        }
        ImmutableMap targetMap = (ImmutableMap)targetPreMap.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> (ImmutableTerm)((Optional)e.getValue()).orElseThrow(() -> new MinorOntopInternalBugException("Impossible"))));
        Var2VarSubstitution targetRenamingPart = this.substitutionFactory.getVar2VarSubstitution((ImmutableMap)targetMap.entrySet().stream().filter(e -> e.getValue() instanceof Variable).filter(e -> !((ImmutableTerm)e.getValue()).equals(e.getKey())).map(e -> Maps.immutableEntry(e.getKey(), (Object)((Variable)e.getValue()))).collect(ImmutableCollectors.toMap()));
        ImmutableSubstitution spoSubstitution = targetRenamingPart.applyToTarget(target.getSubstitution());
        ImmutableSubstitution selectSubstitution = this.substitutionFactory.getSubstitution((ImmutableMap)targetMap.entrySet().stream().filter(e -> !(e.getValue() instanceof Variable)).collect(ImmutableCollectors.toMap()));
        UnaryIQTree selectTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode((ImmutableSet)spoSubstitution.getImmutableMap().values().stream().flatMap(ImmutableTerm::getVariableStream).collect(ImmutableCollectors.toSet()), selectSubstitution), tree);
        UnaryIQTree mappingTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(target.getProjectionAtom().getVariables(), spoSubstitution), (IQTree)selectTree);
        return new MappingAssertion(this.iqFactory.createIQ(target.getProjectionAtom(), (IQTree)mappingTree), provenance);
    }

    public RAExpression getRAExpression(SQLPPTriplesMap mappingAssertion, MetadataLookup metadataLookup) throws InvalidMappingSourceQueriesException {
        String sourceQuery = mappingAssertion.getSourceQuery().getSQL();
        try {
            return this.sqlQueryParser.getRAExpression(sourceQuery, metadataLookup);
        }
        catch (InvalidSelectQueryException e) {
            throw new InvalidMappingSourceQueriesException("Error: " + e.getMessage() + " \nProblem location: source query of triplesMap \n[" + mappingAssertion.getTriplesMapProvenance().getProvenanceInfo() + "]");
        }
    }

    private static /* synthetic */ Optional lambda$placeholderLookup$1(Function standard, ImmutableMap lookup, QuotedIDFactory rawIdFactory, Variable v) {
        return Optional.ofNullable(((Optional)standard.apply(v)).orElse(lookup.get((Object)rawIdFactory.createAttributeID(v.getName()))));
    }
}

