/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.sqlparser;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.spec.mapping.sqlparser.RAExpressionAttributes;
import it.unibz.inf.ontop.spec.mapping.sqlparser.RAExpressionAttributesOperations;
import it.unibz.inf.ontop.spec.mapping.sqlparser.exception.InvalidSelectQueryRuntimeException;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;

public class SelectItemParser {
    private final QuotedIDFactory idfac;
    private final RAExpressionAttributes attributes;
    private final Function<Expression, ImmutableTerm> expressionParser;

    SelectItemParser(RAExpressionAttributes attributes, BiFunction<Expression, RAExpressionAttributes, ImmutableTerm> expressionParser, QuotedIDFactory idfac) {
        this.idfac = idfac;
        this.attributes = attributes;
        this.expressionParser = e -> (ImmutableTerm)expressionParser.apply((Expression)e, attributes);
    }

    public RAExpressionAttributes parseSelectItems(List<SelectItem> selectItems) {
        try {
            ImmutableMap map = (ImmutableMap)selectItems.stream().flatMap(si -> new SelectItemProcessor().getAttributes(si)).collect(ImmutableCollectors.toMap());
            return new RAExpressionAttributesOperations().create((ImmutableMap<QuotedID, ImmutableTerm>)map);
        }
        catch (IllegalArgumentException e) {
            HashMap duplicates = new HashMap();
            selectItems.stream().flatMap(si -> new SelectItemProcessor().getAttributes(si)).forEach(a -> duplicates.put(a.getKey(), duplicates.getOrDefault(a.getKey(), 0) + 1));
            throw new InvalidSelectQueryRuntimeException(duplicates.entrySet().stream().filter(d -> (Integer)d.getValue() > 1).map(Map.Entry::getKey).map(QuotedID::getSQLRendering).collect(Collectors.joining(", ", "Duplicate column names ", " in the SELECT clause: ")), selectItems);
        }
    }

    private class SelectItemProcessor
    implements SelectItemVisitor {
        Stream<Map.Entry<QuotedID, ImmutableTerm>> stream;

        private SelectItemProcessor() {
        }

        private Stream<Map.Entry<QuotedID, ImmutableTerm>> getAttributes(SelectItem si) {
            si.accept((SelectItemVisitor)this);
            return this.stream;
        }

        public void visit(AllColumns allColumns) {
            this.stream = SelectItemParser.this.attributes.asMap().entrySet().stream().filter(e -> ((QualifiedAttributeID)e.getKey()).getRelation() == null).map(e -> Maps.immutableEntry((Object)((QualifiedAttributeID)e.getKey()).getAttribute(), e.getValue()));
        }

        public void visit(AllTableColumns allTableColumns) {
            Table table = allTableColumns.getTable();
            RelationID id = SelectItemParser.this.idfac.createRelationID(table.getSchemaName(), table.getName());
            this.stream = SelectItemParser.this.attributes.asMap().entrySet().stream().filter(e -> ((QualifiedAttributeID)e.getKey()).getRelation() != null && ((QualifiedAttributeID)e.getKey()).getRelation().equals(id)).map(e -> Maps.immutableEntry((Object)((QualifiedAttributeID)e.getKey()).getAttribute(), e.getValue()));
        }

        public void visit(SelectExpressionItem selectExpressionItem) {
            Alias columnAlias = selectExpressionItem.getAlias();
            Expression expr = selectExpressionItem.getExpression();
            Optional<Object> alias = columnAlias != null && columnAlias.getName() != null ? Optional.of(columnAlias.getName()) : (expr instanceof Column ? Optional.of(((Column)expr).getColumnName()) : Optional.empty());
            this.stream = alias.map(a -> Stream.of(Maps.immutableEntry((Object)SelectItemParser.this.idfac.createAttributeID(a), SelectItemParser.this.expressionParser.apply(expr)))).orElse(Stream.of(new Map.Entry[0]));
        }
    }
}

