/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.sqlparser;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.spec.mapping.sqlparser.ExpressionParser;
import it.unibz.inf.ontop.spec.mapping.sqlparser.FromItemParser;
import it.unibz.inf.ontop.spec.mapping.sqlparser.JSqlParserTools;
import it.unibz.inf.ontop.spec.mapping.sqlparser.RAExpressionAttributes;
import it.unibz.inf.ontop.spec.mapping.sqlparser.RAExpressionAttributesOperations;
import it.unibz.inf.ontop.spec.mapping.sqlparser.SelectItemParser;
import it.unibz.inf.ontop.spec.mapping.sqlparser.exception.IllegalJoinException;
import it.unibz.inf.ontop.spec.mapping.sqlparser.exception.InvalidSelectQueryException;
import it.unibz.inf.ontop.spec.mapping.sqlparser.exception.InvalidSelectQueryRuntimeException;
import it.unibz.inf.ontop.spec.mapping.sqlparser.exception.UnsupportedSelectQueryException;
import it.unibz.inf.ontop.spec.mapping.sqlparser.exception.UnsupportedSelectQueryRuntimeException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;

public class DefaultSelectQueryAttributeExtractor
extends FromItemParser<RAExpressionAttributes> {
    private final QuotedIDFactory idfac;
    private final TermFactory termFactory;
    private final CoreSingletons coreSingletons;

    public DefaultSelectQueryAttributeExtractor(MetadataLookup metadata, CoreSingletons coreSingletons) {
        super(new ExpressionParser(metadata.getQuotedIDFactory(), coreSingletons), metadata.getQuotedIDFactory(), metadata, coreSingletons.getTermFactory(), new RAExpressionAttributesOperations());
        this.idfac = metadata.getQuotedIDFactory();
        this.termFactory = coreSingletons.getTermFactory();
        this.coreSingletons = coreSingletons;
    }

    public RAExpressionAttributes getRAExpressionAttributes(SelectBody selectBody) throws InvalidSelectQueryException, UnsupportedSelectQueryException {
        try {
            return this.translateSelectBody(selectBody);
        }
        catch (InvalidSelectQueryRuntimeException e) {
            throw new InvalidSelectQueryException(e.getMessage(), e.getObject());
        }
        catch (UnsupportedSelectQueryRuntimeException e) {
            throw new UnsupportedSelectQueryException(e.getMessage(), e.getObject());
        }
    }

    @Override
    protected RAExpressionAttributes translateSelectBody(SelectBody selectBody) {
        RAExpressionAttributes attributes;
        PlainSelect plainSelect = JSqlParserTools.getPlainSelect(selectBody);
        try {
            attributes = (RAExpressionAttributes)this.translateJoins(plainSelect.getFromItem(), plainSelect.getJoins());
        }
        catch (IllegalJoinException e2) {
            throw new InvalidSelectQueryRuntimeException(e2.toString(), plainSelect);
        }
        ExpressionParser ep = new ExpressionParser(this.idfac, this.coreSingletons);
        SelectItemParser sip = new SelectItemParser(attributes, (e, a) -> e instanceof Column ? ep.parseTerm((Expression)e, (RAExpressionAttributes)a) : this.termFactory.getVariable("something"), this.idfac);
        return sip.parseSelectItems(plainSelect.getSelectItems());
    }

    @Override
    protected RAExpressionAttributes create(DatabaseRelationDefinition relation) {
        return ((RAExpressionAttributesOperations)this.operations).create(relation, (ImmutableList)this.createAttributeVariables((RelationDefinition)relation));
    }
}

