/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.serializer;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.QuadPredicate;
import it.unibz.inf.ontop.model.atom.TriplePredicate;
import it.unibz.inf.ontop.model.term.BNode;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFLiteralConstant;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.BnodeStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.IRIStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.ObjectStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.model.type.impl.BlankNodeTermType;
import it.unibz.inf.ontop.model.type.impl.IRITermType;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.model.vocabulary.RDFS;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.serializer.TurtleWriter;
import java.util.Optional;
import java.util.stream.Collectors;

public class TargetQueryRenderer {
    public static String encode(ImmutableList<TargetAtom> body, PrefixManager prefixManager) {
        TurtleWriter turtleWriter = new TurtleWriter();
        for (TargetAtom atom : body) {
            AtomPredicate atomPredicate = atom.getProjectionAtom().getPredicate();
            ImmutableTerm subjectTerm = atom.getSubstitutedTerm(0);
            String subject = TargetQueryRenderer.displayTerm(subjectTerm, prefixManager);
            ImmutableTerm predicateTerm = atom.getSubstitutedTerm(1);
            String predicate = TargetQueryRenderer.displayTerm(predicateTerm, prefixManager);
            ImmutableTerm objectTerm = atom.getSubstitutedTerm(2);
            String object = TargetQueryRenderer.displayTerm(objectTerm, prefixManager);
            if (atomPredicate instanceof TriplePredicate) {
                turtleWriter.put(subject, predicate, object);
                continue;
            }
            if (atomPredicate instanceof QuadPredicate) {
                ImmutableTerm graphTerm = atom.getSubstitutedTerm(3);
                String graph = TargetQueryRenderer.displayTerm(graphTerm, prefixManager);
                turtleWriter.put(subject, predicate, object, graph);
                continue;
            }
            throw new UnsupportedOperationException("unsupported predicate! " + atomPredicate);
        }
        return turtleWriter.print();
    }

    private static String getAbbreviatedName(String uri, PrefixManager pm, boolean insideQuotes) {
        return pm.getShortForm(uri, insideQuotes);
    }

    private static String concatArg2String(ImmutableTerm term) {
        if (term instanceof Constant) {
            String st = ((Constant)term).getValue();
            if (st.contains("{")) {
                st = st.replace("{", "\\{");
                st = st.replace("}", "\\}");
            }
            return st;
        }
        return "{" + ((Variable)term).getName() + "}";
    }

    private static String displayTerm(ImmutableTerm term, PrefixManager prefixManager) {
        if (TargetQueryRenderer.isTemporaryConversionFunction(term)) {
            return TargetQueryRenderer.displayVariable(TargetQueryRenderer.extractUniqueVariableArgument((ImmutableFunctionalTerm)term));
        }
        if (term instanceof ImmutableFunctionalTerm) {
            return TargetQueryRenderer.displayNonTemporaryFunction((ImmutableFunctionalTerm)term, prefixManager);
        }
        if (term instanceof Variable) {
            return TargetQueryRenderer.displayVariable((Variable)term);
        }
        if (term instanceof IRIConstant) {
            return TargetQueryRenderer.displayIRIConstant((IRIConstant)term, prefixManager);
        }
        if (term instanceof RDFLiteralConstant) {
            return TargetQueryRenderer.displayLiteralConstant((RDFLiteralConstant)term);
        }
        if (term instanceof BNode) {
            return TargetQueryRenderer.displayConstantBnode((BNode)term);
        }
        throw new UnexpectedTermException(term);
    }

    private static String displayConstantBnode(BNode term) {
        return term.getName();
    }

    private static String displayLiteralConstant(RDFLiteralConstant term) {
        return term.toString();
    }

    private static String displayConstantLexicalValue(DBConstant term) {
        return "\"" + term.getValue() + "\"";
    }

    private static String displayIRIConstant(IRIConstant iri, PrefixManager prefixManager) {
        if (iri.getIRI().getIRIString().equals(RDF.TYPE.getIRIString())) {
            return "a";
        }
        return TargetQueryRenderer.getAbbreviatedName(iri.toString(), prefixManager, false);
    }

    private static String displayVariable(Variable term) {
        return "{" + term.getName() + "}";
    }

    private static String displayNonTemporaryFunction(ImmutableFunctionalTerm function, PrefixManager prefixManager) {
        FunctionSymbol functionSymbol = function.getFunctionSymbol();
        if (functionSymbol instanceof DBConcatFunctionSymbol) {
            return TargetQueryRenderer.displayConcat(function);
        }
        if (functionSymbol instanceof RDFTermFunctionSymbol) {
            return TargetQueryRenderer.displayRDFFunction(function, prefixManager);
        }
        return TargetQueryRenderer.displayOrdinaryFunction(function, functionSymbol.getName(), prefixManager);
    }

    private static String displayRDFFunction(ImmutableFunctionalTerm function, PrefixManager prefixManager) {
        ImmutableTerm lexicalTerm = function.getTerm(0);
        Optional<RDFDatatype> optionalDatatype = function.inferType().flatMap(TermTypeInference::getTermType).filter(t -> t instanceof RDFDatatype).map(t -> (RDFDatatype)t);
        if (optionalDatatype.isPresent()) {
            return TargetQueryRenderer.displayDatatypeFunction(lexicalTerm, optionalDatatype.get(), prefixManager);
        }
        ImmutableTerm termType = function.getTerm(1);
        if (TargetQueryRenderer.isBlankNode(termType)) {
            if (lexicalTerm instanceof ImmutableFunctionalTerm) {
                ImmutableFunctionalTerm nestedFunction = (ImmutableFunctionalTerm)lexicalTerm;
                FunctionSymbol nestedFs = nestedFunction.getFunctionSymbol();
                if (nestedFs instanceof BnodeStringTemplateFunctionSymbol) {
                    return TargetQueryRenderer.displayBnodeTemplate(nestedFunction, prefixManager);
                }
                return TargetQueryRenderer.displayNonFunctionalBNode((ImmutableTerm)nestedFunction, prefixManager);
            }
            return TargetQueryRenderer.displayNonFunctionalBNode(lexicalTerm, prefixManager);
        }
        if (TargetQueryRenderer.isIRI(termType)) {
            ImmutableFunctionalTerm nestedFunction;
            if (lexicalTerm instanceof ImmutableFunctionalTerm && (nestedFunction = (ImmutableFunctionalTerm)lexicalTerm).getFunctionSymbol() instanceof IRIStringTemplateFunctionSymbol) {
                return TargetQueryRenderer.displayURITemplate(nestedFunction, prefixManager);
            }
            return TargetQueryRenderer.displayIRI(TargetQueryRenderer.displayTerm(lexicalTerm, prefixManager), prefixManager);
        }
        throw new IllegalArgumentException("unsupported function " + function);
    }

    private static boolean isBlankNode(ImmutableTerm termType) {
        return termType instanceof RDFTermTypeConstant && ((RDFTermTypeConstant)termType).getRDFTermType() instanceof BlankNodeTermType;
    }

    private static boolean isIRI(ImmutableTerm termType) {
        return termType instanceof RDFTermTypeConstant && ((RDFTermTypeConstant)termType).getRDFTermType() instanceof IRITermType;
    }

    private static String displayNonFunctionalBNode(ImmutableTerm term, PrefixManager prefixManager) {
        return "_:" + TargetQueryRenderer.displayTerm(term, prefixManager);
    }

    private static boolean isTemporaryConversionFunction(ImmutableTerm term) {
        if (term instanceof ImmutableFunctionalTerm) {
            FunctionSymbol fs = ((ImmutableFunctionalTerm)term).getFunctionSymbol();
            return fs instanceof DBTypeConversionFunctionSymbol && ((DBTypeConversionFunctionSymbol)fs).isTemporary();
        }
        return false;
    }

    private static Variable extractUniqueVariableArgument(ImmutableFunctionalTerm fun) {
        ImmutableTerm arg;
        if (fun.getArity() == 1 && (arg = fun.getTerm(0)) instanceof Variable) {
            return (Variable)arg;
        }
        throw new UnexpectedTermException((ImmutableTerm)fun);
    }

    private static ImmutableTerm asArg(ImmutableTerm term) {
        if (TargetQueryRenderer.isTemporaryConversionFunction(term)) {
            return TargetQueryRenderer.extractUniqueVariableArgument((ImmutableFunctionalTerm)term);
        }
        return term;
    }

    private static String displayOrdinaryFunction(ImmutableFunctionalTerm function, String fname, PrefixManager prefixManager) {
        StringBuilder sb = new StringBuilder();
        sb.append(fname);
        sb.append("(");
        boolean separator = false;
        for (ImmutableTerm innerTerm : function.getTerms()) {
            if (separator) {
                sb.append(", ");
            }
            sb.append(TargetQueryRenderer.displayTerm(innerTerm, prefixManager));
            separator = true;
        }
        sb.append(")");
        return sb.toString();
    }

    private static String displayDatatypeFunction(ImmutableTerm lexicalTerm, RDFDatatype datatype, PrefixManager prefixManager) {
        String lexicalString = lexicalTerm instanceof DBConstant ? TargetQueryRenderer.displayConstantLexicalValue((DBConstant)lexicalTerm) : TargetQueryRenderer.displayTerm(lexicalTerm, prefixManager);
        return datatype.getLanguageTag().map(tag -> lexicalString + "@" + tag.getFullString()).orElseGet(() -> {
            String typePostfix = datatype.getIRI().equals((Object)RDFS.LITERAL) ? "" : "^^" + TargetQueryRenderer.getAbbreviatedName(datatype.getIRI().getIRIString(), prefixManager, false);
            return lexicalString + typePostfix;
        });
    }

    private static String displayURITemplate(ImmutableFunctionalTerm function, PrefixManager prefixManager) {
        String templateWithVars = TargetQueryRenderer.instantiateTemplate(function, prefixManager);
        if (templateWithVars.equals(RDF.TYPE.getIRIString())) {
            return "a";
        }
        return TargetQueryRenderer.displayIRI(templateWithVars, prefixManager);
    }

    private static String displayIRI(String s, PrefixManager prefixManager) {
        String shortenedUri = TargetQueryRenderer.getAbbreviatedName(s, prefixManager, false);
        if (!shortenedUri.equals(s)) {
            return shortenedUri;
        }
        return "<" + s + ">";
    }

    private static String displayBnodeTemplate(ImmutableFunctionalTerm function, PrefixManager prefixManager) {
        if (function.getArity() == 1) {
            return "_:" + TargetQueryRenderer.displayTerm((ImmutableTerm)function.getTerms().get(0), prefixManager);
        }
        if (function.getFunctionSymbol() instanceof BnodeStringTemplateFunctionSymbol) {
            String templateWithVars = TargetQueryRenderer.instantiateTemplate(function, prefixManager);
            return templateWithVars;
        }
        throw new UnexpectedTermException((ImmutableTerm)function);
    }

    private static String instantiateTemplate(ImmutableFunctionalTerm function, PrefixManager prefixManager) {
        String template = ((ObjectStringTemplateFunctionSymbol)function.getFunctionSymbol()).getTemplate();
        String templateFormat = template.replace("{}", "%s");
        Object[] varNames = function.getTerms().stream().map(TargetQueryRenderer::asArg).filter(Variable.class::isInstance).map(var -> TargetQueryRenderer.displayTerm(var, prefixManager)).toArray();
        return String.format(templateFormat, varNames);
    }

    public static String displayConcat(ImmutableFunctionalTerm function) {
        return "\"" + function.getTerms().stream().map(TargetQueryRenderer::concatArg2String).collect(Collectors.joining()) + "\"";
    }

    private TargetQueryRenderer() {
    }

    private static class UnexpectedTermException
    extends OntopInternalBugException {
        private UnexpectedTermException(ImmutableTerm term) {
            super("Unexpected type " + term.getClass() + " for term: " + term);
        }

        private UnexpectedTermException(ImmutableTerm term, String message) {
            super("Unexpected term " + term + ":\n" + message);
        }
    }
}

