/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.pp.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.exception.MetaMappingExpansionException;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopSQLCredentialSettings;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.NativeNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.IQTree2NativeNodeGenerator;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.pp.impl.MetaMappingExpander;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingEqualityTransformer;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.LocalJDBCConnectionUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;

public class MetaMappingExpanderImpl
implements MetaMappingExpander {
    private final SubstitutionFactory substitutionFactory;
    private final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;
    private final MappingEqualityTransformer mappingEqualityTransformer;
    private final IQTree2NativeNodeGenerator nativeNodeGenerator;
    private final OntopSQLCredentialSettings settings;

    @Inject
    private MetaMappingExpanderImpl(SubstitutionFactory substitutionFactory, IntermediateQueryFactory iqFactory, TermFactory termFactory, MappingEqualityTransformer mappingEqualityTransformer, IQTree2NativeNodeGenerator nativeNodeGenerator, OntopSQLCredentialSettings settings) {
        this.substitutionFactory = substitutionFactory;
        this.iqFactory = iqFactory;
        this.termFactory = termFactory;
        this.mappingEqualityTransformer = mappingEqualityTransformer;
        this.nativeNodeGenerator = nativeNodeGenerator;
        this.settings = settings;
    }

    @Override
    public ImmutableList<MappingAssertion> transform(ImmutableList<MappingAssertion> mapping, DBParameters dbParameters) throws MetaMappingExpansionException {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        ImmutableList.Builder positionsBuilder = ImmutableList.builder();
        for (MappingAssertion assertion : mapping) {
            Optional<ExpansionPosition> position = this.getExpansionPosition(assertion);
            if (!position.isPresent()) {
                resultBuilder.add((Object)assertion);
                continue;
            }
            positionsBuilder.add((Object)position.get());
        }
        ImmutableList positions = positionsBuilder.build();
        if (positions.isEmpty()) {
            return mapping;
        }
        try (Connection connection = LocalJDBCConnectionUtils.createConnection((OntopSQLCredentialSettings)this.settings);){
            for (ExpansionPosition position : positions) {
                NativeNode nativeNode = position.getDatabaseQuery(dbParameters);
                Statement st = connection.createStatement();
                Throwable throwable = null;
                try {
                    ResultSet rs = st.executeQuery(nativeNode.getNativeQueryString());
                    Throwable throwable2 = null;
                    try {
                        while (rs.next()) {
                            ImmutableMap.Builder builder = ImmutableMap.builder();
                            for (Variable variable : nativeNode.getVariables()) {
                                String column = ((QuotedID)nativeNode.getColumnNames().get((Object)variable)).getName();
                                builder.put((Object)variable, (Object)this.termFactory.getDBConstant(rs.getString(column), (DBTermType)nativeNode.getTypeMap().get((Object)variable)));
                            }
                            resultBuilder.add((Object)position.createExpansion((ImmutableMap<Variable, ImmutableTerm>)builder.build()));
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (st == null) continue;
                    if (throwable != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    st.close();
                }
            }
        }
        catch (SQLException e) {
            throw new MetaMappingExpansionException((Exception)e);
        }
        return resultBuilder.build();
    }

    private Optional<ExpansionPosition> getExpansionPosition(MappingAssertion assertion) {
        RDFAtomPredicate predicate = assertion.getRDFAtomPredicate();
        RDFAtomPredicate.ComponentGetter componentGetter = predicate.getPropertyIRI(assertion.getTerms()).filter(p -> p.equals((Object)RDF.TYPE)).isPresent() ? arg_0 -> ((RDFAtomPredicate)predicate).getObject(arg_0) : arg_0 -> ((RDFAtomPredicate)predicate).getProperty(arg_0);
        return componentGetter.get(assertion.getTerms()).isGround() ? Optional.empty() : Optional.of(new ExpansionPosition(assertion, (Variable)componentGetter.get(assertion.getProjectionAtom().getArguments())));
    }

    private final class ExpansionPosition {
        private final MappingAssertion assertion;
        private final Variable topVariable;

        ExpansionPosition(MappingAssertion assertion, Variable topVariable) {
            this.assertion = assertion;
            this.topVariable = topVariable;
        }

        ImmutableTerm getTemplate() {
            return this.assertion.getTopSubstitution().get(this.topVariable);
        }

        NativeNode getDatabaseQuery(DBParameters dbParameters) {
            IQTree topChildNotNull = MetaMappingExpanderImpl.this.termFactory.getConjunction(this.assertion.getTopChild().getVariables().stream().map(arg_0 -> ((TermFactory)MetaMappingExpanderImpl.this.termFactory).getDBIsNotNull(arg_0))).map(arg_0 -> ((IntermediateQueryFactory)MetaMappingExpanderImpl.this.iqFactory).createFilterNode(arg_0)).map(n -> MetaMappingExpanderImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)n, this.assertion.getTopChild())).orElse(this.assertion.getTopChild());
            UnaryIQTree constructionTree = MetaMappingExpanderImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)MetaMappingExpanderImpl.this.iqFactory.createConstructionNode((ImmutableSet)this.getTemplate().getVariableStream().collect(ImmutableCollectors.toSet()), MetaMappingExpanderImpl.this.substitutionFactory.getSubstitution()), topChildNotNull);
            UnaryIQTree tree = MetaMappingExpanderImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)MetaMappingExpanderImpl.this.iqFactory.createDistinctNode(), (IQTree)constructionTree);
            IQTree transformedTree = MetaMappingExpanderImpl.this.mappingEqualityTransformer.transform((IQTree)tree);
            return MetaMappingExpanderImpl.this.nativeNodeGenerator.generate(transformedTree, dbParameters, true);
        }

        MappingAssertion createExpansion(ImmutableMap<Variable, ImmutableTerm> values) {
            ImmutableTerm instantiatedTemplate = MetaMappingExpanderImpl.this.substitutionFactory.getSubstitution(values).apply(this.getTemplate());
            ImmutableSubstitution instantiatedSub = this.assertion.getTopSubstitution().composeWith(MetaMappingExpanderImpl.this.substitutionFactory.getSubstitution(this.topVariable, instantiatedTemplate));
            IQTree filterTree = (IQTree)MetaMappingExpanderImpl.this.termFactory.getConjunction(values.entrySet().stream().map(e -> MetaMappingExpanderImpl.this.termFactory.getNotYetTypedEquality((ImmutableTerm)e.getKey(), (ImmutableTerm)e.getValue()))).map(arg_0 -> ((IntermediateQueryFactory)MetaMappingExpanderImpl.this.iqFactory).createFilterNode(arg_0)).map(n -> MetaMappingExpanderImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)n, this.assertion.getTopChild())).orElseThrow(() -> new MinorOntopInternalBugException("The generated filter condition is empty for " + this.assertion + " with " + values));
            UnaryIQTree tree = MetaMappingExpanderImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)MetaMappingExpanderImpl.this.iqFactory.createConstructionNode(instantiatedSub.getDomain(), instantiatedSub), filterTree);
            return this.assertion.copyOf((IQTree)tree, MetaMappingExpanderImpl.this.iqFactory);
        }
    }
}

