/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.sqlparser;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.com.google.common.collect.Sets;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.spec.mapping.sqlparser.RAExpressionAttributeOccurrences;
import it.unibz.inf.ontop.spec.mapping.sqlparser.RAExpressionAttributeOccurrencesOperations;
import it.unibz.inf.ontop.spec.mapping.sqlparser.RAExpressionAttributes;
import it.unibz.inf.ontop.spec.mapping.sqlparser.RAOperations;
import it.unibz.inf.ontop.spec.mapping.sqlparser.exception.IllegalJoinException;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RAExpressionAttributesOperations
implements RAOperations<RAExpressionAttributes> {
    private final RAExpressionAttributeOccurrencesOperations aoops = new RAExpressionAttributeOccurrencesOperations();

    @Override
    public RAExpressionAttributes create() {
        return new RAExpressionAttributes((ImmutableMap<QualifiedAttributeID, ImmutableTerm>)ImmutableMap.of(), this.aoops.create());
    }

    @Override
    public RAExpressionAttributes create(DatabaseRelationDefinition relation, ImmutableList<Variable> variables) {
        ImmutableMap<QuotedID, ImmutableTerm> map = this.getAttributesMap((RelationDefinition)relation, variables);
        return new RAExpressionAttributes(this.attachAliases(map, (ImmutableSet<RelationID>)relation.getAllIDs()), (RAExpressionAttributeOccurrences)this.aoops.create(relation, (ImmutableList)variables));
    }

    public RAExpressionAttributes create(ImmutableMap<QuotedID, ImmutableTerm> unqualifiedAttributes) {
        return new RAExpressionAttributes(this.attachAliases(unqualifiedAttributes, (ImmutableSet<RelationID>)ImmutableSet.of()), this.aoops.create((ImmutableSet<QuotedID>)unqualifiedAttributes.keySet(), (ImmutableSet<RelationID>)ImmutableSet.of()));
    }

    @Override
    public RAExpressionAttributes withAlias(RAExpressionAttributes rae, RelationID aliasId) {
        ImmutableMap<QuotedID, ImmutableTerm> unqualifiedAttributes = rae.getUnqualifiedAttributes();
        return new RAExpressionAttributes(this.attachAliases(unqualifiedAttributes, (ImmutableSet<RelationID>)ImmutableSet.of((Object)aliasId)), this.aoops.withAlias(rae.getOccurrences(), aliasId));
    }

    @Override
    public RAExpressionAttributes crossJoin(RAExpressionAttributes left, RAExpressionAttributes right) throws IllegalJoinException {
        this.checkRelationAliasesConsistency(left, right);
        ImmutableMap attributes = (ImmutableMap)Stream.concat(left.selectAttributes(id -> id.getRelation() != null || right.getOccurrences().isAbsent(id.getAttribute())), right.selectAttributes(id -> id.getRelation() != null || left.getOccurrences().isAbsent(id.getAttribute()))).collect(ImmutableCollectors.toMap());
        return new RAExpressionAttributes((ImmutableMap<QualifiedAttributeID, ImmutableTerm>)attributes, this.aoops.crossJoin(left.getOccurrences(), right.getOccurrences()));
    }

    @Override
    public RAExpressionAttributes joinUsing(RAExpressionAttributes left, RAExpressionAttributes right, ImmutableSet<QuotedID> using) throws IllegalJoinException {
        this.checkRelationAliasesConsistency(left, right);
        RAExpressionAttributeOccurrences occurrences = this.aoops.joinUsing(left.getOccurrences(), right.getOccurrences(), using);
        if (occurrences == null) {
            ImmutableList notFound = (ImmutableList)using.stream().filter(id -> left.getOccurrences().isAbsent((QuotedID)id) || right.getOccurrences().isAbsent((QuotedID)id)).collect(ImmutableCollectors.toList());
            ImmutableList ambiguous = (ImmutableList)using.stream().filter(id -> left.getOccurrences().isAmbiguous((QuotedID)id) || right.getOccurrences().isAmbiguous((QuotedID)id)).collect(ImmutableCollectors.toList());
            throw new IllegalJoinException(left, right, (!notFound.isEmpty() ? "Attribute(s) " + notFound + " cannot be found" : "") + (!notFound.isEmpty() && !ambiguous.isEmpty() ? ", " : "") + (!ambiguous.isEmpty() ? "Attribute(s) " + ambiguous + " are ambiguous" : ""));
        }
        ImmutableMap attributes = (ImmutableMap)Stream.concat(left.selectAttributes(id -> id.getRelation() != null && !using.contains((Object)id.getAttribute()) || id.getRelation() == null && right.getOccurrences().isAbsent(id.getAttribute()) || id.getRelation() == null && using.contains((Object)id.getAttribute())), right.selectAttributes(id -> id.getRelation() != null && !using.contains((Object)id.getAttribute()) || id.getRelation() == null && left.getOccurrences().isAbsent(id.getAttribute()))).collect(ImmutableCollectors.toMap());
        return new RAExpressionAttributes((ImmutableMap<QualifiedAttributeID, ImmutableTerm>)attributes, occurrences);
    }

    @Override
    public RAExpressionAttributes joinOn(RAExpressionAttributes left, RAExpressionAttributes right, Function<RAExpressionAttributes, ImmutableList<ImmutableExpression>> getAtomOnExpression) throws IllegalJoinException {
        return this.crossJoin(left, right);
    }

    @Override
    public ImmutableSet<QuotedID> getSharedAttributeNames(RAExpressionAttributes left, RAExpressionAttributes right) {
        return this.aoops.getSharedAttributeNames(left.getOccurrences(), right.getOccurrences());
    }

    @Override
    public RAExpressionAttributes filter(RAExpressionAttributes rae, ImmutableList<ImmutableExpression> filter) {
        return rae;
    }

    private void checkRelationAliasesConsistency(RAExpressionAttributes re1, RAExpressionAttributes re2) throws IllegalJoinException {
        Sets.SetView intersection = Sets.intersection(this.getRelationAliases(re1), this.getRelationAliases(re2));
        if (!intersection.isEmpty()) {
            throw new IllegalJoinException(re1, re2, intersection.stream().map(RelationID::getSQLRendering).collect(Collectors.joining(", ", "Relation alias ", " occurs in both arguments of the JOIN")));
        }
    }

    private ImmutableSet<RelationID> getRelationAliases(RAExpressionAttributes rae) {
        return (ImmutableSet)rae.selectAttributes(id -> id.getRelation() != null).map(Map.Entry::getKey).map(QualifiedAttributeID::getRelation).collect(ImmutableCollectors.toSet());
    }

    public ImmutableMap<QuotedID, ImmutableTerm> getAttributesMap(RelationDefinition relation, ImmutableList<Variable> variables) {
        return (ImmutableMap)relation.getAttributes().stream().collect(ImmutableCollectors.toMap(Attribute::getID, attribute -> (Variable)variables.get(attribute.getIndex() - 1)));
    }

    private ImmutableMap<QualifiedAttributeID, ImmutableTerm> attachAliases(ImmutableMap<QuotedID, ImmutableTerm> unqualifiedAttributes, ImmutableSet<RelationID> allRelationIds) {
        return (ImmutableMap)unqualifiedAttributes.entrySet().stream().flatMap(e -> this.createQualifiedID(allRelationIds, (QuotedID)e.getKey()).map(i -> Maps.immutableEntry((Object)i, e.getValue()))).collect(ImmutableCollectors.toMap());
    }

    private Stream<QualifiedAttributeID> createQualifiedID(ImmutableSet<RelationID> aliases, QuotedID attributeId) {
        return Stream.concat(Stream.of(new QualifiedAttributeID(null, attributeId)), aliases.stream().flatMap(l -> l.getWithSchemalessID().stream()).distinct().map(a -> new QualifiedAttributeID(a, attributeId)));
    }
}

