/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.sqlparser;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.spec.mapping.sqlparser.ExpressionParser;
import it.unibz.inf.ontop.spec.mapping.sqlparser.RAExpressionAttributes;
import it.unibz.inf.ontop.spec.mapping.sqlparser.RAOperations;
import it.unibz.inf.ontop.spec.mapping.sqlparser.exception.IllegalJoinException;
import it.unibz.inf.ontop.spec.mapping.sqlparser.exception.InvalidSelectQueryRuntimeException;
import it.unibz.inf.ontop.spec.mapping.sqlparser.exception.UnsupportedSelectQueryRuntimeException;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.List;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.ParenthesisFromItem;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.ValuesList;

public abstract class FromItemParser<T> {
    protected final ExpressionParser expressionParser;
    protected final QuotedIDFactory idfac;
    protected final TermFactory termFactory;
    private final MetadataLookup metadata;
    protected final RAOperations<T> operations;
    private int relationIndex = 0;

    protected abstract T create(DatabaseRelationDefinition var1);

    protected abstract T translateSelectBody(SelectBody var1);

    protected FromItemParser(ExpressionParser expressionParser, QuotedIDFactory idfac, MetadataLookup metadata, TermFactory termFactory, RAOperations<T> operations) {
        this.expressionParser = expressionParser;
        this.idfac = idfac;
        this.metadata = metadata;
        this.termFactory = termFactory;
        this.operations = operations;
    }

    protected T translateJoins(FromItem left, List<Join> joins) throws IllegalJoinException {
        if (left == null) {
            return this.operations.create();
        }
        T current = this.translateFromItem(left);
        if (joins != null) {
            for (Join join : joins) {
                current = this.join(current, join);
            }
        }
        return current;
    }

    private T translateFromItem(FromItem fromItem) {
        return new FromItemProcessor().translate(fromItem);
    }

    protected T join(T left, Join join) throws IllegalJoinException {
        T right = this.translateFromItem(join.getRightItem());
        if (join.isApply()) {
            if (join.isLeft() || join.isRight() || join.isFull() || join.isSemi() || join.isInner() || join.isNatural() || join.getOnExpression() != null || join.getUsingColumns() != null) {
                throw new InvalidSelectQueryRuntimeException("Invalid APPLY join", join);
            }
            if (!join.isCross() && !join.isOuter()) {
                throw new InvalidSelectQueryRuntimeException("APPLY must be either CROSS or OUTER", join);
            }
            return this.operations.crossJoin(left, right);
        }
        if (join.isStraight() && (join.isLeft() || join.isRight() || join.isFull() || join.isSemi() || join.isOuter() || join.isInner() || join.isNatural() || join.isCross())) {
            throw new InvalidSelectQueryRuntimeException("Invalid STRAIGHT_JOIN", join);
        }
        if (join.isSimple()) {
            if (join.isLeft() || join.isRight() || join.isFull() || join.isSemi() || join.isOuter() || join.isInner() || join.isNatural() || join.isCross()) {
                throw new InvalidSelectQueryRuntimeException("Invalid simple join", join);
            }
            if (join.getOnExpression() != null || join.getUsingColumns() != null) {
                throw new InvalidSelectQueryRuntimeException("Invalid simple join", join);
            }
            return this.operations.crossJoin(left, right);
        }
        if (join.isCross()) {
            if (join.getOnExpression() != null || join.getUsingColumns() != null) {
                throw new InvalidSelectQueryRuntimeException("CROSS JOIN cannot have USING/ON conditions", join);
            }
            return this.operations.crossJoin(left, right);
        }
        if (join.isNatural()) {
            if (join.getOnExpression() != null || join.getUsingColumns() != null) {
                throw new InvalidSelectQueryRuntimeException("NATURAL JOIN cannot have USING/ON conditions", join);
            }
            return this.operations.naturalJoin(left, right);
        }
        if (join.getOnExpression() != null) {
            if (join.getUsingColumns() != null) {
                throw new InvalidSelectQueryRuntimeException("JOIN cannot have both USING and ON", join);
            }
            if (join.isSemi()) {
                return left;
            }
            return this.operations.joinOn(left, right, attributes -> this.expressionParser.parseBooleanExpression(join.getOnExpression(), (RAExpressionAttributes)attributes));
        }
        if (join.getUsingColumns() != null) {
            if (join.isSemi()) {
                throw new InvalidSelectQueryRuntimeException("Invalid SEMI JOIN", join);
            }
            if (join.getUsingColumns().stream().anyMatch(p -> p.getTable() != null)) {
                throw new InvalidSelectQueryRuntimeException("JOIN USING columns cannot be qualified", join);
            }
            return this.operations.joinUsing(left, right, (ImmutableSet<QuotedID>)((ImmutableSet)join.getUsingColumns().stream().map(p -> this.idfac.createAttributeID(p.getColumnName())).collect(ImmutableCollectors.toSet())));
        }
        throw new InvalidSelectQueryRuntimeException("[INNER|OUTER] JOIN requires either ON or USING", join);
    }

    public ImmutableList<Variable> createAttributeVariables(RelationDefinition relation) {
        ++this.relationIndex;
        return (ImmutableList)relation.getAttributes().stream().map(attribute -> this.termFactory.getVariable(attribute.getID().getName() + this.relationIndex)).collect(ImmutableCollectors.toList());
    }

    protected void validateFromItem(Table table) {
    }

    private class FromItemProcessor
    implements FromItemVisitor {
        private T result;

        private FromItemProcessor() {
        }

        T translate(FromItem fromItem) {
            fromItem.accept((FromItemVisitor)this);
            return this.result;
        }

        public void visit(Table table) {
            if (table.getPivot() != null || table.getUnPivot() != null) {
                throw new UnsupportedSelectQueryRuntimeException("PIVOT/UNPIVOT are not supported", table);
            }
            FromItemParser.this.validateFromItem(table);
            RelationID id = FromItemParser.this.idfac.createRelationID(table.getSchemaName(), table.getName());
            try {
                DatabaseRelationDefinition relation = FromItemParser.this.metadata.getRelation(id);
                Object rae = FromItemParser.this.create(relation);
                this.result = table.getAlias() == null ? rae : this.alias(rae, table.getAlias());
            }
            catch (MetadataExtractionException e) {
                throw new InvalidSelectQueryRuntimeException(e.getMessage(), id);
            }
        }

        public void visit(SubSelect subSelect) {
            if (subSelect.getAlias() == null || subSelect.getAlias().getName() == null) {
                throw new InvalidSelectQueryRuntimeException("SUB-SELECT must have an alias", subSelect);
            }
            if (subSelect.getWithItemsList() != null) {
                throw new UnsupportedSelectQueryRuntimeException("WITH is not supported", subSelect);
            }
            if (subSelect.getPivot() != null || subSelect.getUnPivot() != null) {
                throw new UnsupportedSelectQueryRuntimeException("PIVOT/UNPIVOT are not supported", subSelect);
            }
            Object rae = FromItemParser.this.translateSelectBody(subSelect.getSelectBody());
            this.result = this.alias(rae, subSelect.getAlias());
        }

        public void visit(SubJoin subjoin) {
            if (subjoin.getAlias() == null || subjoin.getAlias().getName() == null) {
                throw new InvalidSelectQueryRuntimeException("SUB-JOIN must have an alias", subjoin);
            }
            if (subjoin.getPivot() != null || subjoin.getUnPivot() != null) {
                throw new UnsupportedSelectQueryRuntimeException("PIVOT/UNPIVOT are not supported", subjoin);
            }
            try {
                Object rae = FromItemParser.this.translateJoins(subjoin.getLeft(), subjoin.getJoinList());
                this.result = this.alias(rae, subjoin.getAlias());
            }
            catch (IllegalJoinException e) {
                throw new InvalidSelectQueryRuntimeException(e.toString(), subjoin);
            }
        }

        public void visit(LateralSubSelect lateralSubSelect) {
            throw new UnsupportedSelectQueryRuntimeException("LateralSubSelects are not supported", lateralSubSelect);
        }

        public void visit(ValuesList valuesList) {
            throw new UnsupportedSelectQueryRuntimeException("ValuesLists are not supported", valuesList);
        }

        public void visit(TableFunction tableFunction) {
            throw new UnsupportedSelectQueryRuntimeException("TableFunction are not supported", tableFunction);
        }

        public void visit(ParenthesisFromItem parenthesisFromItem) {
            throw new UnsupportedSelectQueryRuntimeException("ParenthesisFromItem are not supported", parenthesisFromItem);
        }

        private T alias(T rae, Alias alias) {
            if (alias.getAliasColumns() != null) {
                throw new UnsupportedSelectQueryRuntimeException("Alias columns are not supported", alias);
            }
            RelationID aliasId = FromItemParser.this.idfac.createRelationID(null, alias.getName());
            return FromItemParser.this.operations.withAlias(rae, aliasId);
        }
    }
}

