/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.sqlparser;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.InequalityLabel;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBMathBinaryOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBNotFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.spec.mapping.sqlparser.RAExpressionAttributes;
import it.unibz.inf.ontop.spec.mapping.sqlparser.exception.InvalidSelectQueryRuntimeException;
import it.unibz.inf.ontop.spec.mapping.sqlparser.exception.UnsupportedSelectQueryRuntimeException;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.sf.jsqlparser.expression.AllComparisonExpression;
import net.sf.jsqlparser.expression.AnalyticExpression;
import net.sf.jsqlparser.expression.AnyComparisonExpression;
import net.sf.jsqlparser.expression.ArrayExpression;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.CollateExpression;
import net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExtractExpression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.IntervalExpression;
import net.sf.jsqlparser.expression.JdbcNamedParameter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.JsonExpression;
import net.sf.jsqlparser.expression.KeepExpression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.MySQLGroupConcat;
import net.sf.jsqlparser.expression.NextValExpression;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.NumericBind;
import net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import net.sf.jsqlparser.expression.OracleHint;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.UserVariable;
import net.sf.jsqlparser.expression.ValueListExpression;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseLeftShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseRightShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.IntegerDivision;
import net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.FullTextSearch;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsBooleanExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.Matches;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.expression.operators.relational.OldOracleJoinBinaryExpression;
import net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import net.sf.jsqlparser.expression.operators.relational.RegExpMySQLOperator;
import net.sf.jsqlparser.expression.operators.relational.SimilarToExpression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.create.table.ColDataType;
import net.sf.jsqlparser.statement.select.SubSelect;

public class ExpressionParser {
    private final QuotedIDFactory idfac;
    private final TermFactory termFactory;
    private final DBTypeFactory dbTypeFactory;
    private final DBFunctionSymbolFactory dbFunctionSymbolFactory;
    private final ImmutableMap<String, BiFunction<Function, TermVisitor, ImmutableFunctionalTerm>> FUNCTIONS = ImmutableMap.builder().put((Object)"RAND", this::getRAND).put((Object)"CONVERT", this::getCONVERT).put((Object)"COUNT", this::reject).put((Object)"MIN", this::reject).put((Object)"MAX", this::reject).put((Object)"SUM", this::reject).put((Object)"AVG", this::reject).put((Object)"UNNEST", this::reject).put((Object)"JSON_EACH", this::reject).put((Object)"JSON_EACH_TEXT", this::reject).put((Object)"JSON_OBJECT_KEYS", this::reject).put((Object)"JSON_POPULATE_RECORDSET", this::reject).put((Object)"JSON_ARRAY_ELEMENTS", this::reject).build();

    public ExpressionParser(QuotedIDFactory idfac, CoreSingletons coreSingletons) {
        this.idfac = idfac;
        this.termFactory = coreSingletons.getTermFactory();
        this.dbTypeFactory = coreSingletons.getTypeFactory().getDBTypeFactory();
        this.dbFunctionSymbolFactory = coreSingletons.getDBFunctionsymbolFactory();
    }

    public ImmutableTerm parseTerm(Expression expression, RAExpressionAttributes attributes) {
        TermVisitor visitor = new TermVisitor(attributes);
        return visitor.getTerm(expression);
    }

    public ImmutableList<ImmutableExpression> parseBooleanExpression(Expression expression, RAExpressionAttributes attributes) {
        TermVisitor visitor = new TermVisitor(attributes);
        return (ImmutableList)visitor.getExpression(expression).flattenAND().collect(ImmutableCollectors.toList());
    }

    private ImmutableFunctionalTerm getGenericDBFunction(Function expression, TermVisitor termVisitor) {
        if (expression.isDistinct() || expression.isAllColumns()) {
            throw new UnsupportedSelectQueryRuntimeException("Unsupported SQL function", expression);
        }
        if (expression.isEscaped()) {
            throw new UnsupportedSelectQueryRuntimeException("Unsupported SQL function", expression);
        }
        if (expression.getAttribute() != null || expression.getAttributeName() != null) {
            throw new UnsupportedSelectQueryRuntimeException("Unsupported SQL function", expression);
        }
        if (expression.getKeep() != null) {
            throw new UnsupportedSelectQueryRuntimeException("Unsupported SQL function", expression);
        }
        ImmutableList terms = expression.getParameters() != null ? (ImmutableList)expression.getParameters().getExpressions().stream().map(termVisitor::getTerm).collect(ImmutableCollectors.toList()) : (expression.getNamedParameters() != null ? (ImmutableList)expression.getNamedParameters().getExpressions().stream().map(termVisitor::getTerm).collect(ImmutableCollectors.toList()) : ImmutableList.of());
        DBFunctionSymbol functionSymbol = this.dbFunctionSymbolFactory.getRegularDBFunctionSymbol(expression.getName(), terms.size());
        return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)functionSymbol, terms);
    }

    private ImmutableFunctionalTerm getCONVERT(Function expression, TermVisitor termVisitor) {
        if (expression.getParameters() == null) {
            throw new InvalidSelectQueryRuntimeException("Invalid CONVERT", expression);
        }
        List parameters = expression.getParameters().getExpressions();
        if (parameters.size() != 2) {
            throw new UnsupportedSelectQueryRuntimeException("Unsupported SQL function", expression);
        }
        ImmutableTerm term = termVisitor.getTerm((Expression)parameters.get(1));
        String datatype = ((Expression)parameters.get(0)).toString();
        return this.termFactory.getDBCastFunctionalTerm(this.dbTypeFactory.getDBTermType(datatype), term);
    }

    private ImmutableFunctionalTerm getRAND(Function expression, TermVisitor termVisitor) {
        if (expression.getParameters() == null) {
            return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBRand(UUID.randomUUID()), new ImmutableTerm[0]);
        }
        throw new UnsupportedSelectQueryRuntimeException("Unsupported SQL function", expression);
    }

    private ImmutableFunctionalTerm reject(Function expression, TermVisitor termVisitor) {
        throw new UnsupportedSelectQueryRuntimeException("Unsupported SQL function", expression);
    }

    private class TermVisitor
    implements ExpressionVisitor {
        private final RAExpressionAttributes attributes;
        private ImmutableTerm result;

        TermVisitor(RAExpressionAttributes attributes) {
            this.attributes = attributes;
        }

        ImmutableTerm getTerm(Expression expression) {
            expression.accept((ExpressionVisitor)this);
            return this.result;
        }

        public void visit(Function expression) {
            BiFunction function = (BiFunction)ExpressionParser.this.FUNCTIONS.getOrDefault((Object)expression.getName().toUpperCase(), (x$0, x$1) -> ExpressionParser.this.getGenericDBFunction(x$0, x$1));
            this.result = (ImmutableTerm)function.apply(expression, this);
        }

        public void visit(NullValue expression) {
            this.result = ExpressionParser.this.termFactory.getNullConstant();
        }

        public void visit(DoubleValue expression) {
            this.result = ExpressionParser.this.termFactory.getDBConstant(expression.toString(), ExpressionParser.this.dbTypeFactory.getDBDoubleType());
        }

        public void visit(LongValue expression) {
            this.result = ExpressionParser.this.termFactory.getDBConstant(expression.getStringValue(), ExpressionParser.this.dbTypeFactory.getDBLargeIntegerType());
        }

        public void visit(HexValue expression) {
            long value;
            String str = expression.getValue();
            if (str.startsWith("0x")) {
                value = Long.parseLong(str.substring(2), 16);
            } else if (str.toUpperCase().startsWith("X'")) {
                value = Long.parseLong(str.substring(2, str.length() - 1), 16);
            } else {
                throw new UnsupportedOperationException("Invalid HEX" + str);
            }
            this.result = ExpressionParser.this.termFactory.getDBConstant(value + "", ExpressionParser.this.dbTypeFactory.getDBLargeIntegerType());
        }

        public void visit(StringValue expression) {
            this.result = ExpressionParser.this.termFactory.getDBConstant(expression.getValue(), ExpressionParser.this.dbTypeFactory.getDBStringType());
        }

        public void visit(DateValue expression) {
            this.result = ExpressionParser.this.termFactory.getDBConstant(expression.getValue().toString(), ExpressionParser.this.dbTypeFactory.getDBDateType());
        }

        public void visit(TimeValue expression) {
            this.result = ExpressionParser.this.termFactory.getDBConstant(expression.getValue().toString(), ExpressionParser.this.dbTypeFactory.getDBTimeType());
        }

        public void visit(TimestampValue expression) {
            this.result = ExpressionParser.this.termFactory.getDBConstant(expression.getValue().toString(), ExpressionParser.this.dbTypeFactory.getDBDateTimestampType());
        }

        public void visit(IntervalExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Temporal INTERVALs are not supported", expression);
        }

        public void visit(DateTimeLiteralExpression expression) {
            String val = expression.getValue();
            switch (expression.getType()) {
                case DATE: {
                    this.result = ExpressionParser.this.termFactory.getDBConstant(val.substring(1, val.length() - 1), ExpressionParser.this.dbTypeFactory.getDBDateType());
                    break;
                }
                case TIME: {
                    this.result = ExpressionParser.this.termFactory.getDBConstant(val.substring(1, val.length() - 1), ExpressionParser.this.dbTypeFactory.getDBTimeType());
                    break;
                }
                case TIMESTAMP: {
                    this.result = ExpressionParser.this.termFactory.getDBConstant(val.substring(1, val.length() - 1), ExpressionParser.this.dbTypeFactory.getDBDateTimestampType());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(expression + " is not valid");
                }
            }
        }

        public void visit(Addition expression) {
            this.process((BinaryExpression)expression, (DBFunctionSymbol)this.getArithmeticOperation((BinaryExpression)expression));
        }

        public void visit(Subtraction expression) {
            this.process((BinaryExpression)expression, (DBFunctionSymbol)this.getArithmeticOperation((BinaryExpression)expression));
        }

        public void visit(Multiplication expression) {
            this.process((BinaryExpression)expression, (DBFunctionSymbol)this.getArithmeticOperation((BinaryExpression)expression));
        }

        public void visit(Division expression) {
            this.process((BinaryExpression)expression, (DBFunctionSymbol)this.getArithmeticOperation((BinaryExpression)expression));
        }

        public void visit(IntegerDivision expression) {
            this.process((BinaryExpression)expression, (DBFunctionSymbol)this.getArithmeticOperation((BinaryExpression)expression));
        }

        public void visit(Modulo expression) {
            this.process((BinaryExpression)expression, (DBFunctionSymbol)this.getArithmeticOperation((BinaryExpression)expression));
        }

        public void visit(Concat expression) {
            this.process((BinaryExpression)expression, (DBFunctionSymbol)ExpressionParser.this.dbFunctionSymbolFactory.getDBConcatOperator(2));
        }

        private void process(BinaryExpression expression, DBFunctionSymbol function) {
            ImmutableTerm leftTerm = this.getTerm(expression.getLeftExpression());
            ImmutableTerm rightTerm = this.getTerm(expression.getRightExpression());
            this.result = ExpressionParser.this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)function, new ImmutableTerm[]{leftTerm, rightTerm});
        }

        private DBMathBinaryOperator getArithmeticOperation(BinaryExpression expression) {
            return ExpressionParser.this.dbFunctionSymbolFactory.getUntypedDBMathBinaryOperator(expression.getStringExpression());
        }

        public void visit(BitwiseAnd expression) {
            throw new UnsupportedSelectQueryRuntimeException("Bitwise AND is not supported", expression);
        }

        public void visit(BitwiseOr expression) {
            throw new UnsupportedSelectQueryRuntimeException("Bitwise OR is not supported", expression);
        }

        public void visit(BitwiseXor expression) {
            throw new UnsupportedSelectQueryRuntimeException("Bitwise XOR is not supported", expression);
        }

        public void visit(BitwiseRightShift expression) {
            throw new UnsupportedSelectQueryRuntimeException("BITWISE RIGHT SHIFT is not supported", expression);
        }

        public void visit(BitwiseLeftShift expression) {
            throw new UnsupportedSelectQueryRuntimeException("BITWISE LEFT SHIFT is not supported", expression);
        }

        public void visit(Parenthesis expression) {
            this.result = this.getTerm(expression.getExpression());
        }

        public void visit(SignedExpression expression) {
            ImmutableTerm arg = this.getTerm(expression.getExpression());
            switch (expression.getSign()) {
                case '-': {
                    this.result = ExpressionParser.this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)ExpressionParser.this.dbFunctionSymbolFactory.getUntypedDBMathBinaryOperator("*"), new ImmutableTerm[]{ExpressionParser.this.termFactory.getDBConstant("-1", ExpressionParser.this.dbTypeFactory.getDBLargeIntegerType()), arg});
                    break;
                }
                case '+': {
                    this.result = arg;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        public void visit(ExtractExpression expression) {
            DBFunctionSymbol extractFunctionSymbol = ExpressionParser.this.dbFunctionSymbolFactory.getExtractFunctionSymbol(expression.getName());
            ImmutableTerm arg = this.getTerm(expression.getExpression());
            this.result = ExpressionParser.this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)extractFunctionSymbol, new ImmutableTerm[]{arg});
        }

        public void visit(TimeKeyExpression expression) {
            DBFunctionSymbol functionSymbol;
            String str;
            switch (str = expression.getStringValue().toUpperCase()) {
                case "CURRENT_TIMESTAMP": 
                case "CURRENT_TIMESTAMP()": {
                    functionSymbol = ExpressionParser.this.dbFunctionSymbolFactory.getCurrentDateTimeSymbol("TIMESTAMP");
                    break;
                }
                case "CURRENT_TIME": 
                case "CURRENT_TIME()": {
                    functionSymbol = ExpressionParser.this.dbFunctionSymbolFactory.getCurrentDateTimeSymbol("TIME");
                    break;
                }
                case "CURRENT_DATE": 
                case "CURRENT_DATE()": {
                    functionSymbol = ExpressionParser.this.dbFunctionSymbolFactory.getCurrentDateTimeSymbol("DATE");
                    break;
                }
                default: {
                    throw new UnsupportedSelectQueryRuntimeException("TimeKeyExpression is not supported", expression);
                }
            }
            this.result = ExpressionParser.this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)functionSymbol, new ImmutableTerm[0]);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void visit(Column expression) {
            QuotedID column = ExpressionParser.this.idfac.createAttributeID(expression.getColumnName());
            Table table = expression.getTable();
            RelationID relation = table != null && table.getName() != null ? ExpressionParser.this.idfac.createRelationID(table.getSchemaName(), table.getName()) : null;
            QualifiedAttributeID qa = new QualifiedAttributeID(relation, column);
            ImmutableTerm var = this.attributes.get(qa);
            if (var == null) {
                if (column.equals(ExpressionParser.this.idfac.createAttributeID("true"))) {
                    this.result = ExpressionParser.this.termFactory.getDBBooleanConstant(true);
                    return;
                } else {
                    if (!column.equals(ExpressionParser.this.idfac.createAttributeID("false"))) throw new InvalidSelectQueryRuntimeException("Unable to find attribute name ", expression);
                    this.result = ExpressionParser.this.termFactory.getDBBooleanConstant(false);
                }
                return;
            } else {
                this.result = var;
            }
        }

        public void visit(EqualsTo expression) {
            this.processOJ((OldOracleJoinBinaryExpression)expression, (t1, t2) -> ExpressionParser.this.termFactory.getNotYetTypedEquality(t1, t2));
        }

        public void visit(GreaterThan expression) {
            this.processOJ((OldOracleJoinBinaryExpression)expression, (t1, t2) -> ExpressionParser.this.termFactory.getDBDefaultInequality(InequalityLabel.GT, t1, t2));
        }

        public void visit(GreaterThanEquals expression) {
            this.processOJ((OldOracleJoinBinaryExpression)expression, (t1, t2) -> ExpressionParser.this.termFactory.getDBDefaultInequality(InequalityLabel.GTE, t1, t2));
        }

        public void visit(MinorThan expression) {
            this.processOJ((OldOracleJoinBinaryExpression)expression, (t1, t2) -> ExpressionParser.this.termFactory.getDBDefaultInequality(InequalityLabel.LT, t1, t2));
        }

        public void visit(MinorThanEquals expression) {
            this.processOJ((OldOracleJoinBinaryExpression)expression, (t1, t2) -> ExpressionParser.this.termFactory.getDBDefaultInequality(InequalityLabel.LTE, t1, t2));
        }

        public void visit(NotEqualsTo expression) {
            this.processOJ((OldOracleJoinBinaryExpression)expression, (t1, t2) -> ExpressionParser.this.termFactory.getDBNot(ExpressionParser.this.termFactory.getNotYetTypedEquality(t1, t2)));
        }

        private void processOJ(OldOracleJoinBinaryExpression expression, BiFunction<ImmutableTerm, ImmutableTerm, ImmutableExpression> op) {
            if (expression.getOraclePriorPosition() != 0) {
                throw new UnsupportedSelectQueryRuntimeException("Oracle PRIOR is not supported", expression);
            }
            if (expression.getOldOracleJoinSyntax() != 0) {
                throw new UnsupportedSelectQueryRuntimeException("Old Oracle OUTER JOIN syntax is not supported", expression);
            }
            this.process((BinaryExpression)expression, op);
        }

        private void process(BinaryExpression expression, BiFunction<ImmutableTerm, ImmutableTerm, ImmutableExpression> op) {
            ImmutableTerm leftTerm = this.getTerm(expression.getLeftExpression());
            ImmutableTerm rightTerm = this.getTerm(expression.getRightExpression());
            this.result = (ImmutableTerm)op.apply(leftTerm, rightTerm);
        }

        public void visit(LikeExpression expression) {
            if (expression.isNot()) {
                this.process((BinaryExpression)expression, (ImmutableTerm t1, ImmutableTerm t2) -> ExpressionParser.this.termFactory.getDBNot(ExpressionParser.this.termFactory.getImmutableExpression((BooleanFunctionSymbol)ExpressionParser.this.dbFunctionSymbolFactory.getDBLike(), new ImmutableTerm[]{t1, t2})));
            } else {
                this.process((BinaryExpression)expression, (ImmutableTerm t1, ImmutableTerm t2) -> ExpressionParser.this.termFactory.getImmutableExpression((BooleanFunctionSymbol)ExpressionParser.this.dbFunctionSymbolFactory.getDBLike(), new ImmutableTerm[]{t1, t2}));
            }
        }

        public void visit(RegExpMySQLOperator expression) {
            DBConstant flags;
            switch (expression.getOperatorType()) {
                case MATCH_CASESENSITIVE: {
                    flags = ExpressionParser.this.termFactory.getDBStringConstant("");
                    break;
                }
                case MATCH_CASEINSENSITIVE: {
                    flags = ExpressionParser.this.termFactory.getDBStringConstant("i");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            this.process((BinaryExpression)expression, (ImmutableTerm t1, ImmutableTerm t2) -> flags.getValue().isEmpty() ? ExpressionParser.this.termFactory.getDBRegexpMatches(ImmutableList.of((Object)t1, (Object)t2)) : ExpressionParser.this.termFactory.getDBRegexpMatches(ImmutableList.of((Object)t1, (Object)t2, (Object)flags)));
        }

        public void visit(RegExpMatchOperator expression) {
            UnaryOperator not;
            DBConstant flags;
            switch (expression.getOperatorType()) {
                case MATCH_CASESENSITIVE: {
                    flags = ExpressionParser.this.termFactory.getDBStringConstant("");
                    not = UnaryOperator.identity();
                    break;
                }
                case MATCH_CASEINSENSITIVE: {
                    flags = ExpressionParser.this.termFactory.getDBStringConstant("i");
                    not = UnaryOperator.identity();
                    break;
                }
                case NOT_MATCH_CASESENSITIVE: {
                    flags = ExpressionParser.this.termFactory.getDBStringConstant("");
                    not = arg_0 -> ((TermFactory)ExpressionParser.this.termFactory).getDBNot(arg_0);
                    break;
                }
                case NOT_MATCH_CASEINSENSITIVE: {
                    flags = ExpressionParser.this.termFactory.getDBStringConstant("i");
                    not = arg_0 -> ((TermFactory)ExpressionParser.this.termFactory).getDBNot(arg_0);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            this.process((BinaryExpression)expression, (ImmutableTerm t1, ImmutableTerm t2) -> (ImmutableExpression)not.apply(flags.getValue().isEmpty() ? ExpressionParser.this.termFactory.getDBRegexpMatches(ImmutableList.of((Object)t1, (Object)t2)) : ExpressionParser.this.termFactory.getDBRegexpMatches(ImmutableList.of((Object)t1, (Object)t2, (Object)flags))));
        }

        public void visit(SimilarToExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("SIMILAR TO is not supported", expression);
        }

        public void visit(FullTextSearch fullTextSearch) {
            throw new UnsupportedSelectQueryRuntimeException("FullTextSearch is not supported", fullTextSearch);
        }

        public void visit(KeepExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("KeepExpression is not supported", expression);
        }

        public void visit(MySQLGroupConcat expression) {
            throw new UnsupportedSelectQueryRuntimeException("MySQLGroupConcat is not supported", expression);
        }

        public void visit(ValueListExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("ValueList is not supported", expression);
        }

        public void visit(RowConstructor expression) {
            throw new UnsupportedSelectQueryRuntimeException("RowConstructor is not supported", expression);
        }

        public void visit(OracleHint expression) {
            throw new UnsupportedSelectQueryRuntimeException("OracleHint is not supported", expression);
        }

        private ImmutableExpression negation(ImmutableExpression arg) {
            return arg.getFunctionSymbol() instanceof DBNotFunctionSymbol ? (ImmutableExpression)arg.getTerm(0) : ExpressionParser.this.termFactory.getDBNot(arg);
        }

        private java.util.function.Function<ImmutableExpression, ImmutableExpression> notOperation(boolean isNot) {
            return isNot ? this::negation : java.util.function.Function.identity();
        }

        public void visit(IsNullExpression expression) {
            ImmutableTerm term = this.getTerm(expression.getLeftExpression());
            this.result = (ImmutableTerm)this.notOperation(expression.isNot()).apply(ExpressionParser.this.termFactory.getDBIsNull(term));
        }

        private ImmutableExpression getExpression(Expression expression) {
            ImmutableTerm term = this.getTerm(expression);
            return (ImmutableExpression)term;
        }

        public void visit(AndExpression expression) {
            ImmutableExpression left = this.getExpression(expression.getLeftExpression());
            ImmutableExpression right = this.getExpression(expression.getRightExpression());
            this.result = ExpressionParser.this.termFactory.getConjunction(left, new ImmutableExpression[]{right});
        }

        public void visit(OrExpression expression) {
            ImmutableExpression left = this.getExpression(expression.getLeftExpression());
            ImmutableExpression right = this.getExpression(expression.getRightExpression());
            this.result = ExpressionParser.this.termFactory.getDisjunction(left, new ImmutableExpression[]{right});
        }

        public void visit(NotExpression expression) {
            this.result = this.negation(this.getExpression(expression.getExpression()));
        }

        public void visit(IsBooleanExpression expression) {
            this.result = (ImmutableTerm)this.notOperation(expression.isNot() == expression.isTrue()).apply(this.getExpression(expression.getLeftExpression()));
        }

        public void visit(Between expression) {
            ImmutableTerm t = this.getTerm(expression.getLeftExpression());
            ImmutableTerm t1 = this.getTerm(expression.getBetweenExpressionStart());
            ImmutableTerm t2 = this.getTerm(expression.getBetweenExpressionEnd());
            if (expression.isNot()) {
                ImmutableExpression e1 = ExpressionParser.this.termFactory.getDBDefaultInequality(InequalityLabel.LT, t, t1);
                ImmutableExpression e2 = ExpressionParser.this.termFactory.getDBDefaultInequality(InequalityLabel.GT, t, t2);
                this.result = ExpressionParser.this.termFactory.getDisjunction(e1, new ImmutableExpression[]{e2});
            } else {
                ImmutableExpression e1 = ExpressionParser.this.termFactory.getDBDefaultInequality(InequalityLabel.GTE, t, t1);
                ImmutableExpression e2 = ExpressionParser.this.termFactory.getDBDefaultInequality(InequalityLabel.LTE, t, t2);
                this.result = ExpressionParser.this.termFactory.getConjunction(e1, new ImmutableExpression[]{e2});
            }
        }

        public void visit(InExpression expression) {
            ItemsList right;
            if (expression.getOldOracleJoinSyntax() != 0) {
                throw new UnsupportedSelectQueryRuntimeException("Oracle OUTER JOIN syntax is not supported", expression);
            }
            if (expression.getOraclePriorPosition() != 0) {
                throw new UnsupportedSelectQueryRuntimeException("Oracle PRIOR syntax is not supported", expression);
            }
            Expression left = expression.getLeftExpression();
            if (left != null) {
                right = expression.getRightItemsList();
                if (right instanceof SubSelect) {
                    throw new UnsupportedSelectQueryRuntimeException("SubSelect in IN is not supported", expression);
                }
                if (right instanceof MultiExpressionList) {
                    throw new InvalidSelectQueryRuntimeException("MultiExpressionList is not allowed with a single expression on the left in IN", expression);
                }
            } else {
                ItemsList list = expression.getLeftItemsList();
                if (!(list instanceof ExpressionList)) {
                    throw new InvalidSelectQueryRuntimeException("Only ExpressionList is allowed on the left of IN", expression);
                }
                ItemsList right2 = expression.getRightItemsList();
                if (right2 instanceof SubSelect) {
                    throw new UnsupportedSelectQueryRuntimeException("SubSelect in IN is not supported", expression);
                }
                if (right2 instanceof ExpressionList) {
                    throw new InvalidSelectQueryRuntimeException("ExpressionList is not allowed with an ExpressionList on the left in IN", expression);
                }
                throw new InvalidSelectQueryRuntimeException("not possible in the current JSQLParser", expression);
            }
            ImmutableTerm leftTerm = this.getTerm(expression.getLeftExpression());
            Stream<ImmutableExpression> stream = ((ExpressionList)right).getExpressions().stream().map(item -> ExpressionParser.this.termFactory.getNotYetTypedEquality(leftTerm, this.getTerm((Expression)item)));
            ImmutableList equalities = (ImmutableList)stream.collect(ImmutableCollectors.toList());
            if (equalities.isEmpty()) {
                throw new InvalidSelectQueryRuntimeException("IN must contain at least one expression", expression);
            }
            this.result = (ImmutableTerm)this.notOperation(expression.isNot()).apply(ExpressionParser.this.termFactory.getDisjunction(equalities));
        }

        public void visit(CaseExpression expression) {
            java.util.function.Function<WhenClause, ImmutableExpression> whenTranslation;
            if (expression.getSwitchExpression() != null) {
                ImmutableTerm switchTerm = this.getTerm(expression.getSwitchExpression());
                whenTranslation = w -> ExpressionParser.this.termFactory.getNotYetTypedEquality(switchTerm, this.getTerm(w.getWhenExpression()));
            } else {
                whenTranslation = w -> this.getExpression(w.getWhenExpression());
            }
            ImmutableList whenPairs = (ImmutableList)expression.getWhenClauses().stream().map(w -> Maps.immutableEntry(whenTranslation.apply((WhenClause)w), (Object)this.getTerm(w.getThenExpression()))).collect(ImmutableCollectors.toList());
            ImmutableTerm defaultTerm = Optional.ofNullable(expression.getElseExpression()).map(this::getTerm).orElse((ImmutableTerm)ExpressionParser.this.termFactory.getNullConstant());
            this.result = ExpressionParser.this.termFactory.getDBCase(whenPairs.stream(), defaultTerm, false);
        }

        public void visit(WhenClause expression) {
            throw new UnsupportedOperationException("Unexpected WHEN: " + expression);
        }

        public void visit(CastExpression expression) {
            ImmutableTerm term = this.getTerm(expression.getLeftExpression());
            ColDataType type = expression.getType();
            String datatype = type.getDataType();
            this.result = ExpressionParser.this.termFactory.getDBCastFunctionalTerm(ExpressionParser.this.dbTypeFactory.getDBTermType(datatype), term);
        }

        public void visit(SubSelect expression) {
            throw new UnsupportedSelectQueryRuntimeException("SubSelect is not supported yet", expression);
        }

        public void visit(ExistsExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("EXISTS is not supported yet", expression);
        }

        public void visit(AllComparisonExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("ALL is not supported yet", expression);
        }

        public void visit(AnyComparisonExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("ANY is not supported yet", expression);
        }

        public void visit(AnalyticExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Analytic expressions is not supported", expression);
        }

        public void visit(OracleHierarchicalExpression expression) {
            throw new UnsupportedOperationException("Unexpected Oracle START WITH ... CONNECT BY");
        }

        public void visit(Matches expression) {
            throw new UnsupportedSelectQueryRuntimeException("Oracle @@ not supported", expression);
        }

        public void visit(JsonExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("JSON expressions are not supported", expression);
        }

        public void visit(ArrayExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Array is not supported yet", expression);
        }

        public void visit(NextValExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("NextVal is not supported yet", expression);
        }

        public void visit(CollateExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Collate is not supported yet", expression);
        }

        public void visit(JsonOperator expression) {
            throw new UnsupportedSelectQueryRuntimeException("JSON operators are not supported", expression);
        }

        public void visit(UserVariable expression) {
            throw new InvalidSelectQueryRuntimeException("User variables are not allowed", expression);
        }

        public void visit(NumericBind expression) {
            throw new InvalidSelectQueryRuntimeException("Numeric Binds are not allowed", expression);
        }

        public void visit(JdbcParameter expression) {
            throw new InvalidSelectQueryRuntimeException("JDBC parameters are not allowed", expression);
        }

        public void visit(JdbcNamedParameter expression) {
            throw new InvalidSelectQueryRuntimeException("JDBC named parameters are not allowed", expression);
        }
    }
}

