/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.pp.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.base.Strings;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.impl.RawQuotedIDFactory;
import it.unibz.inf.ontop.exception.InvalidMappingSourceQueriesException;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.pp.PPMappingAssertionProvenance;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMappingConverter;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.OntopNativeSQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.sqlparser.ApproximateSelectQueryAttributeExtractor;
import it.unibz.inf.ontop.spec.mapping.sqlparser.DefaultSelectQueryAttributeExtractor;
import it.unibz.inf.ontop.spec.mapping.sqlparser.JSqlParserTools;
import it.unibz.inf.ontop.spec.mapping.sqlparser.ParserViewDefinition;
import it.unibz.inf.ontop.spec.mapping.sqlparser.RAExpression;
import it.unibz.inf.ontop.spec.mapping.sqlparser.SelectQueryParser;
import it.unibz.inf.ontop.spec.mapping.sqlparser.exception.InvalidSelectQueryException;
import it.unibz.inf.ontop.spec.mapping.sqlparser.exception.UnsupportedSelectQueryException;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.IQ2CQ;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.TokenMgrException;
import net.sf.jsqlparser.statement.select.SelectBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLPPMappingConverterImpl
implements SQLPPMappingConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLPPMappingConverterImpl.class);
    private final TermFactory termFactory;
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;
    private final CoreSingletons coreSingletons;
    private final DBTypeFactory dbTypeFactory;

    @Inject
    private SQLPPMappingConverterImpl(CoreSingletons coreSingletons) {
        this.termFactory = coreSingletons.getTermFactory();
        this.iqFactory = coreSingletons.getIQFactory();
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
        this.coreSingletons = coreSingletons;
        this.dbTypeFactory = coreSingletons.getTypeFactory().getDBTypeFactory();
    }

    public ImmutableList<MappingAssertion> convert(ImmutableList<SQLPPTriplesMap> mapping, MetadataLookup metadataLookup) throws InvalidMappingSourceQueriesException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SQLPPTriplesMap assertion : mapping) {
            RAExpression re = this.getRAExpression(assertion, metadataLookup);
            IQTree tree = IQ2CQ.toIQTree((ImmutableList)((ImmutableList)re.getDataAtoms().stream().collect(ImmutableCollectors.toList())), (Optional)this.termFactory.getConjunction(re.getFilterAtoms().stream()), (IntermediateQueryFactory)this.iqFactory);
            Function<Variable, Optional<ImmutableTerm>> lookup = SQLPPMappingConverterImpl.placeholderLookup(assertion, metadataLookup.getQuotedIDFactory(), re.getUnqualifiedAttributes());
            for (TargetAtom target : assertion.getTargetAtoms()) {
                PPMappingAssertionProvenance provenance = assertion.getMappingAssertionProvenance(target);
                builder.add((Object)this.convert(target, lookup, provenance, tree));
            }
        }
        ImmutableList result = builder.build();
        LOGGER.debug("Original mapping size: {}", (Object)result.size());
        return result;
    }

    private static <T> Function<Variable, Optional<T>> placeholderLookup(SQLPPTriplesMap mappingAssertion, QuotedIDFactory idFactory, ImmutableMap<QuotedID, T> lookup) {
        Function<Variable, Optional<T>> standard = v -> Optional.ofNullable(lookup.get((Object)idFactory.createAttributeID(v.getName())));
        if (mappingAssertion instanceof OntopNativeSQLPPTriplesMap) {
            RawQuotedIDFactory rawIdFactory = new RawQuotedIDFactory(idFactory);
            return arg_0 -> SQLPPMappingConverterImpl.lambda$placeholderLookup$1(standard, lookup, (QuotedIDFactory)rawIdFactory, arg_0);
        }
        return standard;
    }

    private MappingAssertion convert(TargetAtom target, Function<Variable, Optional<ImmutableTerm>> lookup, PPMappingAssertionProvenance provenance, IQTree tree) throws InvalidMappingSourceQueriesException {
        ImmutableMap targetPreMap = (ImmutableMap)target.getProjectionAtom().getArguments().stream().map(v -> target.getSubstitution().apply((ImmutableTerm)v)).flatMap(ImmutableTerm::getVariableStream).distinct().collect(ImmutableCollectors.toMap(Function.identity(), lookup));
        if (targetPreMap.values().stream().anyMatch(t -> !t.isPresent())) {
            throw new InvalidMappingSourceQueriesException(targetPreMap.entrySet().stream().filter(e -> !((Optional)e.getValue()).isPresent()).map(Map.Entry::getKey).map(Variable::getName).collect(Collectors.joining(", ", "The placeholder(s) ", " in the target do(es) not occur in source query of the mapping assertion\n[" + provenance.getProvenanceInfo() + "]")));
        }
        ImmutableMap targetMap = (ImmutableMap)targetPreMap.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> (ImmutableTerm)((Optional)e.getValue()).orElseThrow(() -> new MinorOntopInternalBugException("Impossible"))));
        ImmutableSubstitution targetRenamingPart = this.substitutionFactory.getSubstitution((ImmutableMap)targetMap.entrySet().stream().filter(e -> e.getValue() instanceof Variable).filter(e -> !((ImmutableTerm)e.getValue()).equals(e.getKey())).collect(ImmutableCollectors.toMap()));
        ImmutableSubstitution spoSubstitution = this.substitutionFactory.getSubstitution((ImmutableMap)target.getSubstitution().getImmutableMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> targetRenamingPart.apply((ImmutableTerm)e.getValue()))));
        ImmutableSubstitution selectSubstitution = this.substitutionFactory.getSubstitution((ImmutableMap)targetMap.entrySet().stream().filter(e -> !(e.getValue() instanceof Variable)).collect(ImmutableCollectors.toMap()));
        UnaryIQTree selectTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode((ImmutableSet)spoSubstitution.getImmutableMap().values().stream().flatMap(ImmutableTerm::getVariableStream).collect(ImmutableCollectors.toSet()), selectSubstitution), tree);
        UnaryIQTree mappingTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(target.getProjectionAtom().getVariables(), spoSubstitution), (IQTree)selectTree);
        return new MappingAssertion(this.iqFactory.createIQ(target.getProjectionAtom(), (IQTree)mappingTree), provenance);
    }

    private RAExpression getRAExpression(SQLPPTriplesMap mappingAssertion, MetadataLookup metadataLookup) throws InvalidMappingSourceQueriesException {
        String sourceQuery = mappingAssertion.getSourceQuery().getSQL();
        SelectQueryParser sqp = new SelectQueryParser(metadataLookup, this.coreSingletons);
        try {
            ImmutableList<QuotedID> attributes;
            try {
                SelectBody selectBody = JSqlParserTools.parse(sourceQuery);
                try {
                    return sqp.parse(selectBody);
                }
                catch (UnsupportedSelectQueryException e) {
                    DefaultSelectQueryAttributeExtractor sqae = new DefaultSelectQueryAttributeExtractor(metadataLookup, this.coreSingletons);
                    ImmutableMap<QuotedID, ImmutableTerm> attrs = sqae.getRAExpressionAttributes(selectBody).getUnqualifiedAttributes();
                    attributes = ImmutableList.copyOf((Collection)attrs.keySet());
                }
            }
            catch (JSQLParserException e) {
                System.out.println(String.format("FAILED TO PARSE: %s %s", sourceQuery, SQLPPMappingConverterImpl.getJSQLParserErrorMessage(sourceQuery, e)));
                ApproximateSelectQueryAttributeExtractor sqae = new ApproximateSelectQueryAttributeExtractor(metadataLookup.getQuotedIDFactory());
                attributes = sqae.getAttributes(sourceQuery);
            }
            catch (UnsupportedSelectQueryException e) {
                ApproximateSelectQueryAttributeExtractor sqae = new ApproximateSelectQueryAttributeExtractor(metadataLookup.getQuotedIDFactory());
                attributes = sqae.getAttributes(sourceQuery);
            }
            System.out.println("PARSER VIEW FOR " + sourceQuery);
            ParserViewDefinition view = new ParserViewDefinition(attributes, sourceQuery, this.dbTypeFactory);
            return sqp.translateParserView((RelationDefinition)view);
        }
        catch (InvalidSelectQueryException e) {
            throw new InvalidMappingSourceQueriesException("Error: " + e.getMessage() + " \nProblem location: source query of triplesMap \n[" + mappingAssertion.getTriplesMapProvenance().getProvenanceInfo() + "]");
        }
    }

    private static String getJSQLParserErrorMessage(String sourceQuery, JSQLParserException e) {
        try {
            Pattern pattern;
            Matcher matcher;
            if (e.getCause() instanceof TokenMgrException && (matcher = (pattern = Pattern.compile("at line (\\d+), column (\\d+)")).matcher(e.getCause().getMessage())).find()) {
                int line = Integer.parseInt(matcher.group(1));
                int col = Integer.parseInt(matcher.group(2));
                String sourceQueryLine = sourceQuery.split("\n")[line - 1];
                int MAX_LENGTH = 40;
                if (sourceQueryLine.length() > 40) {
                    if ((sourceQueryLine = sourceQueryLine.substring(sourceQueryLine.length() - 40)).length() > 80) {
                        sourceQueryLine = sourceQueryLine.substring(0, 80);
                    }
                    col = 40;
                }
                return "FAILED TO PARSE: " + sourceQueryLine + "\n" + Strings.repeat((String)" ", (int)("FAILED TO PARSE: ".length() + col - 2)) + "^\n" + e.getCause();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return e.getCause().toString();
    }

    private static /* synthetic */ Optional lambda$placeholderLookup$1(Function standard, ImmutableMap lookup, QuotedIDFactory rawIdFactory, Variable v) {
        return Optional.ofNullable(((Optional)standard.apply(v)).orElse(lookup.get((Object)rawIdFactory.createAttributeID(v.getName()))));
    }
}

