/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.serializer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;

class TurtleWriter {
    private Multimap<Optional<String>, String> graphToSubjects = ArrayListMultimap.create();
    private HashMap<String, ArrayList<String>> subjectToPredicates = new HashMap();
    private HashMap<String, ArrayList<String>> predicateToObjects = new HashMap();

    TurtleWriter() {
    }

    void put(String subject, String predicate, String object) {
        Optional graph = Optional.empty();
        if (!this.graphToSubjects.containsEntry(graph, (Object)subject)) {
            this.graphToSubjects.put(graph, (Object)subject);
        }
        this.insertSPO(subject, predicate, object);
    }

    void insertSPO(String subjectKey, String predicate, String object) {
        ArrayList<String> predicateList = this.subjectToPredicates.get(subjectKey);
        if (predicateList == null) {
            predicateList = new ArrayList();
        }
        this.insert(predicateList, predicate);
        this.subjectToPredicates.put(subjectKey, predicateList);
        String predicateKey = this.computePredicateKey(subjectKey, predicate);
        ArrayList<String> objectList = this.predicateToObjects.get(predicateKey);
        if (objectList == null) {
            objectList = new ArrayList();
        }
        if (!objectList.contains(object)) {
            objectList.add(object);
        }
        this.predicateToObjects.put(predicateKey, objectList);
    }

    public void put(String subject, String predicate, String object, String graph) {
        Optional<String> optionalGraph = Optional.of(graph);
        if (!this.graphToSubjects.containsEntry(optionalGraph, (Object)subject)) {
            this.graphToSubjects.put(optionalGraph, (Object)subject);
        }
        this.insertSPO(this.computeSubjectKey(graph, subject), predicate, object);
    }

    private void insert(ArrayList<String> list, String input) {
        if (!list.contains(input)) {
            if (input.equals("a") || input.equals("rdf:type")) {
                list.add(0, input);
            } else {
                list.add(input);
            }
        }
    }

    String print() {
        StringBuilder sb = new StringBuilder();
        for (Optional graph : this.graphToSubjects.keySet()) {
            graph.ifPresent(g -> sb.append(String.format("GRAPH %s { ", g)));
            Collection subjects = this.graphToSubjects.get((Object)graph);
            int i = 0;
            for (String subject : subjects) {
                String subjectKey = graph.map(g -> this.computeSubjectKey((String)g, subject)).orElse(subject);
                sb.append(subject);
                sb.append(" ");
                boolean semiColonSeparator = false;
                for (String predicate : this.subjectToPredicates.get(subjectKey)) {
                    if (semiColonSeparator) {
                        sb.append(" ; ");
                    }
                    sb.append(predicate);
                    sb.append(" ");
                    semiColonSeparator = true;
                    boolean commaSeparator = false;
                    for (String object : this.predicateToObjects.get(this.computePredicateKey(subjectKey, predicate))) {
                        if (commaSeparator) {
                            sb.append(" , ");
                        }
                        sb.append(object);
                        commaSeparator = true;
                    }
                }
                if (++i >= subjects.size()) continue;
                sb.append(" . ");
            }
            sb.append(graph.map(g -> " } . ").orElse(" . "));
        }
        return sb.toString();
    }

    private String computeSubjectKey(String graph, String subject) {
        return subject + "_" + graph;
    }

    private String computePredicateKey(String subjectKey, String predicate) {
        return predicate + "_" + subjectKey;
    }
}

