/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.pp.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.spec.mapping.SQLPPSourceQuery;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.pp.PPMappingAssertionProvenance;
import it.unibz.inf.ontop.spec.mapping.pp.PPTriplesMapProvenance;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.AbstractSQLPPTriplesMap;
import java.util.Optional;
import java.util.stream.Collectors;

public class R2RMLSQLPPtriplesMap
extends AbstractSQLPPTriplesMap {
    private final R2RMLSQLPPtriplesMapProvenance triplesMapProvenance = new R2RMLSQLPPtriplesMapProvenance();

    public R2RMLSQLPPtriplesMap(String id, SQLPPSourceQuery sqlQuery, ImmutableList<TargetAtom> targetAtoms) {
        super(targetAtoms, sqlQuery, id);
    }

    public PPMappingAssertionProvenance getMappingAssertionProvenance(final TargetAtom targetAtom) {
        return new PPMappingAssertionProvenance(){

            public String getProvenanceInfo() {
                return "id: " + R2RMLSQLPPtriplesMap.this.getId() + "\ntarget atom: " + targetAtom.toString() + "\nsource query: " + R2RMLSQLPPtriplesMap.this.getSourceQuery();
            }

            public String toString() {
                return this.getProvenanceInfo();
            }
        };
    }

    public PPTriplesMapProvenance getTriplesMapProvenance() {
        return this.triplesMapProvenance;
    }

    public String toString() {
        return this.triplesMapProvenance.getProvenanceInfo();
    }

    @Override
    public Optional<String> getOptionalTargetString() {
        return Optional.empty();
    }

    @Override
    public SQLPPTriplesMap extractPPMappingAssertions(String newId, ImmutableList<TargetAtom> atoms) {
        return new R2RMLSQLPPtriplesMap(newId, this.getSourceQuery(), atoms);
    }

    private class R2RMLSQLPPtriplesMapProvenance
    implements PPTriplesMapProvenance {
        private R2RMLSQLPPtriplesMapProvenance() {
        }

        public String getProvenanceInfo() {
            return "id: " + R2RMLSQLPPtriplesMap.this.getId() + "\ntarget atoms: " + R2RMLSQLPPtriplesMap.this.getTargetAtoms().stream().map(Object::toString).collect(Collectors.joining(", ")) + "\nsource query: " + R2RMLSQLPPtriplesMap.this.getSourceQuery();
        }

        public String toString() {
            return this.getProvenanceInfo();
        }
    }
}

