/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.pp.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.spec.mapping.SQLPPSourceQuery;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.pp.PPMappingAssertionProvenance;
import it.unibz.inf.ontop.spec.mapping.pp.PPTriplesMapProvenance;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.AbstractSQLPPTriplesMap;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class OntopNativeSQLPPTriplesMap
extends AbstractSQLPPTriplesMap {
    private final Optional<String> targetString;
    private final OntopNativeSQLPPTriplesMapProvenance triplesMapProvenance = new OntopNativeSQLPPTriplesMapProvenance();

    public OntopNativeSQLPPTriplesMap(String id, SQLPPSourceQuery sqlQuery, @Nonnull String targetString, ImmutableList<TargetAtom> targetAtoms) {
        super(targetAtoms, sqlQuery, id);
        this.targetString = Optional.of(targetString);
    }

    public OntopNativeSQLPPTriplesMap(String id, SQLPPSourceQuery sqlQuery, ImmutableList<TargetAtom> targetAtoms) {
        super(targetAtoms, sqlQuery, id);
        this.targetString = Optional.empty();
    }

    public PPMappingAssertionProvenance getMappingAssertionProvenance(final TargetAtom targetAtom) {
        return new PPMappingAssertionProvenance(){

            public String getProvenanceInfo() {
                return "id: " + OntopNativeSQLPPTriplesMap.this.getId() + "\ntarget atom: " + targetAtom.toString() + "\nsource query: " + OntopNativeSQLPPTriplesMap.this.getSourceQuery();
            }

            public String toString() {
                return this.getProvenanceInfo();
            }
        };
    }

    public PPTriplesMapProvenance getTriplesMapProvenance() {
        return this.triplesMapProvenance;
    }

    public String toString() {
        return this.triplesMapProvenance.getProvenanceInfo();
    }

    @Override
    public Optional<String> getOptionalTargetString() {
        return this.targetString;
    }

    @Override
    public SQLPPTriplesMap extractPPMappingAssertions(String newId, ImmutableList<TargetAtom> atoms) {
        return new OntopNativeSQLPPTriplesMap(newId, this.getSourceQuery(), atoms);
    }

    private class OntopNativeSQLPPTriplesMapProvenance
    implements PPTriplesMapProvenance {
        private OntopNativeSQLPPTriplesMapProvenance() {
        }

        public String getProvenanceInfo() {
            return "id: " + OntopNativeSQLPPTriplesMap.this.getId() + "\ntarget atoms: " + OntopNativeSQLPPTriplesMap.this.getTargetAtoms().stream().map(Object::toString).collect(Collectors.joining(", ")) + "\nsource query: " + OntopNativeSQLPPTriplesMap.this.getSourceQuery();
        }

        public String toString() {
            return this.getProvenanceInfo();
        }
    }
}

