/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import it.unibz.inf.ontop.dbschema.DBMetadataProvider;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.MetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.CachingMetadataLookup;
import it.unibz.inf.ontop.dbschema.impl.JDBCMetadataProviderFactory;
import it.unibz.inf.ontop.exception.InvalidMappingException;
import it.unibz.inf.ontop.exception.InvalidMappingSourceQueriesException;
import it.unibz.inf.ontop.exception.MappingException;
import it.unibz.inf.ontop.exception.MappingIOException;
import it.unibz.inf.ontop.exception.MappingOntologyMismatchException;
import it.unibz.inf.ontop.exception.MetaMappingExpansionException;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.exception.UnknownDatatypeException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopMappingSQLSettings;
import it.unibz.inf.ontop.injection.OntopSQLCredentialSettings;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.transform.NoNullValueEnforcer;
import it.unibz.inf.ontop.spec.OBDASpecInput;
import it.unibz.inf.ontop.spec.dbschema.ImplicitDBConstraintsProviderFactory;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.MappingExtractor;
import it.unibz.inf.ontop.spec.mapping.parser.SQLMappingParser;
import it.unibz.inf.ontop.spec.mapping.pp.PreProcessedMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMappingConverter;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.MetaMappingExpander;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingCanonicalTransformer;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingCaster;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingDatatypeFiller;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingEqualityTransformer;
import it.unibz.inf.ontop.spec.mapping.validation.MappingOntologyComplianceValidator;
import it.unibz.inf.ontop.spec.ontology.Ontology;
import it.unibz.inf.ontop.utils.LocalJDBCConnectionUtils;
import java.io.File;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.Graph;

public class SQLMappingExtractor
implements MappingExtractor {
    private final SQLPPMappingConverter ppMappingConverter;
    private final OntopMappingSQLSettings settings;
    private final MappingDatatypeFiller mappingDatatypeFiller;
    private final MappingCanonicalTransformer canonicalTransformer;
    private final MappingCaster mappingCaster;
    private final MappingEqualityTransformer mappingEqualityTransformer;
    private final NoNullValueEnforcer noNullValueEnforcer;
    private final IntermediateQueryFactory iqFactory;
    private final JDBCMetadataProviderFactory metadataProviderFactory;
    private final MappingOntologyComplianceValidator ontologyComplianceValidator;
    private final SQLMappingParser mappingParser;
    private final MetaMappingExpander metamappingExpander;
    private final ImplicitDBConstraintsProviderFactory implicitDBConstraintExtractor;

    @Inject
    private SQLMappingExtractor(SQLMappingParser mappingParser, MappingOntologyComplianceValidator ontologyComplianceValidator, SQLPPMappingConverter ppMappingConverter, MappingDatatypeFiller mappingDatatypeFiller, OntopMappingSQLSettings settings, MappingCanonicalTransformer canonicalTransformer, MappingCaster mappingCaster, MappingEqualityTransformer mappingEqualityTransformer, NoNullValueEnforcer noNullValueEnforcer, IntermediateQueryFactory iqFactory, MetaMappingExpander metamappingExpander, ImplicitDBConstraintsProviderFactory implicitDBConstraintExtractor, JDBCMetadataProviderFactory metadataProviderFactory) {
        this.ontologyComplianceValidator = ontologyComplianceValidator;
        this.mappingParser = mappingParser;
        this.ppMappingConverter = ppMappingConverter;
        this.mappingDatatypeFiller = mappingDatatypeFiller;
        this.settings = settings;
        this.canonicalTransformer = canonicalTransformer;
        this.mappingCaster = mappingCaster;
        this.mappingEqualityTransformer = mappingEqualityTransformer;
        this.noNullValueEnforcer = noNullValueEnforcer;
        this.iqFactory = iqFactory;
        this.metamappingExpander = metamappingExpander;
        this.metadataProviderFactory = metadataProviderFactory;
        this.implicitDBConstraintExtractor = implicitDBConstraintExtractor;
    }

    public MappingExtractor.MappingAndDBParameters extract(@Nonnull OBDASpecInput specInput, @Nonnull Optional<Ontology> ontology) throws MappingException, MetadataExtractionException {
        return this.convertPPMapping(this.extractPPMapping(specInput), specInput, ontology);
    }

    public MappingExtractor.MappingAndDBParameters extract(@Nonnull PreProcessedMapping ppMapping, @Nonnull OBDASpecInput specInput, @Nonnull Optional<Ontology> ontology) throws MappingException, MetadataExtractionException {
        return this.convertPPMapping((SQLPPMapping)ppMapping, specInput, ontology);
    }

    protected SQLPPMapping extractPPMapping(OBDASpecInput specInput) throws MappingIOException, InvalidMappingException {
        Optional optionalMappingFile = specInput.getMappingFile();
        if (optionalMappingFile.isPresent()) {
            return this.mappingParser.parse((File)optionalMappingFile.get());
        }
        Optional optionalMappingReader = specInput.getMappingReader();
        if (optionalMappingReader.isPresent()) {
            return this.mappingParser.parse((Reader)optionalMappingReader.get());
        }
        Optional optionalMappingGraph = specInput.getMappingGraph();
        if (optionalMappingGraph.isPresent()) {
            return this.mappingParser.parse((Graph)optionalMappingGraph.get());
        }
        throw new IllegalArgumentException("Bad internal configuration: no mapping input provided in the OBDASpecInput!\n Should have been detected earlier (in case of an user mistake)");
    }

    protected MappingExtractor.MappingAndDBParameters convertPPMapping(SQLPPMapping ppMapping, OBDASpecInput specInput, Optional<Ontology> optionalOntology) throws MetaMappingExpansionException, MetadataExtractionException, MappingOntologyMismatchException, InvalidMappingSourceQueriesException, UnknownDatatypeException {
        MappingExtractor.MappingAndDBParameters mm = this.convert((ImmutableList<SQLPPTriplesMap>)ppMapping.getTripleMaps(), specInput.getConstraintFile());
        ImmutableList<MappingAssertion> expMapping = this.metamappingExpander.transform((ImmutableList<MappingAssertion>)mm.getMapping(), mm.getDBParameters());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MappingAssertion assertion : expMapping) {
            IQTree tree = assertion.getQuery().getTree();
            IQTree equalityTransformedTree = this.mappingEqualityTransformer.transform(tree);
            IQTree normalizedTree = equalityTransformedTree.normalizeForOptimization(assertion.getQuery().getVariableGenerator());
            IQTree noNullTree = this.noNullValueEnforcer.transform(normalizedTree);
            MappingAssertion noNullAssertion = assertion.copyOf(noNullTree, this.iqFactory);
            MappingAssertion filledProvAssertion = this.mappingDatatypeFiller.transform(noNullAssertion);
            MappingAssertion castAssertion = this.mappingCaster.transform(filledProvAssertion);
            builder.add((Object)castAssertion);
        }
        ImmutableList castMapping = builder.build();
        ImmutableList canonizedMapping = this.canonicalTransformer.transform(castMapping);
        if (optionalOntology.isPresent()) {
            this.ontologyComplianceValidator.validate(canonizedMapping, optionalOntology.get());
        }
        return new MappingAndDBParametersImpl((ImmutableList<MappingAssertion>)canonizedMapping, mm.getDBParameters());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MappingExtractor.MappingAndDBParameters convert(ImmutableList<SQLPPTriplesMap> mapping, Optional<File> constraintFile) throws MetadataExtractionException, InvalidMappingSourceQueriesException, MetaMappingExpansionException {
        try (Connection connection = LocalJDBCConnectionUtils.createConnection((OntopSQLCredentialSettings)this.settings);){
            DBMetadataProvider dbMetadataProvider = this.metadataProviderFactory.getMetadataProvider(connection);
            MetadataProvider withImplicitConstraintsMetadataProvider = this.implicitDBConstraintExtractor.extract(constraintFile, (MetadataProvider)dbMetadataProvider);
            CachingMetadataLookup metadataLookup = new CachingMetadataLookup(withImplicitConstraintsMetadataProvider);
            ImmutableList provMapping = this.ppMappingConverter.convert(mapping, (MetadataLookup)metadataLookup);
            metadataLookup.extractImmutableMetadata();
            MappingAndDBParametersImpl mappingAndDBParametersImpl = new MappingAndDBParametersImpl((ImmutableList<MappingAssertion>)provMapping, withImplicitConstraintsMetadataProvider.getDBParameters());
            return mappingAndDBParametersImpl;
        }
        catch (SQLException e) {
            throw new MetadataExtractionException(e.getMessage());
        }
    }

    private static class MappingAndDBParametersImpl
    implements MappingExtractor.MappingAndDBParameters {
        private final ImmutableList<MappingAssertion> mapping;
        private final DBParameters dbParameters;

        public MappingAndDBParametersImpl(ImmutableList<MappingAssertion> mapping, DBParameters dbParameters) {
            this.mapping = mapping;
            this.dbParameters = dbParameters;
        }

        public ImmutableList<MappingAssertion> getMapping() {
            return this.mapping;
        }

        public DBParameters getDBParameters() {
            return this.dbParameters;
        }
    }
}

