/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.injection.SQLPPMappingFactory;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;

public class SQLPPMappingFactoryImpl
implements SQLPPMappingFactory {
    private final OntopMappingSettings settings;

    @Inject
    private SQLPPMappingFactoryImpl(OntopMappingSettings settings) {
        this.settings = settings;
    }

    private Constructor[] findConstructors(Class genericClass) {
        String implementationName = (String)this.settings.getProperty(genericClass.getCanonicalName()).orElseThrow(() -> new RuntimeException("No implementation declared for " + genericClass.getCanonicalName()));
        try {
            Class<?> implementationClass = Class.forName(implementationName);
            return implementationClass.getConstructors();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private Constructor findFirstConstructor(Class genericClass) {
        return this.findConstructors(genericClass)[0];
    }

    @Override
    public SQLPPMapping createSQLPreProcessedMapping(ImmutableList<SQLPPTriplesMap> ppMappingAxioms, PrefixManager prefixManager) {
        try {
            Constructor constructor = this.findFirstConstructor(SQLPPMapping.class);
            return (SQLPPMapping)constructor.newInstance(ppMappingAxioms, prefixManager);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw new RuntimeException(targetException.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

