/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.serializer;

import java.util.ArrayList;
import java.util.HashMap;

class TurtleWriter {
    private HashMap<String, ArrayList<String>> subjectToPredicates = new HashMap();
    private HashMap<String, ArrayList<String>> predicateToObjects = new HashMap();

    TurtleWriter() {
    }

    void put(String subject, String predicate, String object) {
        ArrayList<String> predicateList = this.subjectToPredicates.get(subject);
        if (predicateList == null) {
            predicateList = new ArrayList();
        }
        this.insert(predicateList, predicate);
        this.subjectToPredicates.put(subject, predicateList);
        ArrayList<String> objectList = this.predicateToObjects.get(predicate + "_" + subject);
        if (objectList == null) {
            objectList = new ArrayList();
        }
        objectList.add(object);
        this.predicateToObjects.put(predicate + "_" + subject, objectList);
    }

    private void insert(ArrayList<String> list, String input) {
        if (!list.contains(input)) {
            if (input.equals("a") || input.equals("rdf:type")) {
                list.add(0, input);
            } else {
                list.add(input);
            }
        }
    }

    String print() {
        StringBuilder sb = new StringBuilder();
        for (String subject : this.subjectToPredicates.keySet()) {
            sb.append(subject);
            sb.append(" ");
            boolean semiColonSeparator = false;
            for (String predicate : this.subjectToPredicates.get(subject)) {
                if (semiColonSeparator) {
                    sb.append(" ; ");
                }
                sb.append(predicate);
                sb.append(" ");
                semiColonSeparator = true;
                boolean commaSeparator = false;
                for (String object : this.predicateToObjects.get(predicate + "_" + subject)) {
                    if (commaSeparator) {
                        sb.append(" , ");
                    }
                    sb.append(object);
                    commaSeparator = true;
                }
            }
            sb.append(" ");
            sb.append(".");
            sb.append(" ");
        }
        return sb.toString();
    }
}

