/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.pp.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.exception.DuplicateMappingException;
import it.unibz.inf.ontop.spec.mapping.MappingMetadata;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class SQLPPMappingImpl
implements SQLPPMapping {
    private final MappingMetadata mappingMetadata;
    private final ImmutableList<SQLPPTriplesMap> triplesMaps;
    private final ImmutableMap<String, SQLPPTriplesMap> mappingIndexById;

    public SQLPPMappingImpl(ImmutableList<SQLPPTriplesMap> newMappings, MappingMetadata mappingMetadata) throws DuplicateMappingException {
        SQLPPMappingImpl.checkDuplicates(newMappings);
        this.triplesMaps = newMappings;
        this.mappingMetadata = mappingMetadata;
        this.mappingIndexById = SQLPPMappingImpl.indexMappingsById(this.triplesMaps);
    }

    private static void checkDuplicates(ImmutableList<SQLPPTriplesMap> mappings) throws DuplicateMappingException {
        HashSet<SQLPPTriplesMap> mappingSet = new HashSet<SQLPPTriplesMap>((Collection<SQLPPTriplesMap>)mappings);
        int duplicateCount = mappings.size() - mappingSet.size();
        if (duplicateCount > 0) {
            HashSet<String> duplicateIds = new HashSet<String>();
            int remaining = duplicateCount;
            for (SQLPPTriplesMap mapping : mappings) {
                if (mappingSet.contains(mapping)) {
                    mappingSet.remove(mapping);
                    continue;
                }
                duplicateIds.add(mapping.getId());
                if (--remaining != 0) continue;
                break;
            }
            throw new DuplicateMappingException(String.format("Found %d duplicates in the following ids: %s", duplicateCount, ((Object)duplicateIds).toString()));
        }
    }

    private static ImmutableMap<String, SQLPPTriplesMap> indexMappingsById(ImmutableList<SQLPPTriplesMap> mappings) throws IllegalArgumentException {
        HashMap<String, SQLPPTriplesMap> mappingIndexById = new HashMap<String, SQLPPTriplesMap>();
        for (SQLPPTriplesMap axiom : mappings) {
            String id = axiom.getId();
            if (mappingIndexById.containsKey(id)) {
                throw new IllegalArgumentException(String.format("Not unique mapping ID found : %s", id));
            }
            mappingIndexById.put(id, axiom);
        }
        return ImmutableMap.copyOf(mappingIndexById);
    }

    public SQLPPMapping clone() {
        try {
            return new SQLPPMappingImpl(this.triplesMaps, this.mappingMetadata);
        }
        catch (DuplicateMappingException e) {
            throw new RuntimeException("Unexpected error (inconsistent cloning): " + e.getMessage());
        }
    }

    public MappingMetadata getMetadata() {
        return this.mappingMetadata;
    }

    @Override
    public SQLPPTriplesMap getPPMappingAxiom(String axiomId) {
        return (SQLPPTriplesMap)this.mappingIndexById.get((Object)axiomId);
    }

    public ImmutableList<SQLPPTriplesMap> getTripleMaps() {
        return this.triplesMaps;
    }
}

