/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.pp.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import it.unibz.inf.ontop.dbschema.DBMetadata;
import it.unibz.inf.ontop.dbschema.ParserViewDefinition;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RDBMetadata;
import it.unibz.inf.ontop.exception.InvalidMappingSourceQueriesException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.ProvenanceMappingFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.tools.ExecutorRegistry;
import it.unibz.inf.ontop.iq.transform.NoNullValueEnforcer;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.TargetAtom;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.spec.mapping.MappingWithProvenance;
import it.unibz.inf.ontop.spec.mapping.parser.exception.InvalidSelectQueryException;
import it.unibz.inf.ontop.spec.mapping.parser.exception.UnsupportedSelectQueryException;
import it.unibz.inf.ontop.spec.mapping.parser.impl.RAExpression;
import it.unibz.inf.ontop.spec.mapping.parser.impl.SelectQueryAttributeExtractor;
import it.unibz.inf.ontop.spec.mapping.parser.impl.SelectQueryParser;
import it.unibz.inf.ontop.spec.mapping.pp.PPMappingAssertionProvenance;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMappingConverter;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.IQ2CQ;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacySQLPPMappingConverter
implements SQLPPMappingConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegacySQLPPMappingConverter.class);
    private final TermFactory termFactory;
    private final ProvenanceMappingFactory provMappingFactory;
    private final NoNullValueEnforcer noNullValueEnforcer;
    private final IntermediateQueryFactory iqFactory;
    private final AtomFactory atomFactory;
    private final SubstitutionFactory substitutionFactory;
    private final CoreSingletons coreSingletons;

    @Inject
    private LegacySQLPPMappingConverter(TermFactory termFactory, ProvenanceMappingFactory provMappingFactory, NoNullValueEnforcer noNullValueEnforcer, IntermediateQueryFactory iqFactory, AtomFactory atomFactory, SubstitutionFactory substitutionFactory, CoreSingletons coreSingletons) {
        this.termFactory = termFactory;
        this.provMappingFactory = provMappingFactory;
        this.noNullValueEnforcer = noNullValueEnforcer;
        this.iqFactory = iqFactory;
        this.atomFactory = atomFactory;
        this.substitutionFactory = substitutionFactory;
        this.coreSingletons = coreSingletons;
    }

    public MappingWithProvenance convert(SQLPPMapping ppMapping, RDBMetadata dbMetadata, ExecutorRegistry executorRegistry) throws InvalidMappingSourceQueriesException {
        return this.provMappingFactory.create(this.convert((Collection<SQLPPTriplesMap>)ppMapping.getTripleMaps(), dbMetadata), ppMapping.getMetadata());
    }

    public ImmutableMap<IQ, PPMappingAssertionProvenance> convert(Collection<SQLPPTriplesMap> triplesMaps, RDBMetadata metadata) throws InvalidMappingSourceQueriesException {
        HashMap<IQ, PPMappingAssertionProvenance> mutableMap = new HashMap<IQ, PPMappingAssertionProvenance>();
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (SQLPPTriplesMap mappingAxiom : triplesMaps) {
            try {
                Optional filter;
                ImmutableList dataAtoms;
                ImmutableMap lookupTable;
                String sourceQuery = mappingAxiom.getSourceQuery().getSQLQuery();
                try {
                    SelectQueryParser sqp = new SelectQueryParser((DBMetadata)metadata, this.coreSingletons);
                    RAExpression re = sqp.parse(sourceQuery);
                    lookupTable = re.getAttributes();
                    dataAtoms = re.getDataAtoms();
                    filter = re.getFilterAtoms().reverse().stream().reduce((a, b) -> this.termFactory.getConjunction(b, new ImmutableExpression[]{a}));
                }
                catch (UnsupportedSelectQueryException e) {
                    ImmutableList<QuotedID> attributes = new SelectQueryAttributeExtractor((DBMetadata)metadata, this.termFactory).extract(sourceQuery);
                    ParserViewDefinition view = metadata.createParserView(sourceQuery, attributes);
                    ImmutableList list = (ImmutableList)view.getAttributes().stream().map(att -> new AbstractMap.SimpleEntry<QualifiedAttributeID, Variable>(new QualifiedAttributeID(null, att.getID()), this.termFactory.getVariable(att.getID().getName()))).collect(ImmutableCollectors.toList());
                    lookupTable = (ImmutableMap)list.stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    ImmutableList arguments = (ImmutableList)list.stream().map(Map.Entry::getValue).collect(ImmutableCollectors.toList());
                    dataAtoms = ImmutableList.of((Object)this.atomFactory.getDataAtom((AtomPredicate)view.getAtomPredicate(), arguments));
                    filter = Optional.empty();
                }
                IQTree tree = IQ2CQ.toIQTree((ImmutableList)((ImmutableList)dataAtoms.stream().map(a -> this.iqFactory.createExtensionalDataNode(a)).collect(ImmutableCollectors.toList())), filter, (IntermediateQueryFactory)this.iqFactory);
                for (TargetAtom atom : mappingAxiom.getTargetAtoms()) {
                    PPMappingAssertionProvenance provenance = mappingAxiom.getMappingAssertionProvenance(atom);
                    try {
                        ImmutableMap.Builder builder = ImmutableMap.builder();
                        ImmutableList.Builder varBuilder2 = ImmutableList.builder();
                        for (Variable v : atom.getProjectionAtom().getArguments()) {
                            ImmutableTerm t = atom.getSubstitution().get(v);
                            if (t != null) {
                                builder.put((Object)v, (Object)this.renameVariables(t, (ImmutableMap<QualifiedAttributeID, ImmutableTerm>)lookupTable, metadata.getQuotedIDFactory()));
                                varBuilder2.add((Object)v);
                                continue;
                            }
                            ImmutableTerm tt = this.renameVariables((ImmutableTerm)v, (ImmutableMap<QualifiedAttributeID, ImmutableTerm>)lookupTable, metadata.getQuotedIDFactory());
                            if (tt instanceof Variable) {
                                Variable v2 = (Variable)tt;
                                varBuilder2.add((Object)v2);
                                continue;
                            }
                            builder.put((Object)v, (Object)tt);
                            varBuilder2.add((Object)v);
                        }
                        ImmutableList varList = varBuilder2.build();
                        ImmutableSubstitution substitution = this.substitutionFactory.getSubstitution(builder.build());
                        IQ iq0 = this.iqFactory.createIQ(this.atomFactory.getDistinctVariableOnlyDataAtom(atom.getProjectionAtom().getPredicate(), varList), (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(ImmutableSet.copyOf((Collection)varList), substitution), tree));
                        IQ iq = this.noNullValueEnforcer.transform(iq0).normalizeForOptimization();
                        PPMappingAssertionProvenance previous = mutableMap.put(iq, provenance);
                        if (previous == null) continue;
                        LOGGER.warn("Redundant triples maps: \n" + provenance + "\n and \n" + previous);
                    }
                    catch (AttributeNotFoundException e) {
                        errorMessages.add("Error: " + e.getMessage() + " \nProblem location: source query of the mapping assertion \n[" + provenance.getProvenanceInfo() + "]");
                    }
                }
            }
            catch (InvalidSelectQueryException e) {
                errorMessages.add("Error: " + e.getMessage() + " \nProblem location: source query of triplesMap \n[" + mappingAxiom.getTriplesMapProvenance().getProvenanceInfo() + "]");
            }
        }
        if (!errorMessages.isEmpty()) {
            throw new InvalidMappingSourceQueriesException(Joiner.on((String)"\n\n").join(errorMessages));
        }
        LOGGER.debug("Original mapping size: {}", (Object)mutableMap.size());
        return ImmutableMap.copyOf(mutableMap);
    }

    private ImmutableTerm renameVariables(ImmutableTerm term, ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes, QuotedIDFactory idfac) throws AttributeNotFoundException {
        if (term instanceof Variable) {
            QuotedID quotedAttribute;
            Variable var = (Variable)term;
            QuotedID attribute = idfac.createAttributeID(var.getName());
            ImmutableTerm newTerm = (ImmutableTerm)attributes.get((Object)new QualifiedAttributeID(null, attribute));
            if (newTerm == null && (newTerm = (ImmutableTerm)attributes.get((Object)new QualifiedAttributeID(null, quotedAttribute = QuotedID.createIdFromDatabaseRecord((QuotedIDFactory)idfac, (String)var.getName())))) == null) {
                throw new AttributeNotFoundException("The source query does not provide the attribute " + attribute + " (variable " + var.getName() + ") required by the target atom.");
            }
            return newTerm;
        }
        if (term instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm f = (ImmutableFunctionalTerm)term;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ImmutableTerm t : f.getTerms()) {
                builder.add((Object)this.renameVariables(t, attributes, idfac));
            }
            return this.termFactory.getImmutableFunctionalTerm(f.getFunctionSymbol(), builder.build());
        }
        if (term instanceof Constant) {
            return term;
        }
        throw new RuntimeException("Unknown term type: " + term);
    }

    private static class AttributeNotFoundException
    extends Exception {
        AttributeNotFoundException(String message) {
            super(message);
        }
    }
}

