/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.DBMetadata;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.iq.IntermediateQueryBuilder;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.spec.mapping.parser.exception.IllegalJoinException;
import it.unibz.inf.ontop.spec.mapping.parser.exception.InvalidSelectQueryException;
import it.unibz.inf.ontop.spec.mapping.parser.exception.InvalidSelectQueryRuntimeException;
import it.unibz.inf.ontop.spec.mapping.parser.exception.UnsupportedSelectQueryException;
import it.unibz.inf.ontop.spec.mapping.parser.exception.UnsupportedSelectQueryRuntimeException;
import it.unibz.inf.ontop.spec.mapping.parser.impl.ExpressionParser;
import it.unibz.inf.ontop.spec.mapping.parser.impl.RAExpression;
import it.unibz.inf.ontop.spec.mapping.parser.impl.RAExpressionAttributes;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.HashMap;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.parser.TokenMgrError;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.ValuesList;

public class SelectQueryParser {
    private final DBMetadata metadata;
    private final QuotedIDFactory idfac;
    private final CoreSingletons coreSingletons;
    private final TermFactory termFactory;
    private final AtomFactory atomFactory;
    private int relationIndex = 0;

    public SelectQueryParser(DBMetadata metadata, CoreSingletons coreSingletons) {
        this.metadata = metadata;
        this.idfac = metadata.getQuotedIDFactory();
        this.coreSingletons = coreSingletons;
        this.termFactory = coreSingletons.getTermFactory();
        this.atomFactory = coreSingletons.getAtomFactory();
    }

    public RAExpression parse(String sql) throws InvalidSelectQueryException, UnsupportedSelectQueryException {
        try {
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            if (!(statement instanceof Select)) {
                throw new InvalidSelectQueryException("The query is not a SELECT statement", statement);
            }
            RAExpression re = this.select(((Select)statement).getSelectBody());
            return re;
        }
        catch (JSQLParserException e) {
            throw new UnsupportedSelectQueryException("Cannot parse SQL: " + sql, (Object)e);
        }
        catch (InvalidSelectQueryRuntimeException e) {
            throw new InvalidSelectQueryException(e.getMessage(), e.getObject());
        }
        catch (UnsupportedSelectQueryRuntimeException e) {
            throw new UnsupportedSelectQueryException(e.getMessage(), e.getObject());
        }
        catch (TokenMgrError e) {
            throw new InvalidSelectQueryException("Cannot parse SQL: " + sql, (Object)e);
        }
    }

    public RAExpression parse(String sql, IntermediateQueryBuilder queryBuilder) throws InvalidSelectQueryException, UnsupportedSelectQueryException {
        try {
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            if (!(statement instanceof Select)) {
                throw new InvalidSelectQueryException("The query is not a SELECT statement", statement);
            }
            RAExpression re = this.select(((Select)statement).getSelectBody());
            return re;
        }
        catch (JSQLParserException e) {
            throw new UnsupportedSelectQueryException("Cannot parse SQL: " + sql, (Object)e);
        }
        catch (InvalidSelectQueryRuntimeException e) {
            throw new InvalidSelectQueryException(e.getMessage(), e.getObject());
        }
        catch (UnsupportedSelectQueryRuntimeException e) {
            throw new UnsupportedSelectQueryException(e.getMessage(), e.getObject());
        }
        catch (TokenMgrError e) {
            throw new InvalidSelectQueryException("Cannot parse SQL: " + sql, (Object)e);
        }
    }

    private RAExpression select(SelectBody selectBody) {
        ImmutableMap attributes;
        if (!(selectBody instanceof PlainSelect)) {
            throw new UnsupportedSelectQueryRuntimeException("Complex SELECT statements are not supported", selectBody);
        }
        PlainSelect plainSelect = (PlainSelect)selectBody;
        if (plainSelect.getDistinct() != null) {
            throw new UnsupportedSelectQueryRuntimeException("DISTINCT is not supported", selectBody);
        }
        if (plainSelect.getGroupByColumnReferences() != null || plainSelect.getHaving() != null) {
            throw new UnsupportedSelectQueryRuntimeException("GROUP BY / HAVING are not supported", selectBody);
        }
        if (plainSelect.getLimit() != null || plainSelect.getTop() != null || plainSelect.getOffset() != null) {
            throw new UnsupportedSelectQueryRuntimeException("LIMIT / OFFSET / TOP are not supported", selectBody);
        }
        if (plainSelect.getOrderByElements() != null) {
            throw new UnsupportedSelectQueryRuntimeException("ORDER BY is not supported", selectBody);
        }
        if (plainSelect.getOracleHierarchical() != null || plainSelect.isOracleSiblings()) {
            throw new UnsupportedSelectQueryRuntimeException("Oracle START WITH ... CONNECT BY / ORDER SIBLINGS BY are not supported", selectBody);
        }
        if (plainSelect.getIntoTables() != null) {
            throw new InvalidSelectQueryRuntimeException("SELECT INTO is not allowed in mappings", selectBody);
        }
        if (plainSelect.getFromItem() == null) {
            throw new UnsupportedSelectQueryRuntimeException("SELECT without FROM is not supported", selectBody);
        }
        RAExpression current = this.getRelationalExpression(plainSelect.getFromItem());
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                try {
                    current = this.join(current, join);
                }
                catch (IllegalJoinException e) {
                    throw new InvalidSelectQueryRuntimeException(e.toString(), plainSelect);
                }
            }
        }
        ImmutableList filterAtoms = plainSelect.getWhere() == null ? current.getFilterAtoms() : ImmutableList.builder().addAll(current.getFilterAtoms()).addAll(new ExpressionParser(this.idfac, current.getAttributes(), this.coreSingletons).parseBooleanExpression(plainSelect.getWhere())).build();
        ImmutableMap.Builder attributesBuilder = ImmutableMap.builder();
        SelectItemProcessor sip = new SelectItemProcessor(current.getAttributes());
        plainSelect.getSelectItems().forEach(si -> {
            ImmutableMap<QualifiedAttributeID, ImmutableTerm> attrs = sip.getAttributes((SelectItem)si);
            attributesBuilder.putAll(attrs);
        });
        try {
            attributes = attributesBuilder.build();
        }
        catch (IllegalArgumentException e) {
            SelectItemProcessor sip2 = new SelectItemProcessor(current.getAttributes());
            HashMap duplicates = new HashMap();
            plainSelect.getSelectItems().forEach(si -> {
                ImmutableMap<QualifiedAttributeID, ImmutableTerm> attrs = sip2.getAttributes((SelectItem)si);
                for (Map.Entry a : attrs.entrySet()) {
                    duplicates.put(a.getKey(), duplicates.getOrDefault(a.getKey(), 0) + 1);
                }
            });
            throw new InvalidSelectQueryRuntimeException("Duplicate column names " + Joiner.on((String)", ").join((Iterable)duplicates.entrySet().stream().filter(d -> (Integer)d.getValue() > 1).map(d -> (QualifiedAttributeID)d.getKey()).collect(ImmutableCollectors.toList())) + " in the SELECT clause: ", selectBody);
        }
        return new RAExpression(current.getDataAtoms(), (ImmutableList<ImmutableExpression>)ImmutableList.builder().addAll((Iterable)filterAtoms).build(), new RAExpressionAttributes((ImmutableMap<QualifiedAttributeID, ImmutableTerm>)attributes, null));
    }

    private RAExpression join(RAExpression left, Join join) throws IllegalJoinException {
        if (join.isFull() || join.isRight() || join.isLeft() || join.isOuter()) {
            throw new UnsupportedSelectQueryRuntimeException("LEFT/RIGHT/FULL OUTER JOINs are not supported", join);
        }
        RAExpression right = this.getRelationalExpression(join.getRightItem());
        if (join.isSimple()) {
            return RAExpression.crossJoin(left, right);
        }
        if (join.isCross()) {
            if (join.getOnExpression() != null || join.getUsingColumns() != null) {
                throw new InvalidSelectQueryRuntimeException("CROSS JOIN cannot have USING/ON conditions", join);
            }
            if (join.isInner()) {
                throw new InvalidSelectQueryRuntimeException("CROSS INNER JOIN is not allowed", join);
            }
            return RAExpression.crossJoin(left, right);
        }
        if (join.isNatural()) {
            if (join.getOnExpression() != null || join.getUsingColumns() != null) {
                throw new InvalidSelectQueryRuntimeException("NATURAL JOIN cannot have USING/ON conditions", join);
            }
            if (join.isInner()) {
                throw new InvalidSelectQueryRuntimeException("NATURAL INNER JOIN is not allowed", join);
            }
            return RAExpression.naturalJoin(left, right, this.termFactory);
        }
        if (join.getOnExpression() != null) {
            if (join.getUsingColumns() != null) {
                throw new InvalidSelectQueryRuntimeException("JOIN cannot have both USING and ON", join);
            }
            return RAExpression.joinOn(left, right, attributes -> new ExpressionParser(this.idfac, (ImmutableMap<QualifiedAttributeID, ImmutableTerm>)attributes, this.coreSingletons).parseBooleanExpression(join.getOnExpression()));
        }
        if (join.getUsingColumns() != null) {
            return RAExpression.joinUsing(left, right, (ImmutableSet<QuotedID>)((ImmutableSet)join.getUsingColumns().stream().map(p -> this.idfac.createAttributeID(p.getColumnName())).collect(ImmutableCollectors.toSet())), this.termFactory);
        }
        throw new InvalidSelectQueryRuntimeException("[INNER] JOIN requires either ON or USING", join);
    }

    private RAExpression getRelationalExpression(FromItem fromItem) {
        return new FromItemProcessor(fromItem).result;
    }

    private class SelectItemProcessor
    implements SelectItemVisitor {
        final ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes;
        ImmutableMap<QualifiedAttributeID, ImmutableTerm> map;

        SelectItemProcessor(ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes) {
            this.attributes = attributes;
        }

        ImmutableMap<QualifiedAttributeID, ImmutableTerm> getAttributes(SelectItem si) {
            si.accept((SelectItemVisitor)this);
            return this.map;
        }

        public void visit(AllColumns allColumns) {
            this.map = (ImmutableMap)this.attributes.entrySet().stream().filter(e -> ((QualifiedAttributeID)e.getKey()).getRelation() == null).collect(ImmutableCollectors.toMap());
        }

        public void visit(AllTableColumns allTableColumns) {
            Table table = allTableColumns.getTable();
            RelationID id = SelectQueryParser.this.idfac.createRelationID(table.getSchemaName(), table.getName());
            this.map = (ImmutableMap)this.attributes.entrySet().stream().filter(e -> ((QualifiedAttributeID)e.getKey()).getRelation() != null && ((QualifiedAttributeID)e.getKey()).getRelation().equals((Object)id)).collect(ImmutableCollectors.toMap(e -> new QualifiedAttributeID(null, ((QualifiedAttributeID)e.getKey()).getAttribute()), Map.Entry::getValue));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void visit(SelectExpressionItem selectExpressionItem) {
            Expression expr = selectExpressionItem.getExpression();
            if (expr instanceof Column) {
                Column column = (Column)expr;
                QuotedID id = SelectQueryParser.this.idfac.createAttributeID(column.getColumnName());
                Table table = column.getTable();
                QualifiedAttributeID attr = table == null || table.getName() == null ? new QualifiedAttributeID(null, id) : new QualifiedAttributeID(SelectQueryParser.this.idfac.createRelationID(table.getSchemaName(), table.getName()), id);
                ImmutableTerm var = (ImmutableTerm)this.attributes.get((Object)attr);
                if (var == null) throw new InvalidSelectQueryRuntimeException("Column not found", selectExpressionItem);
                Alias columnAlias = selectExpressionItem.getAlias();
                QuotedID name = columnAlias == null || columnAlias.getName() == null ? id : SelectQueryParser.this.idfac.createAttributeID(columnAlias.getName());
                this.map = ImmutableMap.of((Object)new QualifiedAttributeID(null, name), (Object)var);
                return;
            } else {
                Alias columnAlias = selectExpressionItem.getAlias();
                if (columnAlias == null || columnAlias.getName() == null) {
                    throw new InvalidSelectQueryRuntimeException("Complex expression in SELECT must have an alias", selectExpressionItem);
                }
                QuotedID name = SelectQueryParser.this.idfac.createAttributeID(columnAlias.getName());
                ImmutableTerm term = new ExpressionParser(SelectQueryParser.this.idfac, this.attributes, SelectQueryParser.this.coreSingletons).parseTerm(expr);
                this.map = ImmutableMap.of((Object)new QualifiedAttributeID(null, name), (Object)term);
            }
        }
    }

    private class FromItemProcessor
    implements FromItemVisitor {
        private RAExpression result = null;

        FromItemProcessor(FromItem fromItem) {
            fromItem.accept((FromItemVisitor)this);
        }

        public void visit(Table tableName) {
            RelationID id = SelectQueryParser.this.idfac.createRelationID(tableName.getSchemaName(), tableName.getName());
            DatabaseRelationDefinition relation = SelectQueryParser.this.metadata.getDatabaseRelation(id);
            if (relation == null) {
                throw new InvalidSelectQueryRuntimeException("Table " + id + " not found in metadata", tableName);
            }
            SelectQueryParser.this.relationIndex++;
            RelationID alias = tableName.getAlias() != null ? SelectQueryParser.this.idfac.createRelationID(null, tableName.getAlias().getName()) : relation.getID();
            ImmutableList.Builder terms = ImmutableList.builder();
            ImmutableMap.Builder attributes = ImmutableMap.builder();
            relation.getAttributes().forEach(attribute -> {
                QuotedID attributeId = attribute.getID();
                Variable var = SelectQueryParser.this.termFactory.getVariable(attributeId.getName() + SelectQueryParser.this.relationIndex);
                terms.add((Object)var);
                attributes.put((Object)attributeId, (Object)var);
            });
            DataAtom atom = SelectQueryParser.this.atomFactory.getDataAtom((AtomPredicate)relation.getAtomPredicate(), terms.build());
            RAExpressionAttributes attrs = tableName.getAlias() == null && relation.getID().getSchemaName() != null && SelectQueryParser.this.metadata.getDatabaseRelation(relation.getID().getSchemalessID()).equals(relation) ? RAExpressionAttributes.create((ImmutableMap<QuotedID, ImmutableTerm>)attributes.build(), alias, relation.getID().getSchemalessID()) : RAExpressionAttributes.create((ImmutableMap<QuotedID, ImmutableTerm>)attributes.build(), alias);
            this.result = new RAExpression((ImmutableList<DataAtom<RelationPredicate>>)ImmutableList.of((Object)atom), (ImmutableList<ImmutableExpression>)ImmutableList.of(), attrs);
        }

        public void visit(SubSelect subSelect) {
            if (subSelect.getAlias() == null || subSelect.getAlias().getName() == null) {
                throw new InvalidSelectQueryRuntimeException("SUB-SELECT must have an alias", subSelect);
            }
            RAExpression current = SelectQueryParser.this.select(subSelect.getSelectBody());
            RelationID aliasId = SelectQueryParser.this.idfac.createRelationID(null, subSelect.getAlias().getName());
            this.result = RAExpression.alias(current, aliasId);
        }

        public void visit(SubJoin subjoin) {
            RAExpression join;
            if (subjoin.getAlias() == null || subjoin.getAlias().getName() == null) {
                throw new InvalidSelectQueryRuntimeException("SUB-JOIN must have an alias", subjoin);
            }
            RAExpression left = SelectQueryParser.this.getRelationalExpression(subjoin.getLeft());
            try {
                join = SelectQueryParser.this.join(left, subjoin.getJoin());
            }
            catch (IllegalJoinException e) {
                throw new InvalidSelectQueryRuntimeException(e.toString(), subjoin);
            }
            RelationID aliasId = SelectQueryParser.this.idfac.createRelationID(null, subjoin.getAlias().getName());
            this.result = RAExpression.alias(join, aliasId);
        }

        public void visit(LateralSubSelect lateralSubSelect) {
            throw new UnsupportedSelectQueryRuntimeException("LateralSubSelects are not supported", lateralSubSelect);
        }

        public void visit(ValuesList valuesList) {
            throw new UnsupportedSelectQueryRuntimeException("ValuesLists are not supported", valuesList);
        }

        public void visit(TableFunction tableFunction) {
            throw new UnsupportedSelectQueryRuntimeException("TableFunction are not supported", tableFunction);
        }
    }
}

