/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.DBMetadata;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.spec.mapping.parser.exception.IllegalJoinException;
import it.unibz.inf.ontop.spec.mapping.parser.exception.InvalidSelectQueryException;
import it.unibz.inf.ontop.spec.mapping.parser.exception.InvalidSelectQueryRuntimeException;
import it.unibz.inf.ontop.spec.mapping.parser.exception.UnsupportedSelectQueryException;
import it.unibz.inf.ontop.spec.mapping.parser.exception.UnsupportedSelectQueryRuntimeException;
import it.unibz.inf.ontop.spec.mapping.parser.impl.RAExpressionAttributes;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.ValuesList;

public class SelectQueryAttributeExtractor2 {
    private final DBMetadata metadata;
    private final QuotedIDFactory idfac;
    private int relationIndex = 0;
    private final TermFactory termFactory;

    public SelectQueryAttributeExtractor2(DBMetadata metadata, TermFactory termFactory) {
        this.metadata = metadata;
        this.idfac = metadata.getQuotedIDFactory();
        this.termFactory = termFactory;
    }

    public RAExpressionAttributes parse(String sql) throws InvalidSelectQueryException, UnsupportedSelectQueryException {
        PlainSelect plainSelect = this.getParsedSql(sql);
        return this.select(plainSelect);
    }

    public PlainSelect getParsedSql(String sql) throws InvalidSelectQueryException, UnsupportedSelectQueryException {
        try {
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            if (!(statement instanceof Select)) {
                throw new InvalidSelectQueryException("The query is not a SELECT statement", statement);
            }
            SelectBody selectBody = ((Select)statement).getSelectBody();
            if (!(selectBody instanceof PlainSelect)) {
                throw new UnsupportedSelectQueryException("Complex SELECT statements are not supported", selectBody);
            }
            PlainSelect plainSelect = (PlainSelect)selectBody;
            if (plainSelect.getIntoTables() != null) {
                throw new InvalidSelectQueryException("SELECT INTO is not allowed in mappings", plainSelect);
            }
            return plainSelect;
        }
        catch (JSQLParserException e) {
            throw new UnsupportedSelectQueryException("Cannot parse SQL: " + sql, (Object)e);
        }
        catch (InvalidSelectQueryRuntimeException e) {
            throw new InvalidSelectQueryException(e.getMessage(), e.getObject());
        }
    }

    public ImmutableMap<QualifiedAttributeID, ImmutableTerm> getQueryBodyAttributes(PlainSelect plainSelect) throws InvalidSelectQueryException, UnsupportedSelectQueryException {
        if (plainSelect.getFromItem() == null) {
            throw new UnsupportedSelectQueryException("SELECT without FROM is not supported", plainSelect);
        }
        try {
            RAExpressionAttributes current = this.getRelationalExpression(plainSelect.getFromItem());
            if (plainSelect.getJoins() != null) {
                for (Join join : plainSelect.getJoins()) {
                    try {
                        current = this.join(current, join);
                    }
                    catch (IllegalJoinException e) {
                        throw new InvalidSelectQueryException(e.toString(), join);
                    }
                }
            }
            return current.getAttributes();
        }
        catch (InvalidSelectQueryRuntimeException e) {
            throw new InvalidSelectQueryException(e.getMessage(), e.getObject());
        }
    }

    public ImmutableMap<QualifiedAttributeID, ImmutableTerm> expandStar(ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes) {
        return (ImmutableMap)attributes.entrySet().stream().filter(e -> ((QualifiedAttributeID)e.getKey()).getRelation() == null).collect(ImmutableCollectors.toMap());
    }

    public ImmutableMap<QualifiedAttributeID, ImmutableTerm> expandStar(ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes, Table table) {
        RelationID id = this.idfac.createRelationID(table.getSchemaName(), table.getName());
        return (ImmutableMap)attributes.entrySet().stream().filter(e -> ((QualifiedAttributeID)e.getKey()).getRelation() != null && ((QualifiedAttributeID)e.getKey()).getRelation().equals((Object)id)).collect(ImmutableCollectors.toMap(e -> new QualifiedAttributeID(null, ((QualifiedAttributeID)e.getKey()).getAttribute()), Map.Entry::getValue));
    }

    public QuotedID getSelectItemAliasedId(SelectExpressionItem si) {
        if (si.getAlias() != null && si.getAlias().getName() != null) {
            return this.idfac.createAttributeID(si.getAlias().getName());
        }
        if (si.getExpression() instanceof Column) {
            return this.idfac.createAttributeID(((Column)si.getExpression()).getColumnName());
        }
        throw new InvalidSelectQueryRuntimeException("Complex expression in SELECT must have an alias", si);
    }

    private RAExpressionAttributes select(PlainSelect plainSelect) {
        ImmutableMap attributes;
        ImmutableMap<QualifiedAttributeID, ImmutableTerm> currentAttributes;
        try {
            currentAttributes = this.getQueryBodyAttributes(plainSelect);
        }
        catch (InvalidSelectQueryException e) {
            throw new InvalidSelectQueryRuntimeException(e.getMessage(), (Object)null);
        }
        catch (UnsupportedSelectQueryException e) {
            throw new UnsupportedSelectQueryRuntimeException(e.getMessage(), (Object)null);
        }
        try {
            attributes = (ImmutableMap)plainSelect.getSelectItems().stream().map(si -> new SelectItemProcessor(currentAttributes).getAttributes((SelectItem)si).entrySet()).flatMap(Collection::stream).collect(ImmutableCollectors.toMap());
        }
        catch (IllegalArgumentException e) {
            SelectItemProcessor sip = new SelectItemProcessor(currentAttributes);
            HashMap duplicates = new HashMap();
            plainSelect.getSelectItems().forEach(si -> {
                ImmutableMap<QualifiedAttributeID, ImmutableTerm> attrs = sip.getAttributes((SelectItem)si);
                for (Map.Entry a : attrs.entrySet()) {
                    duplicates.put(a.getKey(), duplicates.getOrDefault(a.getKey(), 0) + 1);
                }
            });
            throw new InvalidSelectQueryRuntimeException("Duplicate column names " + Joiner.on((String)", ").join((Iterable)duplicates.entrySet().stream().filter(d -> (Integer)d.getValue() > 1).map(d -> (QualifiedAttributeID)d.getKey()).collect(ImmutableCollectors.toList())) + " in the SELECT clause: ", plainSelect);
        }
        return new RAExpressionAttributes((ImmutableMap<QualifiedAttributeID, ImmutableTerm>)attributes, null);
    }

    private RAExpressionAttributes join(RAExpressionAttributes left, Join join) throws IllegalJoinException {
        if (join.isFull() || join.isRight() || join.isLeft() || join.isOuter()) {
            throw new UnsupportedSelectQueryRuntimeException("LEFT/RIGHT/FULL OUTER JOINs are not supported", join);
        }
        RAExpressionAttributes right = this.getRelationalExpression(join.getRightItem());
        if (join.isSimple()) {
            return RAExpressionAttributes.crossJoin(left, right);
        }
        if (join.isCross()) {
            if (join.getOnExpression() != null || join.getUsingColumns() != null) {
                throw new InvalidSelectQueryRuntimeException("CROSS JOIN cannot have USING/ON conditions", join);
            }
            if (join.isInner()) {
                throw new InvalidSelectQueryRuntimeException("CROSS INNER JOIN is not allowed", join);
            }
            return RAExpressionAttributes.crossJoin(left, right);
        }
        if (join.isNatural()) {
            if (join.getOnExpression() != null || join.getUsingColumns() != null) {
                throw new InvalidSelectQueryRuntimeException("NATURAL JOIN cannot have USING/ON conditions", join);
            }
            if (join.isInner()) {
                throw new InvalidSelectQueryRuntimeException("NATURAL INNER JOIN is not allowed", join);
            }
            return RAExpressionAttributes.joinUsing(left, right, RAExpressionAttributes.getShared(left, right));
        }
        if (join.getOnExpression() != null) {
            if (join.getUsingColumns() != null) {
                throw new InvalidSelectQueryRuntimeException("JOIN cannot have both USING and ON", join);
            }
            return RAExpressionAttributes.crossJoin(left, right);
        }
        if (join.getUsingColumns() != null) {
            return RAExpressionAttributes.joinUsing(left, right, (ImmutableSet<QuotedID>)((ImmutableSet)join.getUsingColumns().stream().map(c -> this.idfac.createAttributeID(c.getColumnName())).collect(ImmutableCollectors.toSet())));
        }
        throw new InvalidSelectQueryRuntimeException("[INNER] JOIN requires either ON or USING", join);
    }

    private RAExpressionAttributes getRelationalExpression(FromItem fromItem) {
        return new FromItemProcessor(fromItem).result;
    }

    private Variable createVariable(QuotedID id) {
        return this.termFactory.getVariable(id.getName() + this.relationIndex);
    }

    private class SelectItemProcessor
    implements SelectItemVisitor {
        final ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes;
        ImmutableMap<QualifiedAttributeID, ImmutableTerm> map;

        SelectItemProcessor(ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes) {
            this.attributes = attributes;
        }

        ImmutableMap<QualifiedAttributeID, ImmutableTerm> getAttributes(SelectItem si) {
            si.accept((SelectItemVisitor)this);
            return this.map;
        }

        public void visit(AllColumns allColumns) {
            this.map = SelectQueryAttributeExtractor2.this.expandStar(this.attributes);
        }

        public void visit(AllTableColumns allTableColumns) {
            this.map = SelectQueryAttributeExtractor2.this.expandStar(this.attributes, allTableColumns.getTable());
        }

        public void visit(SelectExpressionItem selectExpressionItem) {
            Variable var;
            Expression expr = selectExpressionItem.getExpression();
            QuotedID name = SelectQueryAttributeExtractor2.this.getSelectItemAliasedId(selectExpressionItem);
            if (expr instanceof Column) {
                Column column = (Column)expr;
                QuotedID columnId = SelectQueryAttributeExtractor2.this.idfac.createAttributeID(column.getColumnName());
                Table table = column.getTable();
                RelationID tableId = table == null || table.getName() == null ? null : SelectQueryAttributeExtractor2.this.idfac.createRelationID(table.getSchemaName(), table.getName());
                QualifiedAttributeID attr = new QualifiedAttributeID(tableId, columnId);
                var = (ImmutableTerm)this.attributes.get((Object)attr);
                if (var == null) {
                    throw new InvalidSelectQueryRuntimeException("Column not found", selectExpressionItem);
                }
            } else {
                var = SelectQueryAttributeExtractor2.this.createVariable(name);
            }
            this.map = ImmutableMap.of((Object)new QualifiedAttributeID(null, name), (Object)var);
        }
    }

    private class FromItemProcessor
    implements FromItemVisitor {
        private RAExpressionAttributes result = null;

        public FromItemProcessor(FromItem fromItem) {
            fromItem.accept((FromItemVisitor)this);
        }

        public void visit(Table tableName) {
            RelationID id = SelectQueryAttributeExtractor2.this.idfac.createRelationID(tableName.getSchemaName(), tableName.getName());
            DatabaseRelationDefinition relation = SelectQueryAttributeExtractor2.this.metadata.getDatabaseRelation(id);
            if (relation == null) {
                throw new InvalidSelectQueryRuntimeException("Table " + id + " not found in metadata", tableName);
            }
            SelectQueryAttributeExtractor2.this.relationIndex++;
            RelationID alias = tableName.getAlias() != null ? SelectQueryAttributeExtractor2.this.idfac.createRelationID(null, tableName.getAlias().getName()) : relation.getID();
            ImmutableMap attributes = (ImmutableMap)relation.getAttributes().stream().collect(ImmutableCollectors.toMap(Attribute::getID, attribute -> SelectQueryAttributeExtractor2.this.createVariable(attribute.getID())));
            this.result = tableName.getAlias() == null && relation.getID().getSchemaName() != null && SelectQueryAttributeExtractor2.this.metadata.getDatabaseRelation(relation.getID().getSchemalessID()).equals(relation) ? RAExpressionAttributes.create((ImmutableMap<QuotedID, ImmutableTerm>)attributes, alias, relation.getID().getSchemalessID()) : RAExpressionAttributes.create((ImmutableMap<QuotedID, ImmutableTerm>)attributes, alias);
        }

        public void visit(SubSelect subSelect) {
            if (subSelect.getAlias() == null || subSelect.getAlias().getName() == null) {
                throw new InvalidSelectQueryRuntimeException("SUB-SELECT must have an alias", subSelect);
            }
            SelectQueryAttributeExtractor2.this.relationIndex++;
            SelectBody selectBody = subSelect.getSelectBody();
            if (!(selectBody instanceof PlainSelect)) {
                throw new UnsupportedSelectQueryRuntimeException("Complex SELECT statements are not supported", selectBody);
            }
            RAExpressionAttributes current = SelectQueryAttributeExtractor2.this.select((PlainSelect)selectBody);
            RelationID aliasId = SelectQueryAttributeExtractor2.this.idfac.createRelationID(null, subSelect.getAlias().getName());
            this.result = RAExpressionAttributes.alias(current, aliasId);
        }

        public void visit(SubJoin subjoin) {
            RAExpressionAttributes join;
            if (subjoin.getAlias() == null || subjoin.getAlias().getName() == null) {
                throw new InvalidSelectQueryRuntimeException("SUB-JOIN must have an alias", subjoin);
            }
            RAExpressionAttributes left = SelectQueryAttributeExtractor2.this.getRelationalExpression(subjoin.getLeft());
            try {
                join = SelectQueryAttributeExtractor2.this.join(left, subjoin.getJoin());
            }
            catch (IllegalJoinException e) {
                throw new InvalidSelectQueryRuntimeException(e.toString(), subjoin);
            }
            RelationID aliasId = SelectQueryAttributeExtractor2.this.idfac.createRelationID(null, subjoin.getAlias().getName());
            this.result = RAExpressionAttributes.alias(join, aliasId);
        }

        public void visit(LateralSubSelect lateralSubSelect) {
            throw new UnsupportedSelectQueryRuntimeException("LateralSubSelects are not supported", lateralSubSelect);
        }

        public void visit(ValuesList valuesList) {
            throw new UnsupportedSelectQueryRuntimeException("ValuesLists are not supported", valuesList);
        }

        public void visit(TableFunction tableFunction) {
            throw new UnsupportedSelectQueryRuntimeException("TableFunction are not supported", tableFunction);
        }
    }
}

