/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.DBMetadata;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.spec.mapping.parser.exception.InvalidSelectQueryException;
import it.unibz.inf.ontop.spec.mapping.parser.impl.SelectQueryAttributeExtractor2;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SelectQueryAttributeExtractor {
    private final QuotedIDFactory idfac;
    private static final Pattern AS = Pattern.compile("\\sAS\\s", 2);
    private static final Pattern BRACKETS = Pattern.compile("\\([^\\(\\)]*\\)");
    private static final Pattern COL_SEP = Pattern.compile(",");
    private static final Pattern SELECT = Pattern.compile("\\A[\\s]*SELECT\\s", 2);
    private static final Pattern FROM = Pattern.compile("\\sFROM\\s", 2);
    private final SelectQueryAttributeExtractor2 sqae;

    public SelectQueryAttributeExtractor(DBMetadata metadata, TermFactory termFactory) {
        this.idfac = metadata.getQuotedIDFactory();
        this.sqae = new SelectQueryAttributeExtractor2(metadata, termFactory);
    }

    public ImmutableList<QuotedID> extract(String sql) throws InvalidSelectQueryException {
        try {
            ImmutableMap<QualifiedAttributeID, ImmutableTerm> attrs = this.sqae.parse(sql).getAttributes();
            return (ImmutableList)attrs.keySet().stream().filter(id -> id.getRelation() == null).map(id -> id.getAttribute()).collect(ImmutableCollectors.toList());
        }
        catch (Exception e) {
            Matcher startMatcher = SELECT.matcher(sql);
            if (!startMatcher.find()) {
                throw new InvalidSelectQueryException("Error parsing SQL query: Couldn't find SELECT clause", sql);
            }
            int start = startMatcher.start() + "select".length();
            Matcher endMatcher = FROM.matcher(sql);
            if (!endMatcher.find()) {
                throw new InvalidSelectQueryException("Error parsing SQL query: Couldn't find FROM clause", sql);
            }
            int end = endMatcher.start();
            String projection = sql.substring(start, end);
            Matcher matcher = BRACKETS.matcher(projection);
            while (matcher.find()) {
                projection = matcher.replaceAll("");
                matcher = BRACKETS.matcher(projection);
            }
            ImmutableList.Builder attributes = ImmutableList.builder();
            for (String column : COL_SEP.split(projection)) {
                String[] components = AS.split(column);
                String columnName = components[components.length - 1].trim();
                columnName = columnName.substring(columnName.lastIndexOf(".") + 1);
                QuotedID attribute = this.idfac.createAttributeID(columnName);
                attributes.add((Object)attribute);
            }
            return attributes.build();
        }
    }
}

