/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.spec.mapping.parser.exception.IllegalJoinException;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class RAExpressionAttributes {
    private ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes;
    private ImmutableMap<QuotedID, ImmutableSet<RelationID>> attributeOccurrences;

    public RAExpressionAttributes(ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes, ImmutableMap<QuotedID, ImmutableSet<RelationID>> attributeOccurrences) {
        this.attributes = attributes;
        this.attributeOccurrences = attributeOccurrences;
    }

    private boolean isAbsent(QuotedID attribute) {
        ImmutableSet occurrences = (ImmutableSet)this.attributeOccurrences.get((Object)attribute);
        return occurrences == null || occurrences.isEmpty();
    }

    private boolean isAmbiguous(QuotedID attribute) {
        ImmutableSet occurrences = (ImmutableSet)this.attributeOccurrences.get((Object)attribute);
        return occurrences != null && occurrences.size() > 1;
    }

    private boolean isUnique(QuotedID attribute) {
        ImmutableSet occurrences = (ImmutableSet)this.attributeOccurrences.get((Object)attribute);
        return occurrences != null && occurrences.size() == 1;
    }

    public ImmutableMap<QualifiedAttributeID, ImmutableTerm> getAttributes() {
        return this.attributes;
    }

    public static RAExpressionAttributes crossJoin(RAExpressionAttributes re1, RAExpressionAttributes re2) throws IllegalJoinException {
        RAExpressionAttributes.checkRelationAliasesConsistency(re1, re2);
        ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes = RAExpressionAttributes.merge(re1.selectAttributes(id -> id.getRelation() != null || re2.isAbsent(id.getAttribute())), re2.selectAttributes(id -> id.getRelation() != null || re1.isAbsent(id.getAttribute())));
        return new RAExpressionAttributes(attributes, RAExpressionAttributes.getAttributeOccurrences(re1, re2, id -> RAExpressionAttributes.attributeOccurrencesUnion(id, re1, re2)));
    }

    public static ImmutableSet<QuotedID> getShared(RAExpressionAttributes re1, RAExpressionAttributes re2) {
        return (ImmutableSet)re1.attributeOccurrences.keySet().stream().filter(id -> !re1.isAbsent((QuotedID)id) && !re2.isAbsent((QuotedID)id)).collect(ImmutableCollectors.toSet());
    }

    public static RAExpressionAttributes joinUsing(RAExpressionAttributes re1, RAExpressionAttributes re2, ImmutableSet<QuotedID> using) throws IllegalJoinException {
        RAExpressionAttributes.checkRelationAliasesConsistency(re1, re2);
        if (using.stream().anyMatch(id -> !re1.isUnique((QuotedID)id) || !re2.isUnique((QuotedID)id))) {
            ImmutableList notFound = (ImmutableList)using.stream().filter(id -> re1.isAbsent((QuotedID)id) || re2.isAbsent((QuotedID)id)).collect(ImmutableCollectors.toList());
            ImmutableList ambiguous = (ImmutableList)using.stream().filter(id -> re1.isAmbiguous((QuotedID)id) || re2.isAmbiguous((QuotedID)id)).collect(ImmutableCollectors.toList());
            throw new IllegalJoinException(re1, re2, (!notFound.isEmpty() ? "Attribute(s) " + notFound + " cannot be found" : "") + (!notFound.isEmpty() && !ambiguous.isEmpty() ? ", " : "") + (!ambiguous.isEmpty() ? "Attribute(s) " + ambiguous + " are ambiguous" : ""));
        }
        ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes = RAExpressionAttributes.merge(re1.selectAttributes(id -> id.getRelation() != null && !using.contains((Object)id.getAttribute()) || id.getRelation() == null && re2.isAbsent(id.getAttribute()) || id.getRelation() == null && using.contains((Object)id.getAttribute())), re2.selectAttributes(id -> id.getRelation() != null && !using.contains((Object)id.getAttribute()) || id.getRelation() == null && re1.isAbsent(id.getAttribute())));
        ImmutableMap<QuotedID, ImmutableSet<RelationID>> attributeOccurrences = RAExpressionAttributes.getAttributeOccurrences(re1, re2, id -> using.contains(id) ? (ImmutableSet)re1.attributeOccurrences.get(id) : RAExpressionAttributes.attributeOccurrencesUnion(id, re1, re2));
        return new RAExpressionAttributes(attributes, attributeOccurrences);
    }

    public static RAExpressionAttributes create(ImmutableMap<QuotedID, ImmutableTerm> unqualifiedAttributes, RelationID alias) {
        ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes = RAExpressionAttributes.merge((ImmutableMap<QualifiedAttributeID, ImmutableTerm>)((ImmutableMap)unqualifiedAttributes.entrySet().stream().collect(ImmutableCollectors.toMap(e -> new QualifiedAttributeID(alias, (QuotedID)e.getKey()), Map.Entry::getValue))), (ImmutableMap<QualifiedAttributeID, ImmutableTerm>)((ImmutableMap)unqualifiedAttributes.entrySet().stream().collect(ImmutableCollectors.toMap(e -> new QualifiedAttributeID(null, (QuotedID)e.getKey()), Map.Entry::getValue))));
        ImmutableMap attributeOccurrences = (ImmutableMap)unqualifiedAttributes.keySet().stream().collect(ImmutableCollectors.toMap(Function.identity(), id -> ImmutableSet.of((Object)alias)));
        return new RAExpressionAttributes(attributes, (ImmutableMap<QuotedID, ImmutableSet<RelationID>>)attributeOccurrences);
    }

    public static RAExpressionAttributes create(ImmutableMap<QuotedID, ImmutableTerm> unqualifiedAttributes, RelationID alias, RelationID schemalessId) {
        ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes = RAExpressionAttributes.merge((ImmutableMap<QualifiedAttributeID, ImmutableTerm>)((ImmutableMap)unqualifiedAttributes.entrySet().stream().collect(ImmutableCollectors.toMap(e -> new QualifiedAttributeID(alias, (QuotedID)e.getKey()), Map.Entry::getValue))), (ImmutableMap<QualifiedAttributeID, ImmutableTerm>)((ImmutableMap)unqualifiedAttributes.entrySet().stream().collect(ImmutableCollectors.toMap(e -> new QualifiedAttributeID(schemalessId, (QuotedID)e.getKey()), Map.Entry::getValue))), (ImmutableMap<QualifiedAttributeID, ImmutableTerm>)((ImmutableMap)unqualifiedAttributes.entrySet().stream().collect(ImmutableCollectors.toMap(e -> new QualifiedAttributeID(null, (QuotedID)e.getKey()), Map.Entry::getValue))));
        ImmutableMap attributeOccurrences = (ImmutableMap)unqualifiedAttributes.keySet().stream().collect(ImmutableCollectors.toMap(Function.identity(), id -> ImmutableSet.of((Object)alias)));
        return new RAExpressionAttributes(attributes, (ImmutableMap<QuotedID, ImmutableSet<RelationID>>)attributeOccurrences);
    }

    public static RAExpressionAttributes alias(RAExpressionAttributes re, RelationID alias) {
        ImmutableMap unqualifiedAttributes = (ImmutableMap)re.attributes.entrySet().stream().filter(e -> ((QualifiedAttributeID)e.getKey()).getRelation() == null).collect(ImmutableCollectors.toMap(e -> ((QualifiedAttributeID)e.getKey()).getAttribute(), Map.Entry::getValue));
        return RAExpressionAttributes.create((ImmutableMap<QuotedID, ImmutableTerm>)unqualifiedAttributes, alias);
    }

    private static ImmutableMap<QualifiedAttributeID, ImmutableTerm> merge(ImmutableMap<QualifiedAttributeID, ImmutableTerm> attrs1, ImmutableMap<QualifiedAttributeID, ImmutableTerm> attrs2) {
        return ImmutableMap.builder().putAll(attrs1).putAll(attrs2).build();
    }

    private static ImmutableMap<QualifiedAttributeID, ImmutableTerm> merge(ImmutableMap<QualifiedAttributeID, ImmutableTerm> attrs1, ImmutableMap<QualifiedAttributeID, ImmutableTerm> attrs2, ImmutableMap<QualifiedAttributeID, ImmutableTerm> attrs3) {
        return ImmutableMap.builder().putAll(attrs1).putAll(attrs2).putAll(attrs3).build();
    }

    private static ImmutableSet<RelationID> attributeOccurrencesUnion(QuotedID id, RAExpressionAttributes re1, RAExpressionAttributes re2) {
        ImmutableSet s1 = (ImmutableSet)re1.attributeOccurrences.get((Object)id);
        ImmutableSet s2 = (ImmutableSet)re2.attributeOccurrences.get((Object)id);
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        return ImmutableSet.builder().addAll((Iterable)s1).addAll((Iterable)s2).build();
    }

    private ImmutableMap<QualifiedAttributeID, ImmutableTerm> selectAttributes(Predicate<QualifiedAttributeID> condition) {
        return (ImmutableMap)this.attributes.entrySet().stream().filter(e -> condition.test((QualifiedAttributeID)e.getKey())).collect(ImmutableCollectors.toMap());
    }

    private static ImmutableMap<QuotedID, ImmutableSet<RelationID>> getAttributeOccurrences(RAExpressionAttributes re1, RAExpressionAttributes re2, Function<QuotedID, ImmutableSet<RelationID>> collector) {
        ImmutableSet keys = ImmutableSet.builder().addAll((Iterable)re1.attributeOccurrences.keySet()).addAll((Iterable)re2.attributeOccurrences.keySet()).build();
        return (ImmutableMap)keys.stream().collect(ImmutableCollectors.toMap(Function.identity(), collector));
    }

    private static void checkRelationAliasesConsistency(RAExpressionAttributes re1, RAExpressionAttributes re2) throws IllegalJoinException {
        ImmutableSet alias1 = (ImmutableSet)re1.attributes.keySet().stream().filter(id -> id.getRelation() != null).map(QualifiedAttributeID::getRelation).collect(ImmutableCollectors.toSet());
        ImmutableSet alias2 = (ImmutableSet)re2.attributes.keySet().stream().filter(id -> id.getRelation() != null).map(QualifiedAttributeID::getRelation).collect(ImmutableCollectors.toSet());
        if (alias1.stream().anyMatch(arg_0 -> ((ImmutableSet)alias2).contains(arg_0))) {
            throw new IllegalJoinException(re1, re2, "Relation alias " + alias1.stream().filter(arg_0 -> ((ImmutableSet)alias2).contains(arg_0)).collect(ImmutableCollectors.toList()) + " occurs in both arguments of the JOIN");
        }
    }

    public String toString() {
        return "attributes: " + this.attributes + " with " + this.attributeOccurrences;
    }
}

