/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.spec.mapping.parser.exception.IllegalJoinException;
import it.unibz.inf.ontop.spec.mapping.parser.impl.RAExpressionAttributes;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.function.Function;

public class RAExpression {
    private ImmutableList<DataAtom<RelationPredicate>> dataAtoms;
    private ImmutableList<ImmutableExpression> filterAtoms;
    private RAExpressionAttributes attributes;

    public RAExpression(ImmutableList<DataAtom<RelationPredicate>> dataAtoms, ImmutableList<ImmutableExpression> filterAtoms, RAExpressionAttributes attributes) {
        this.dataAtoms = dataAtoms;
        this.filterAtoms = filterAtoms;
        this.attributes = attributes;
    }

    public ImmutableList<DataAtom<RelationPredicate>> getDataAtoms() {
        return this.dataAtoms;
    }

    public ImmutableList<ImmutableExpression> getFilterAtoms() {
        return this.filterAtoms;
    }

    public ImmutableMap<QualifiedAttributeID, ImmutableTerm> getAttributes() {
        return this.attributes.getAttributes();
    }

    public static RAExpression crossJoin(RAExpression re1, RAExpression re2) throws IllegalJoinException {
        RAExpressionAttributes attributes = RAExpressionAttributes.crossJoin(re1.attributes, re2.attributes);
        return new RAExpression(RAExpression.union(re1.dataAtoms, re2.dataAtoms), RAExpression.union(re1.filterAtoms, re2.filterAtoms), attributes);
    }

    public static RAExpression joinOn(RAExpression re1, RAExpression re2, Function<ImmutableMap<QualifiedAttributeID, ImmutableTerm>, ImmutableList<ImmutableExpression>> getAtomOnExpression) throws IllegalJoinException {
        RAExpressionAttributes attributes = RAExpressionAttributes.crossJoin(re1.attributes, re2.attributes);
        return new RAExpression(RAExpression.union(re1.dataAtoms, re2.dataAtoms), RAExpression.union(re1.filterAtoms, re2.filterAtoms, getAtomOnExpression.apply(attributes.getAttributes())), attributes);
    }

    public static RAExpression naturalJoin(RAExpression re1, RAExpression re2, TermFactory termFactory) throws IllegalJoinException {
        ImmutableSet<QuotedID> shared = RAExpressionAttributes.getShared(re1.attributes, re2.attributes);
        RAExpressionAttributes attributes = RAExpressionAttributes.joinUsing(re1.attributes, re2.attributes, shared);
        return new RAExpression(RAExpression.union(re1.dataAtoms, re2.dataAtoms), RAExpression.union(re1.filterAtoms, re2.filterAtoms, RAExpression.getJoinOnFilter(re1.attributes, re2.attributes, shared, termFactory)), attributes);
    }

    public static RAExpression joinUsing(RAExpression re1, RAExpression re2, ImmutableSet<QuotedID> using, TermFactory termFactory) throws IllegalJoinException {
        RAExpressionAttributes attributes = RAExpressionAttributes.joinUsing(re1.attributes, re2.attributes, using);
        return new RAExpression(RAExpression.union(re1.dataAtoms, re2.dataAtoms), RAExpression.union(re1.filterAtoms, re2.filterAtoms, RAExpression.getJoinOnFilter(re1.attributes, re2.attributes, using, termFactory)), attributes);
    }

    private static ImmutableList<ImmutableExpression> getJoinOnFilter(RAExpressionAttributes re1, RAExpressionAttributes re2, ImmutableSet<QuotedID> using, TermFactory termFactory) {
        return (ImmutableList)using.stream().map(id -> new QualifiedAttributeID(null, id)).map(id -> {
            ImmutableTerm v1 = (ImmutableTerm)re1.getAttributes().get(id);
            if (v1 == null) {
                throw new IllegalArgumentException("Term " + id + " not found in " + re1);
            }
            ImmutableTerm v2 = (ImmutableTerm)re2.getAttributes().get(id);
            if (v2 == null) {
                throw new IllegalArgumentException("Term " + id + " not found in " + re2);
            }
            return termFactory.getNotYetTypedEquality(v1, v2);
        }).collect(ImmutableCollectors.toList());
    }

    public static RAExpression alias(RAExpression re, RelationID alias) {
        return new RAExpression(re.dataAtoms, re.filterAtoms, RAExpressionAttributes.alias(re.attributes, alias));
    }

    private static <T> ImmutableList<T> union(ImmutableList<T> atoms1, ImmutableList<T> atoms2) {
        return ImmutableList.builder().addAll(atoms1).addAll(atoms2).build();
    }

    private static <T> ImmutableList<T> union(ImmutableList<T> atoms1, ImmutableList<T> atoms2, ImmutableList<T> atoms3) {
        return ImmutableList.builder().addAll(atoms1).addAll(atoms2).addAll(atoms3).build();
    }

    public String toString() {
        return "RAExpression : " + this.dataAtoms + " FILTER " + this.filterAtoms + " with " + this.attributes;
    }
}

