/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.InequalityLabel;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBNotFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.spec.mapping.parser.exception.InvalidSelectQueryRuntimeException;
import it.unibz.inf.ontop.spec.mapping.parser.exception.UnsupportedSelectQueryRuntimeException;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.sf.jsqlparser.expression.AllComparisonExpression;
import net.sf.jsqlparser.expression.AnalyticExpression;
import net.sf.jsqlparser.expression.AnyComparisonExpression;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExtractExpression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.IntervalExpression;
import net.sf.jsqlparser.expression.JdbcNamedParameter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.JsonExpression;
import net.sf.jsqlparser.expression.KeepExpression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.MySQLGroupConcat;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.NumericBind;
import net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import net.sf.jsqlparser.expression.OracleHint;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.UserVariable;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.WithinGroupExpression;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.Matches;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.expression.operators.relational.OldOracleJoinBinaryExpression;
import net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import net.sf.jsqlparser.expression.operators.relational.RegExpMySQLOperator;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.create.table.ColDataType;
import net.sf.jsqlparser.statement.select.SubSelect;

public class ExpressionParser {
    private final QuotedIDFactory idfac;
    private final ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes;
    private final TermFactory termFactory;
    private final DBTypeFactory dbTypeFactory;
    private final DBFunctionSymbolFactory dbFunctionSymbolFactory;
    private final ImmutableMap<String, BiFunction<ImmutableList<ImmutableTerm>, Function, ImmutableFunctionalTerm>> FUNCTIONS = ImmutableMap.builder().put((Object)"RAND", this::get_RAND).put((Object)"CONVERT", this::reject).put((Object)"COUNT", this::reject).put((Object)"UNNEST", this::reject).put((Object)"JSON_EACH", this::reject).put((Object)"JSON_EACH_TEXT", this::reject).put((Object)"JSON_OBJECT_KEYS", this::reject).put((Object)"JSON_POPULATE_RECORDSET", this::reject).put((Object)"JSON_ARRAY_ELEMENTS", this::reject).build();

    public ExpressionParser(QuotedIDFactory idfac, ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes, CoreSingletons coreSingletons) {
        this.idfac = idfac;
        this.attributes = attributes;
        this.termFactory = coreSingletons.getTermFactory();
        this.dbTypeFactory = coreSingletons.getTypeFactory().getDBTypeFactory();
        this.dbFunctionSymbolFactory = coreSingletons.getDBFunctionsymbolFactory();
    }

    public ImmutableTerm parseTerm(Expression expression) {
        TermVisitor visitor = new TermVisitor(this.attributes);
        return visitor.getTerm(expression);
    }

    public ImmutableList<ImmutableExpression> parseBooleanExpression(Expression expression) {
        BooleanExpressionVisitor parser = new BooleanExpressionVisitor(this.attributes);
        return parser.translate(expression);
    }

    private ImmutableFunctionalTerm get_RAND(ImmutableList<ImmutableTerm> terms, Function expression) {
        switch (terms.size()) {
            case 0: {
                return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBRand(UUID.randomUUID()), new ImmutableTerm[0]);
            }
        }
        throw new UnsupportedSelectQueryRuntimeException("Unsupported SQL function", expression);
    }

    private ImmutableFunctionalTerm reject(ImmutableList<ImmutableTerm> terms, Function expression) {
        throw new UnsupportedSelectQueryRuntimeException("Unsupported SQL function", expression);
    }

    private class TermVisitor
    implements ExpressionVisitor {
        private final ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes;
        private ImmutableTerm result;

        TermVisitor(ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes) {
            this.attributes = attributes;
        }

        ImmutableTerm getTerm(Expression expression) {
            expression.accept((ExpressionVisitor)this);
            return this.result;
        }

        public void visit(Function expression) {
            ImmutableList terms = expression.getParameters() != null ? ImmutableList.builder().addAll(expression.getParameters().getExpressions().stream().map(t -> this.getTerm((Expression)t)).iterator()).build() : ImmutableList.of();
            BiFunction function = (BiFunction)ExpressionParser.this.FUNCTIONS.get((Object)expression.getName().toUpperCase());
            this.result = function == null ? this.convertFunction(expression, (ImmutableList<ImmutableTerm>)terms) : (ImmutableTerm)function.apply(terms, expression);
        }

        private ImmutableTerm convertFunction(Function expression, ImmutableList<ImmutableTerm> terms) {
            DBFunctionSymbol functionSymbol = ExpressionParser.this.dbFunctionSymbolFactory.getRegularDBFunctionSymbol(expression.getName(), terms.size());
            return ExpressionParser.this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)functionSymbol, terms);
        }

        public void visit(NullValue expression) {
            throw new UnsupportedSelectQueryRuntimeException("NULL is not supported", expression);
        }

        public void visit(DoubleValue expression) {
            this.process(expression.toString(), ExpressionParser.this.dbTypeFactory.getDBDoubleType());
        }

        public void visit(LongValue expression) {
            this.process(expression.getStringValue(), ExpressionParser.this.dbTypeFactory.getDBLargeIntegerType());
        }

        public void visit(HexValue expression) {
            throw new UnsupportedSelectQueryRuntimeException("HEX is not supported", expression);
        }

        public void visit(StringValue expression) {
            this.process(expression.getValue(), ExpressionParser.this.dbTypeFactory.getDBStringType());
        }

        public void visit(DateValue expression) {
            this.process(expression.getValue().toString(), ExpressionParser.this.dbTypeFactory.getDBDateType());
        }

        public void visit(TimeValue expression) {
            this.process(expression.getValue().toString(), ExpressionParser.this.dbTypeFactory.getDBTimeType());
        }

        public void visit(TimestampValue expression) {
            this.process(expression.getValue().toString(), ExpressionParser.this.dbTypeFactory.getDBDateTimestampType());
        }

        public void visit(IntervalExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Temporal INTERVALs are not supported yet", expression);
        }

        private void process(String value, DBTermType termType) {
            this.result = ExpressionParser.this.termFactory.getDBConstant(value, termType);
        }

        public void visit(Addition expression) {
            this.process((BinaryExpression)expression, (t1, t2) -> ExpressionParser.this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)ExpressionParser.this.dbFunctionSymbolFactory.getUntypedDBMathBinaryOperator("+"), new ImmutableTerm[]{t1, t2}));
        }

        public void visit(Subtraction expression) {
            this.process((BinaryExpression)expression, (t1, t2) -> ExpressionParser.this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)ExpressionParser.this.dbFunctionSymbolFactory.getUntypedDBMathBinaryOperator("-"), new ImmutableTerm[]{t1, t2}));
        }

        public void visit(Multiplication expression) {
            this.process((BinaryExpression)expression, (t1, t2) -> ExpressionParser.this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)ExpressionParser.this.dbFunctionSymbolFactory.getUntypedDBMathBinaryOperator("*"), new ImmutableTerm[]{t1, t2}));
        }

        public void visit(Division expression) {
            this.process((BinaryExpression)expression, (t1, t2) -> ExpressionParser.this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)ExpressionParser.this.dbFunctionSymbolFactory.getUntypedDBMathBinaryOperator("/"), new ImmutableTerm[]{t1, t2}));
        }

        public void visit(Modulo expression) {
            throw new UnsupportedSelectQueryRuntimeException("MODULO is not supported yet", expression);
        }

        public void visit(Concat expression) {
            this.process((BinaryExpression)expression, (t1, t2) -> ExpressionParser.this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)ExpressionParser.this.dbFunctionSymbolFactory.getDBConcatOperator(2), new ImmutableTerm[]{t1, t2}));
        }

        private void process(BinaryExpression expression, BinaryOperator<ImmutableTerm> op) {
            if (expression.isNot()) {
                throw new UnsupportedSelectQueryRuntimeException("Not a term", expression);
            }
            ImmutableTerm leftTerm = this.getTerm(expression.getLeftExpression());
            ImmutableTerm rightTerm = this.getTerm(expression.getRightExpression());
            this.result = (ImmutableTerm)op.apply(leftTerm, rightTerm);
        }

        public void visit(IsNullExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a term", expression);
        }

        public void visit(Parenthesis expression) {
            if (expression.isNot()) {
                throw new UnsupportedSelectQueryRuntimeException("Not a term", expression);
            }
            this.result = this.getTerm(expression.getExpression());
        }

        public void visit(SignedExpression expression) {
            ImmutableTerm arg = this.getTerm(expression.getExpression());
            switch (expression.getSign()) {
                case '-': {
                    this.result = ExpressionParser.this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)ExpressionParser.this.dbFunctionSymbolFactory.getUntypedDBMathBinaryOperator("*"), new ImmutableTerm[]{ExpressionParser.this.termFactory.getDBConstant("-1", ExpressionParser.this.dbTypeFactory.getDBLargeIntegerType()), arg});
                    break;
                }
                case '+': {
                    this.result = arg;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        public void visit(ExtractExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("EXTRACT is not supported yet", expression);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void visit(Column expression) {
            QuotedID column = ExpressionParser.this.idfac.createAttributeID(expression.getColumnName());
            Table table = expression.getTable();
            RelationID relation = table != null && table.getName() != null ? ExpressionParser.this.idfac.createRelationID(table.getSchemaName(), table.getName()) : null;
            QualifiedAttributeID qa = new QualifiedAttributeID(relation, column);
            ImmutableTerm var = (ImmutableTerm)this.attributes.get((Object)qa);
            if (var == null) {
                if (column.equals((Object)ExpressionParser.this.idfac.createAttributeID("true"))) {
                    this.result = ExpressionParser.this.termFactory.getDBBooleanConstant(true);
                    return;
                } else {
                    if (!column.equals((Object)ExpressionParser.this.idfac.createAttributeID("false"))) throw new UnsupportedSelectQueryRuntimeException("Unable to find attribute name ", expression);
                    this.result = ExpressionParser.this.termFactory.getDBBooleanConstant(false);
                }
                return;
            } else {
                this.result = var;
            }
        }

        public void visit(EqualsTo expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a term", expression);
        }

        public void visit(GreaterThan expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a term", expression);
        }

        public void visit(GreaterThanEquals expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a term", expression);
        }

        public void visit(MinorThan expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a term", expression);
        }

        public void visit(MinorThanEquals expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a term", expression);
        }

        public void visit(NotEqualsTo expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a term", expression);
        }

        public void visit(LikeExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a term", expression);
        }

        public void visit(RegExpMySQLOperator expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a term", expression);
        }

        public void visit(UserVariable expression) {
            throw new UnsupportedSelectQueryRuntimeException("User variables are not supported yet", expression);
        }

        public void visit(NumericBind expression) {
            throw new UnsupportedSelectQueryRuntimeException("NumericBind is not supported yet", expression);
        }

        public void visit(KeepExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Keep Expression is not supported yet", expression);
        }

        public void visit(MySQLGroupConcat expression) {
            throw new UnsupportedSelectQueryRuntimeException("MySQLGroupConcat is not supported yet", expression);
        }

        public void visit(RowConstructor expression) {
            throw new UnsupportedSelectQueryRuntimeException("RowConstructor is not supported yet", expression);
        }

        public void visit(OracleHint expression) {
            throw new UnsupportedSelectQueryRuntimeException("OracleHint is not supported yet", expression);
        }

        public void visit(TimeKeyExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("TimeKeyExpression is not supported yet", expression);
        }

        public void visit(DateTimeLiteralExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("DateTimeLiteralExpression is not supported yet", expression);
        }

        public void visit(NotExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a term", expression);
        }

        public void visit(RegExpMatchOperator expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a term", expression);
        }

        public void visit(AndExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a term", expression);
        }

        public void visit(OrExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a term", expression);
        }

        public void visit(Between expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a term", expression);
        }

        public void visit(InExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a term", expression);
        }

        public void visit(CaseExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("CASE is not supported yet", expression);
        }

        public void visit(WhenClause expression) {
            throw new UnsupportedSelectQueryRuntimeException("CASE/WHEN is not supported yet", expression);
        }

        public void visit(CastExpression expression) {
            ImmutableTerm term = this.getTerm(expression.getLeftExpression());
            ColDataType type = expression.getType();
            String datatype = type.getDataType();
            throw new UnsupportedSelectQueryRuntimeException("CAST is not supported yet", expression);
        }

        public void visit(SubSelect expression) {
            throw new UnsupportedSelectQueryRuntimeException("SubSelect is not supported yet", expression);
        }

        public void visit(ExistsExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("EXISTS is not supported yet", expression);
        }

        public void visit(AllComparisonExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("ALL is not supported yet", expression);
        }

        public void visit(AnyComparisonExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("ANY is not supported yet", expression);
        }

        public void visit(BitwiseAnd expression) {
            throw new UnsupportedSelectQueryRuntimeException("Bitwise AND is not supported", expression);
        }

        public void visit(BitwiseOr expression) {
            throw new UnsupportedSelectQueryRuntimeException("Bitwise OR is not supported", expression);
        }

        public void visit(BitwiseXor expression) {
            throw new UnsupportedSelectQueryRuntimeException("Bitwise XOR is not supported", expression);
        }

        public void visit(AnalyticExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Analytic expressions is not supported", expression);
        }

        public void visit(WithinGroupExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("WithinGroup expressions is not supported", expression);
        }

        public void visit(OracleHierarchicalExpression expression) {
            throw new UnsupportedOperationException("Unexpected Oracle START WITH ... CONNECT BY");
        }

        public void visit(Matches expression) {
            throw new UnsupportedSelectQueryRuntimeException("Oracle @@ not supported", expression);
        }

        public void visit(JsonExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("JSON expressions are not supported", expression);
        }

        public void visit(JsonOperator expression) {
            throw new UnsupportedSelectQueryRuntimeException("JSON operators are not supported", expression);
        }

        public void visit(JdbcParameter expression) {
            throw new InvalidSelectQueryRuntimeException("JDBC parameters are not allowed", expression);
        }

        public void visit(JdbcNamedParameter expression) {
            throw new InvalidSelectQueryRuntimeException("JDBC named parameters are not allowed", expression);
        }
    }

    private class BooleanExpressionVisitor
    implements ExpressionVisitor {
        private final TermVisitor termVisitor;
        private ImmutableList<ImmutableExpression> result;

        BooleanExpressionVisitor(ImmutableMap<QualifiedAttributeID, ImmutableTerm> attributes) {
            this.termVisitor = new TermVisitor(attributes);
        }

        private ImmutableList<ImmutableExpression> translate(Expression expression) {
            expression.accept((ExpressionVisitor)this);
            return this.result;
        }

        private ImmutableExpression negation(ImmutableExpression arg) {
            return arg.getFunctionSymbol() instanceof DBNotFunctionSymbol ? (ImmutableExpression)arg.getTerm(0) : ExpressionParser.this.termFactory.getDBNot(arg);
        }

        private java.util.function.Function<ImmutableExpression, ImmutableList<ImmutableExpression>> notOperation(boolean isNot) {
            return isNot ? arg -> ImmutableList.of((Object)this.negation((ImmutableExpression)arg)) : arg -> ImmutableList.of((Object)arg);
        }

        private void process(BinaryExpression expression, BiFunction<ImmutableTerm, ImmutableTerm, ImmutableExpression> op) {
            ImmutableTerm leftTerm = this.termVisitor.getTerm(expression.getLeftExpression());
            ImmutableTerm rightTerm = this.termVisitor.getTerm(expression.getRightExpression());
            ImmutableExpression f = op.apply(leftTerm, rightTerm);
            this.result = this.notOperation(expression.isNot()).apply(f);
        }

        private void processOJ(OldOracleJoinBinaryExpression expression, BiFunction<ImmutableTerm, ImmutableTerm, ImmutableExpression> op) {
            if (expression.getOraclePriorPosition() != 0) {
                throw new UnsupportedSelectQueryRuntimeException("Oracle PRIOR is not supported", expression);
            }
            if (expression.getOldOracleJoinSyntax() != 0) {
                throw new UnsupportedSelectQueryRuntimeException("Old Oracle OUTER JOIN syntax is not supported", expression);
            }
            this.process((BinaryExpression)expression, op);
        }

        private ImmutableExpression getOR(ImmutableList<ImmutableExpression> list) {
            return list.reverse().stream().reduce(null, (a, b) -> a == null ? b : ExpressionParser.this.termFactory.getDisjunction(b, new ImmutableExpression[]{a}));
        }

        private ImmutableExpression getAND(ImmutableList<ImmutableExpression> list) {
            return list.reverse().stream().reduce(null, (a, b) -> a == null ? b : ExpressionParser.this.termFactory.getConjunction(b, new ImmutableExpression[]{a}));
        }

        public void visit(AndExpression expression) {
            ImmutableList<ImmutableExpression> left = this.translate(expression.getLeftExpression());
            ImmutableList<ImmutableExpression> right = this.translate(expression.getRightExpression());
            ImmutableList and = (ImmutableList)Stream.of(left, right).flatMap(Collection::stream).collect(ImmutableCollectors.toList());
            this.result = expression.isNot() ? ImmutableList.of((Object)this.negation(this.getAND((ImmutableList<ImmutableExpression>)and))) : and;
        }

        public void visit(OrExpression expression) {
            ImmutableExpression left = this.getAND(this.translate(expression.getLeftExpression()));
            ImmutableExpression right = this.getAND(this.translate(expression.getRightExpression()));
            this.result = expression.isNot() ? ImmutableList.of((Object)this.negation(left), (Object)this.negation(right)) : ImmutableList.of((Object)ExpressionParser.this.termFactory.getDisjunction(left, new ImmutableExpression[]{right}));
        }

        public void visit(Parenthesis expression) {
            ImmutableList arg = this.translate(expression.getExpression());
            this.result = expression.isNot() ? ImmutableList.of((Object)this.negation(this.getAND(arg))) : arg;
        }

        public void visit(IsNullExpression expression) {
            ImmutableTerm term = this.termVisitor.getTerm(expression.getLeftExpression());
            this.result = this.notOperation(expression.isNot()).apply(ExpressionParser.this.termFactory.getDBIsNull(term));
        }

        public void visit(EqualsTo expression) {
            this.processOJ((OldOracleJoinBinaryExpression)expression, (t1, t2) -> ExpressionParser.this.termFactory.getNotYetTypedEquality(t1, t2));
        }

        public void visit(GreaterThan expression) {
            this.processOJ((OldOracleJoinBinaryExpression)expression, (t1, t2) -> ExpressionParser.this.termFactory.getDBDefaultInequality(InequalityLabel.GT, t1, t2));
        }

        public void visit(GreaterThanEquals expression) {
            this.processOJ((OldOracleJoinBinaryExpression)expression, (t1, t2) -> ExpressionParser.this.termFactory.getDBDefaultInequality(InequalityLabel.GTE, t1, t2));
        }

        public void visit(MinorThan expression) {
            this.processOJ((OldOracleJoinBinaryExpression)expression, (t1, t2) -> ExpressionParser.this.termFactory.getDBDefaultInequality(InequalityLabel.LT, t1, t2));
        }

        public void visit(MinorThanEquals expression) {
            this.processOJ((OldOracleJoinBinaryExpression)expression, (t1, t2) -> ExpressionParser.this.termFactory.getDBDefaultInequality(InequalityLabel.LTE, t1, t2));
        }

        public void visit(NotEqualsTo expression) {
            this.processOJ((OldOracleJoinBinaryExpression)expression, (t1, t2) -> ExpressionParser.this.termFactory.getDBNot(ExpressionParser.this.termFactory.getNotYetTypedEquality(t1, t2)));
        }

        public void visit(LikeExpression expression) {
            this.process((BinaryExpression)expression, (t1, t2) -> ExpressionParser.this.termFactory.getImmutableExpression((BooleanFunctionSymbol)ExpressionParser.this.dbFunctionSymbolFactory.getDBLike(), new ImmutableTerm[]{t1, t2}));
        }

        public void visit(RegExpMySQLOperator expression) {
            DBConstant flags;
            switch (expression.getOperatorType()) {
                case MATCH_CASESENSITIVE: {
                    flags = ExpressionParser.this.termFactory.getDBStringConstant("");
                    break;
                }
                case MATCH_CASEINSENSITIVE: {
                    flags = ExpressionParser.this.termFactory.getDBStringConstant("i");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            this.process((BinaryExpression)expression, (t1, t2) -> flags.getValue().isEmpty() ? ExpressionParser.this.termFactory.getDBRegexpMatches(ImmutableList.of((Object)t1, (Object)t2)) : ExpressionParser.this.termFactory.getDBRegexpMatches(ImmutableList.of((Object)t1, (Object)t2, (Object)flags)));
        }

        public void visit(RegExpMatchOperator expression) {
            UnaryOperator not;
            DBConstant flags;
            switch (expression.getOperatorType()) {
                case MATCH_CASESENSITIVE: {
                    flags = ExpressionParser.this.termFactory.getDBStringConstant("");
                    not = UnaryOperator.identity();
                    break;
                }
                case MATCH_CASEINSENSITIVE: {
                    flags = ExpressionParser.this.termFactory.getDBStringConstant("i");
                    not = UnaryOperator.identity();
                    break;
                }
                case NOT_MATCH_CASESENSITIVE: {
                    flags = ExpressionParser.this.termFactory.getDBStringConstant("");
                    not = arg_0 -> ((TermFactory)ExpressionParser.this.termFactory).getDBNot(arg_0);
                    break;
                }
                case NOT_MATCH_CASEINSENSITIVE: {
                    flags = ExpressionParser.this.termFactory.getDBStringConstant("i");
                    not = arg_0 -> ((TermFactory)ExpressionParser.this.termFactory).getDBNot(arg_0);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            this.process((BinaryExpression)expression, (t1, t2) -> (ImmutableExpression)not.apply(flags.getValue().isEmpty() ? ExpressionParser.this.termFactory.getDBRegexpMatches(ImmutableList.of((Object)t1, (Object)t2)) : ExpressionParser.this.termFactory.getDBRegexpMatches(ImmutableList.of((Object)t1, (Object)t2, (Object)flags))));
        }

        public void visit(Between expression) {
            ImmutableTerm t1 = this.termVisitor.getTerm(expression.getLeftExpression());
            ImmutableTerm t2 = this.termVisitor.getTerm(expression.getBetweenExpressionStart());
            ImmutableTerm t3 = this.termVisitor.getTerm(expression.getLeftExpression());
            ImmutableTerm t4 = this.termVisitor.getTerm(expression.getBetweenExpressionEnd());
            if (expression.isNot()) {
                ImmutableExpression e1 = ExpressionParser.this.termFactory.getDBDefaultInequality(InequalityLabel.LT, t1, t2);
                ImmutableExpression e2 = ExpressionParser.this.termFactory.getDBDefaultInequality(InequalityLabel.GT, t3, t4);
                this.result = ImmutableList.of((Object)ExpressionParser.this.termFactory.getDisjunction(e1, new ImmutableExpression[]{e2}));
            } else {
                ImmutableExpression e1 = ExpressionParser.this.termFactory.getDBDefaultInequality(InequalityLabel.GTE, t1, t2);
                ImmutableExpression e2 = ExpressionParser.this.termFactory.getDBDefaultInequality(InequalityLabel.LTE, t3, t4);
                this.result = ImmutableList.of((Object)e1, (Object)e2);
            }
        }

        public void visit(InExpression expression) {
            ImmutableExpression atom;
            ItemsList right;
            if (expression.getOldOracleJoinSyntax() != 0) {
                throw new UnsupportedSelectQueryRuntimeException("Oracle OUTER JOIN syntax is not supported", expression);
            }
            Expression left = expression.getLeftExpression();
            if (left != null) {
                right = expression.getRightItemsList();
                if (right instanceof SubSelect) {
                    throw new UnsupportedSelectQueryRuntimeException("SubSelect in IN is not supported", expression);
                }
                if (right instanceof MultiExpressionList) {
                    throw new InvalidSelectQueryRuntimeException("MultiExpressionList is not allowed with a single expression on the left in IN", expression);
                }
            } else {
                ItemsList list = expression.getLeftItemsList();
                if (!(list instanceof ExpressionList)) {
                    throw new InvalidSelectQueryRuntimeException("Only ExpressionList is allowed on the left of IN", expression);
                }
                ItemsList right2 = expression.getRightItemsList();
                if (right2 instanceof SubSelect) {
                    throw new UnsupportedSelectQueryRuntimeException("SubSelect in IN is not supported", expression);
                }
                if (right2 instanceof ExpressionList) {
                    throw new InvalidSelectQueryRuntimeException("ExpressionList is not allowed with an ExpressionList on the left in IN", expression);
                }
                throw new InvalidSelectQueryRuntimeException("not possible in the current JSQLParser", expression);
            }
            Stream<ImmutableExpression> stream = ((ExpressionList)right).getExpressions().stream().map(item -> {
                ImmutableTerm t1 = this.termVisitor.getTerm(expression.getLeftExpression());
                ImmutableTerm t2 = this.termVisitor.getTerm((Expression)item);
                return ExpressionParser.this.termFactory.getNotYetTypedEquality(t1, t2);
            });
            ImmutableList equalities = ImmutableList.builder().addAll(stream.iterator()).build();
            switch (equalities.size()) {
                case 0: {
                    throw new InvalidSelectQueryRuntimeException("IN must contain at least one expression", expression);
                }
                case 1: {
                    atom = (ImmutableExpression)equalities.get(0);
                    break;
                }
                default: {
                    atom = this.getOR((ImmutableList<ImmutableExpression>)equalities);
                }
            }
            this.result = this.notOperation(expression.isNot()).apply(atom);
        }

        public void visit(Column expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(Function expression) {
            ImmutableList terms = expression.getParameters() != null ? ImmutableList.builder().addAll(expression.getParameters().getExpressions().stream().map(t -> this.termVisitor.getTerm((Expression)t)).iterator()).build() : ImmutableList.of();
            DBBooleanFunctionSymbol functionSymbol = ExpressionParser.this.dbFunctionSymbolFactory.getRegularDBBooleanFunctionSymbol(expression.getName(), terms.size());
            this.result = ImmutableList.of((Object)ExpressionParser.this.termFactory.getImmutableExpression((BooleanFunctionSymbol)functionSymbol, terms));
        }

        public void visit(NullValue expression) {
            throw new UnsupportedSelectQueryRuntimeException("NULL is not supported", expression);
        }

        public void visit(DoubleValue expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(LongValue expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(HexValue expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(StringValue expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(DateValue expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(TimeValue expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(TimestampValue expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(IntervalExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(Addition expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(Subtraction expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(Multiplication expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(Division expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(Modulo expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(SignedExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(Concat expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(ExtractExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(CastExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(UserVariable expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(NumericBind expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(KeepExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(MySQLGroupConcat expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(RowConstructor expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(OracleHint expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(TimeKeyExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(DateTimeLiteralExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression);
        }

        public void visit(NotExpression expression) {
            ImmutableTerm subTerm = this.termVisitor.getTerm(expression.getExpression());
            if (!(subTerm instanceof ImmutableExpression)) {
                throw new UnsupportedSelectQueryRuntimeException("Not a Boolean expression", expression.getExpression());
            }
            this.result = ImmutableList.of((Object)ExpressionParser.this.termFactory.getDBNot((ImmutableExpression)subTerm));
        }

        public void visit(CaseExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("CASE is not supported yet", expression);
        }

        public void visit(WhenClause expression) {
            throw new UnsupportedSelectQueryRuntimeException("CASE/WHEN is not supported yet", expression);
        }

        public void visit(SubSelect expression) {
            throw new UnsupportedSelectQueryRuntimeException("SubSelect is not supported yet", expression);
        }

        public void visit(ExistsExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("EXISTS is not supported yet", expression);
        }

        public void visit(AllComparisonExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("ALL is not supported yet", expression);
        }

        public void visit(AnyComparisonExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("ANY is not supported yet", expression);
        }

        public void visit(BitwiseAnd expression) {
            throw new UnsupportedSelectQueryRuntimeException("Bitwise AND is not supported", expression);
        }

        public void visit(BitwiseOr expression) {
            throw new UnsupportedSelectQueryRuntimeException("Bitwise OR is not supported", expression);
        }

        public void visit(BitwiseXor expression) {
            throw new UnsupportedSelectQueryRuntimeException("Bitwise XOR is not supported", expression);
        }

        public void visit(AnalyticExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("Analytic expressions is not supported", expression);
        }

        public void visit(WithinGroupExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("WithinGroup expressions is not supported", expression);
        }

        public void visit(OracleHierarchicalExpression expression) {
            throw new UnsupportedOperationException("Unexpected Oracle START WITH ... CONNECT BY");
        }

        public void visit(Matches expression) {
            throw new UnsupportedSelectQueryRuntimeException("Oracle @@ not supported", expression);
        }

        public void visit(JsonExpression expression) {
            throw new UnsupportedSelectQueryRuntimeException("JSON expressions are not supported", expression);
        }

        public void visit(JsonOperator expression) {
            throw new UnsupportedSelectQueryRuntimeException("JsonOperator expressions is not supported", expression);
        }

        public void visit(JdbcParameter expression) {
            throw new InvalidSelectQueryRuntimeException("JDBC parameters are not allowed", expression);
        }

        public void visit(JdbcNamedParameter expression) {
            throw new InvalidSelectQueryRuntimeException("JDBC named parameters are not allowed", expression);
        }
    }
}

